/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

public class URLHandler {
    private static final String USER_AGENT = "craftpresence/" + Constants.MCVersion;
    private static Gson GSON = new GsonBuilder().create();

    public static String getURLText(URL url) throws Exception {
        String inputLine;
        BufferedReader in = URLHandler.getURLReader(url);
        StringBuilder response = new StringBuilder();
        while (!StringHandler.isNullOrEmpty(inputLine = in.readLine())) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public static BufferedReader getURLReader(String url) throws Exception {
        return URLHandler.getURLReader(new URL(url));
    }

    public static BufferedReader getURLReader(URL url) throws Exception {
        return new BufferedReader(URLHandler.getURLStreamReader(url));
    }

    public static InputStream getURLStream(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", USER_AGENT);
        return connection.getInputStream();
    }

    public static InputStreamReader getURLStreamReader(URL url) throws Exception {
        return new InputStreamReader(URLHandler.getURLStream(url), Charset.forName("UTF-8"));
    }

    public static <T> T getJSONFromURL(String url, Class<T> clazz) throws Exception {
        return URLHandler.getJSONFromURL(new URL(url), clazz);
    }

    public static <T> T getJSONFromURL(URL url, Class<T> clazz) throws Exception {
        return (T)GSON.fromJson((Reader)URLHandler.getURLStreamReader(url), clazz);
    }
}

