/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler.discord;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.commands.CommandsGUI;
import com.gitlab.cdagaming.craftpresence.handler.curse.ManifestHandler;
import com.gitlab.cdagaming.craftpresence.handler.discord.assets.DiscordAsset;
import com.gitlab.cdagaming.craftpresence.handler.discord.assets.DiscordAssetHandler;
import com.gitlab.cdagaming.craftpresence.handler.discord.rpc.DiscordEventHandlers;
import com.gitlab.cdagaming.craftpresence.handler.discord.rpc.DiscordRPC;
import com.gitlab.cdagaming.craftpresence.handler.discord.rpc.DiscordRichPresence;
import com.gitlab.cdagaming.craftpresence.handler.discord.rpc.DiscordUser;
import com.gitlab.cdagaming.craftpresence.handler.mcupdater.MCUpdaterHandler;
import com.gitlab.cdagaming.craftpresence.handler.multimc.InstanceHandler;
import com.gitlab.cdagaming.craftpresence.handler.technic.PackHandler;
import com.sun.jna.NativeLibrary;
import java.io.File;
import net.minecraft.client.gui.GuiScreen;

public class DiscordHandler {
    private final DiscordEventHandlers handlers = new DiscordEventHandlers();
    public DiscordUser CURRENT_USER;
    public DiscordUser REQUESTER_USER;
    public String STATUS;
    public String GAME_STATE;
    public String DETAILS;
    public String SMALLIMAGEKEY;
    public String SMALLIMAGETEXT;
    public String LARGEIMAGEKEY;
    public String LARGEIMAGETEXT;
    public String CLIENT_ID;
    public long START_TIMESTAMP;
    public String PARTY_ID;
    public int PARTY_SIZE;
    public int PARTY_MAX;
    public String JOIN_SECRET;
    public long END_TIMESTAMP;
    public String MATCH_SECRET;
    public String SPECTATE_SECRET;
    public byte INSTANCE;
    private String lastImageRequested;
    private String lastImageTypeRequested;
    private String lastClientIDRequested;
    private int lastErrorCode;
    private int lastDisconnectErrorCode;

    public synchronized void setup() {
        Thread shutdownThread = new Thread("CraftPresence-ShutDown-Handler"){

            @Override
            public void run() {
                CraftPresence.closing = true;
                CraftPresence.timerObj.cancel();
                DiscordHandler.this.shutDown();
            }
        };
        shutdownThread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    public synchronized void init() {
        this.handlers.errored = new DiscordEventHandlers.OnStatus(){

            @Override
            public void accept(int errorCode, String message) {
                if (StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) || !StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) && (!DiscordHandler.this.STATUS.equalsIgnoreCase("errored") || DiscordHandler.this.lastErrorCode != errorCode)) {
                    DiscordHandler.this.STATUS = "errored";
                    DiscordHandler.this.lastErrorCode = errorCode;
                    DiscordHandler.this.shutDown();
                    Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.rpc", errorCode, message), new Object[0]);
                }
            }
        };
        this.handlers.disconnected = new DiscordEventHandlers.OnStatus(){

            @Override
            public void accept(int errorCode, String message) {
                if (StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) || !StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) && (!DiscordHandler.this.STATUS.equalsIgnoreCase("disconnected") || DiscordHandler.this.lastDisconnectErrorCode != errorCode)) {
                    DiscordHandler.this.STATUS = "disconnected";
                    DiscordHandler.this.lastDisconnectErrorCode = errorCode;
                    DiscordHandler.this.shutDown();
                }
            }
        };
        this.handlers.ready = new DiscordEventHandlers.OnReady(){

            @Override
            public void accept(DiscordUser user) {
                if (StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) || DiscordHandler.this.CURRENT_USER == null || !StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) && (!DiscordHandler.this.STATUS.equalsIgnoreCase("ready") || !DiscordHandler.this.CURRENT_USER.equals((Object)user))) {
                    DiscordHandler.this.STATUS = "ready";
                    DiscordHandler.this.CURRENT_USER = user;
                    Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.load", DiscordHandler.this.CLIENT_ID, DiscordHandler.this.CURRENT_USER.username), new Object[0]);
                }
            }
        };
        this.handlers.joinGame = new DiscordEventHandlers.OnGameUpdate(){

            @Override
            public void accept(String secret) {
                if (StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) || !StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) && !DiscordHandler.this.STATUS.equalsIgnoreCase("joinGame")) {
                    DiscordHandler.this.STATUS = "joinGame";
                    CraftPresence.SERVER.verifyAndJoin(secret);
                }
            }
        };
        this.handlers.joinRequest = new DiscordEventHandlers.OnJoinRequest(){

            @Override
            public void accept(DiscordUser request) {
                if (StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) || !StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) && (!DiscordHandler.this.STATUS.equalsIgnoreCase("joinRequest") || !DiscordHandler.this.REQUESTER_USER.equals((Object)request))) {
                    CraftPresence.SYSTEM.TIMER = 30;
                    DiscordHandler.this.STATUS = "joinRequest";
                    DiscordHandler.this.REQUESTER_USER = request;
                    if (!(CraftPresence.instance.field_71462_r instanceof CommandsGUI)) {
                        CraftPresence.instance.func_147108_a((GuiScreen)new CommandsGUI(CraftPresence.instance.field_71462_r));
                    }
                    CommandsGUI.executeCommand("request");
                }
            }
        };
        this.handlers.spectateGame = new DiscordEventHandlers.OnGameUpdate(){

            @Override
            public void accept(String secret) {
                if (StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) || !StringHandler.isNullOrEmpty(DiscordHandler.this.STATUS) && !DiscordHandler.this.STATUS.equalsIgnoreCase("spectateGame")) {
                    DiscordHandler.this.STATUS = "spectateGame";
                }
            }
        };
        DiscordRPC.INSTANCE.Discord_Initialize(this.CLIENT_ID, this.handlers, true, null);
    }

    public void updateTimestamp() {
        if (CraftPresence.CONFIG.showTime) {
            this.START_TIMESTAMP = CraftPresence.SYSTEM.CURRENT_TIMESTAMP / 1000L;
        }
    }

    public void updatePresence(DiscordRichPresence presence) {
        if (presence != null) {
            if (Constants.BRAND.contains("vivecraft")) {
                CraftPresence.packFound = true;
                presence.details = presence.details + (!StringHandler.isNullOrEmpty(presence.details) ? " | " : "") + CraftPresence.CONFIG.vivecraftMessage;
            } else if (ManifestHandler.manifest != null && !StringHandler.isNullOrEmpty(ManifestHandler.manifest.name)) {
                presence.details = presence.details + (!StringHandler.isNullOrEmpty(presence.details) ? " | " : "") + CraftPresence.CONFIG.packPlaceholderMSG.replace("&name&", StringHandler.formatWord(ManifestHandler.manifest.name));
            } else if (!StringHandler.isNullOrEmpty(InstanceHandler.INSTANCE_NAME)) {
                presence.details = presence.details + (!StringHandler.isNullOrEmpty(presence.details) ? " | " : "") + CraftPresence.CONFIG.packPlaceholderMSG.replace("&name&", StringHandler.formatWord(InstanceHandler.INSTANCE_NAME));
            } else if (MCUpdaterHandler.instance != null && !StringHandler.isNullOrEmpty(MCUpdaterHandler.instance.getPackName())) {
                presence.details = presence.details + (!StringHandler.isNullOrEmpty(presence.details) ? " | " : "") + CraftPresence.CONFIG.packPlaceholderMSG.replace("&name&", StringHandler.formatWord(MCUpdaterHandler.instance.getPackName()));
            } else if (!StringHandler.isNullOrEmpty(PackHandler.PACK_NAME)) {
                presence.details = presence.details + (!StringHandler.isNullOrEmpty(presence.details) ? " | " : "") + CraftPresence.CONFIG.packPlaceholderMSG.replace("&name&", StringHandler.formatWord(PackHandler.PACK_NAME));
            }
            if (StringHandler.isNullOrEmpty(presence.smallImageKey) && StringHandler.isNullOrEmpty(presence.smallImageText) || CraftPresence.CONFIG.overwriteServerIcon) {
                if (Constants.BRAND.contains("vivecraft") && DiscordAssetHandler.contains("vivecraft")) {
                    presence.smallImageKey = "vivecraft";
                    presence.smallImageText = CraftPresence.CONFIG.vivecraftMessage;
                } else if (ManifestHandler.manifest != null && !StringHandler.isNullOrEmpty(ManifestHandler.manifest.name)) {
                    String iconKey = StringHandler.formatPackIcon(ManifestHandler.manifest.name);
                    if (DiscordAssetHandler.contains(iconKey)) {
                        presence.smallImageKey = iconKey;
                        presence.smallImageText = CraftPresence.CONFIG.packPlaceholderMSG.replace("&name&", StringHandler.formatWord(ManifestHandler.manifest.name));
                    }
                } else if (!StringHandler.isNullOrEmpty(InstanceHandler.INSTANCE_NAME) && !StringHandler.isNullOrEmpty(InstanceHandler.ICON_KEY) && DiscordAssetHandler.contains(InstanceHandler.ICON_KEY)) {
                    presence.smallImageKey = InstanceHandler.ICON_KEY;
                    presence.smallImageText = CraftPresence.CONFIG.packPlaceholderMSG.replace("&name&", StringHandler.formatWord(InstanceHandler.INSTANCE_NAME));
                } else if (!StringHandler.isNullOrEmpty(PackHandler.PACK_NAME) && !StringHandler.isNullOrEmpty(PackHandler.ICON_NAME) && DiscordAssetHandler.contains(PackHandler.ICON_NAME)) {
                    presence.smallImageKey = PackHandler.ICON_NAME;
                    presence.smallImageText = CraftPresence.CONFIG.packPlaceholderMSG.replace("&name&", PackHandler.PACK_NAME);
                }
            }
            presence.largeImageKey = StringHandler.isNullOrEmpty(presence.largeImageKey) ? CraftPresence.CONFIG.defaultIcon : presence.largeImageKey;
            presence.largeImageText = StringHandler.isNullOrEmpty(presence.largeImageText) ? Constants.TRANSLATOR.translate("craftpresence.defaults.state.mcversion", Constants.MCVersion) : presence.largeImageText;
            DiscordRPC.INSTANCE.Discord_UpdatePresence(presence);
        }
    }

    public synchronized void shutDown() {
        DiscordRPC.INSTANCE.Discord_ClearPresence();
        DiscordRPC.INSTANCE.Discord_Shutdown();
        CraftPresence.DIMENSIONS.clearClientData();
        CraftPresence.ENTITIES.clearClientData();
        CraftPresence.BIOMES.clearClientData();
        CraftPresence.SERVER.clearClientData();
        CraftPresence.GUIS.clearClientData();
        this.STATUS = "disconnected";
        this.lastDisconnectErrorCode = 0;
        this.lastErrorCode = 0;
        CraftPresence.SYSTEM.TIMER = 0;
        this.CURRENT_USER = null;
        this.REQUESTER_USER = null;
        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.shutdown", new Object[0]), new Object[0]);
    }

    public void setImage(String key, DiscordAsset.AssetType type) {
        if (!StringHandler.isNullOrEmpty(key) && type != null) {
            String formattedKey = StringHandler.formatPackIcon(key);
            if (StringHandler.isNullOrEmpty(this.lastImageRequested) || !this.lastImageRequested.equals(key) || StringHandler.isNullOrEmpty(this.lastImageTypeRequested) || !this.lastImageTypeRequested.equals(type.name()) || StringHandler.isNullOrEmpty(this.lastClientIDRequested) || !this.lastClientIDRequested.equals(this.CLIENT_ID)) {
                this.lastClientIDRequested = this.CLIENT_ID;
                this.lastImageRequested = key;
                this.lastImageTypeRequested = type.name();
                if (DiscordAssetHandler.contains(formattedKey)) {
                    if (type.equals((Object)DiscordAsset.AssetType.LARGE)) {
                        this.LARGEIMAGEKEY = formattedKey;
                    }
                    if (type.equals((Object)DiscordAsset.AssetType.SMALL)) {
                        this.SMALLIMAGEKEY = formattedKey;
                    }
                } else {
                    Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.fallback", formattedKey, type.name()), new Object[0]);
                    Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.request", formattedKey, type.name()), new Object[0]);
                    String defaultIcon = StringHandler.formatPackIcon(CraftPresence.CONFIG.defaultIcon);
                    String defaultDimensionIcon = StringHandler.formatPackIcon(StringHandler.getConfigPart(CraftPresence.CONFIG.dimensionMessages, "default", 0, 2, CraftPresence.CONFIG.splitCharacter, CraftPresence.CONFIG.defaultDimensionIcon).replace("&icon&", defaultIcon));
                    String defaultServerIcon = StringHandler.formatPackIcon(StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, "default", 0, 2, CraftPresence.CONFIG.splitCharacter, CraftPresence.CONFIG.defaultServerIcon).replace("&icon&", defaultIcon));
                    if (type.equals((Object)DiscordAsset.AssetType.LARGE)) {
                        if (CraftPresence.DIMENSIONS.isInUse) {
                            String formattedCurrentDIMNameIcon = StringHandler.formatPackIcon(CraftPresence.DIMENSIONS.CURRENT_DIMENSION_NAME);
                            if (DiscordAssetHandler.contains(formattedCurrentDIMNameIcon)) {
                                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.fallback", formattedKey, type.name(), formattedCurrentDIMNameIcon), new Object[0]);
                                this.LARGEIMAGEKEY = formattedCurrentDIMNameIcon;
                            } else {
                                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.default", formattedKey, type.name()), new Object[0]);
                                this.LARGEIMAGEKEY = DiscordAssetHandler.contains(defaultDimensionIcon) ? defaultDimensionIcon : defaultIcon;
                            }
                        } else {
                            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.default", formattedKey, type.name()), new Object[0]);
                            this.LARGEIMAGEKEY = defaultIcon;
                        }
                    }
                    if (type.equals((Object)DiscordAsset.AssetType.SMALL)) {
                        if (CraftPresence.SERVER.isInUse) {
                            boolean matched = false;
                            for (String ipPart : CraftPresence.SERVER.currentServer_IP.split("\\.")) {
                                String formattedIPPart = StringHandler.formatPackIcon(ipPart);
                                if (!DiscordAssetHandler.contains(formattedIPPart)) continue;
                                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.fallback", formattedKey, type.name(), formattedIPPart), new Object[0]);
                                this.SMALLIMAGEKEY = formattedIPPart;
                                matched = true;
                                break;
                            }
                            if (!matched) {
                                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.default", formattedKey, type.name()), new Object[0]);
                                this.SMALLIMAGEKEY = DiscordAssetHandler.contains(defaultServerIcon) ? defaultServerIcon : defaultIcon;
                            }
                        } else {
                            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.default", formattedKey, type.name()), new Object[0]);
                            this.SMALLIMAGEKEY = defaultIcon;
                        }
                    }
                }
            }
        }
    }

    public DiscordRichPresence buildRichPresence() {
        return new DiscordRichPresence(this.GAME_STATE, this.DETAILS, this.START_TIMESTAMP, this.END_TIMESTAMP, this.LARGEIMAGEKEY, this.LARGEIMAGETEXT, this.SMALLIMAGEKEY, this.SMALLIMAGETEXT, this.PARTY_ID, this.PARTY_SIZE, this.PARTY_MAX, this.MATCH_SECRET, this.JOIN_SECRET, this.SPECTATE_SECRET, this.INSTANCE);
    }

    static {
        NativeLibrary.addSearchPath((String)"discord-rpc", (String)new File("craftpresence").getAbsolutePath());
    }
}

