/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler.discord.assets;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.URLHandler;
import com.gitlab.cdagaming.craftpresence.handler.discord.assets.DiscordAsset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class DiscordAssetHandler {
    public static List<String> SMALL_ICONS = Lists.newArrayList();
    public static List<String> LARGE_ICONS = Lists.newArrayList();
    public static List<String> ICON_LIST = Lists.newArrayList();
    private static List<String> SMALL_IDS = Lists.newArrayList();
    private static List<String> LARGE_IDS = Lists.newArrayList();
    private static List<String> ICON_IDS = Lists.newArrayList();
    private static Map<String, DiscordAsset> ASSET_LIST = Maps.newHashMap();

    public static boolean contains(String key) {
        String formattedKey = StringHandler.formatPackIcon(key.replace(" ", "_"));
        return ASSET_LIST.containsKey(formattedKey);
    }

    public static DiscordAsset get(String key) {
        String formattedKey = StringHandler.formatPackIcon(key.replace(" ", "_"));
        return DiscordAssetHandler.contains(formattedKey) ? ASSET_LIST.get(formattedKey) : null;
    }

    public static String getKey(String key) {
        String formattedKey = StringHandler.formatPackIcon(key.replace(" ", "_"));
        return DiscordAssetHandler.contains(formattedKey) ? ASSET_LIST.get(formattedKey).getName() : null;
    }

    public static String getID(String key) {
        String formattedKey = StringHandler.formatPackIcon(key.replace(" ", "_"));
        return DiscordAssetHandler.contains(formattedKey) ? ASSET_LIST.get(formattedKey).getId() : null;
    }

    public static DiscordAsset.AssetType getType(String key) {
        String formattedKey = key.replace(" ", "_").toLowerCase();
        return DiscordAssetHandler.contains(formattedKey) ? ASSET_LIST.get(formattedKey).getType() : DiscordAsset.AssetType.LARGE;
    }

    public static void emptyData() {
        ASSET_LIST.clear();
        SMALL_ICONS.clear();
        SMALL_IDS.clear();
        LARGE_ICONS.clear();
        LARGE_IDS.clear();
        ICON_LIST.clear();
        ICON_IDS.clear();
    }

    public static String getRandomAsset() {
        try {
            Random randomObj = new Random();
            return ICON_LIST.get(randomObj.nextInt(ICON_LIST.size()));
        }
        catch (Exception ex) {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.invalidicon.empty", new Object[0]), new Object[0]);
            ex.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAssets() {
        block13: {
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load", CraftPresence.CONFIG.clientID), new Object[0]);
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load.credits", new Object[0]), new Object[0]);
            ASSET_LIST = Maps.newHashMap();
            try {
                String url = "https://discordapp.com/api/oauth2/applications/" + CraftPresence.CONFIG.clientID + "/assets";
                DiscordAsset[] assets = URLHandler.getJSONFromURL(url, DiscordAsset[].class);
                if (assets == null) break block13;
                for (DiscordAsset asset : assets) {
                    if (asset.getType().equals((Object)DiscordAsset.AssetType.LARGE)) {
                        if (!LARGE_ICONS.contains(asset.getName())) {
                            LARGE_ICONS.add(asset.getName());
                        }
                        if (!LARGE_IDS.contains(asset.getId())) {
                            LARGE_IDS.add(asset.getId());
                        }
                    }
                    if (asset.getType().equals((Object)DiscordAsset.AssetType.SMALL)) {
                        if (!SMALL_ICONS.contains(asset.getName())) {
                            SMALL_ICONS.add(asset.getName());
                        }
                        if (!SMALL_IDS.contains(asset.getId())) {
                            SMALL_IDS.add(asset.getId());
                        }
                    }
                    if (!ICON_LIST.contains(asset.getName())) {
                        ICON_LIST.add(asset.getName());
                    }
                    if (!ASSET_LIST.containsKey(asset.getName())) {
                        ASSET_LIST.put(asset.getName(), asset);
                    }
                    if (ICON_IDS.contains(asset.getId())) continue;
                    ICON_IDS.add(asset.getId());
                }
            }
            catch (Exception ex) {
                try {
                    Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.load", new Object[0]), new Object[0]);
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DiscordAssetHandler.verifyConfigAssets();
                    Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
                    throw throwable;
                }
                DiscordAssetHandler.verifyConfigAssets();
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
            }
        }
        DiscordAssetHandler.verifyConfigAssets();
        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
    }

    private static void verifyConfigAssets() {
        boolean needsFullUpdate = false;
        for (String property : CraftPresence.CONFIG.properties.stringPropertyNames()) {
            if (!property.equals(CraftPresence.CONFIG.NAME_defaultIcon) && !property.equals(CraftPresence.CONFIG.NAME_defaultDimensionIcon) && !property.equals(CraftPresence.CONFIG.NAME_defaultServerIcon) || DiscordAssetHandler.contains(CraftPresence.CONFIG.properties.getProperty(property))) continue;
            String newAsset = DiscordAssetHandler.contains(CraftPresence.CONFIG.defaultIcon) ? CraftPresence.CONFIG.defaultIcon : DiscordAssetHandler.getRandomAsset();
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.invalidicon.pre", CraftPresence.CONFIG.properties.getProperty(property), property), new Object[0]);
            CraftPresence.CONFIG.properties.setProperty(property, newAsset);
            needsFullUpdate = true;
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.config.invalidicon.post", property, newAsset), new Object[0]);
        }
        if (needsFullUpdate) {
            CraftPresence.CONFIG.save();
            CraftPresence.CONFIG.read(false);
        }
    }
}

