/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class EntityHandler {
    public boolean isInUse = false;
    public boolean allItemsEmpty = false;
    public boolean enabled = false;
    public List<String> ENTITY_NAMES = Lists.newArrayList();
    private List<String> BLOCK_NAMES = Lists.newArrayList();
    private List<String> BLOCK_CLASSES = Lists.newArrayList();
    private List<String> ITEM_NAMES = Lists.newArrayList();
    private List<String> ITEM_CLASSES = Lists.newArrayList();
    private List<String> ENTITY_CLASSES = Lists.newArrayList();
    private ItemStack EMPTY = new ItemStack((Item)null);
    private ItemStack CURRENT_MAINHAND_ITEM;
    private ItemStack CURRENT_OFFHAND_ITEM;
    private ItemStack CURRENT_HELMET;
    private ItemStack CURRENT_CHEST;
    private ItemStack CURRENT_LEGS;
    private ItemStack CURRENT_BOOTS;
    private String CURRENT_MAINHAND_ITEM_NAME;
    private String CURRENT_OFFHAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;
    private boolean queuedForUpdate = false;

    private void emptyData() {
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.ENTITY_NAMES.clear();
        this.ENTITY_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_MAINHAND_ITEM = this.EMPTY;
        this.CURRENT_OFFHAND_ITEM = this.EMPTY;
        this.CURRENT_MAINHAND_ITEM_NAME = null;
        this.CURRENT_OFFHAND_ITEM_NAME = null;
        this.CURRENT_HELMET = this.EMPTY;
        this.CURRENT_CHEST = this.EMPTY;
        this.CURRENT_LEGS = this.EMPTY;
        this.CURRENT_BOOTS = this.EMPTY;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        this.queuedForUpdate = false;
        this.allItemsEmpty = true;
        this.isInUse = false;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePERItem : this.enabled;
        this.isInUse = this.enabled && CraftPresence.player != null;
        boolean bl = needsUpdate = this.enabled && (this.ENTITY_NAMES.isEmpty() || this.ENTITY_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getEntities();
        }
        if (this.isInUse) {
            this.updateEntityData();
            if (this.enabled && (CraftPresence.player == null || this.allItemsEmpty)) {
                this.clearClientData();
            } else if (!this.enabled) {
                this.emptyData();
            }
        }
    }

    private boolean isEmpty(Item item) {
        return item == null || this.isEmpty(this.getDefaultInstance(item));
    }

    private boolean isEmpty(Block block) {
        return block == null || this.isEmpty(Item.func_150898_a((Block)block));
    }

    private ItemStack getDefaultInstance(Item itemIn) {
        return new ItemStack(itemIn);
    }

    private boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null || itemStack == this.EMPTY) {
            return true;
        }
        if (itemStack.func_77973_b() != null && itemStack.func_77973_b() != Items.field_190931_a) {
            if (itemStack.func_190916_E() <= 0) {
                return true;
            }
            return itemStack.func_77952_i() < Short.MIN_VALUE || itemStack.func_77952_i() > 65535;
        }
        return true;
    }

    private void updateEntityData() {
        boolean hasBootsChanged;
        ItemStack NEW_CURRENT_MAINHAND_ITEM = CraftPresence.player.func_184614_ca();
        ItemStack NEW_CURRENT_OFFHAND_ITEM = CraftPresence.player.func_184592_cb();
        ItemStack NEW_CURRENT_HELMET = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(3);
        ItemStack NEW_CURRENT_CHEST = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(2);
        ItemStack NEW_CURRENT_LEGS = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(1);
        ItemStack NEW_CURRENT_BOOTS = (ItemStack)CraftPresence.player.field_71071_by.field_70460_b.get(0);
        String NEW_CURRENT_MAINHAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_MAINHAND_ITEM) ? StringHandler.stripColors(NEW_CURRENT_MAINHAND_ITEM.func_82833_r()) : "";
        String NEW_CURRENT_OFFHAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) ? StringHandler.stripColors(NEW_CURRENT_OFFHAND_ITEM.func_82833_r()) : "";
        String NEW_CURRENT_HELMET_NAME = !this.isEmpty(NEW_CURRENT_HELMET) ? StringHandler.stripColors(NEW_CURRENT_HELMET.func_82833_r()) : "";
        String NEW_CURRENT_CHEST_NAME = !this.isEmpty(NEW_CURRENT_CHEST) ? StringHandler.stripColors(NEW_CURRENT_CHEST.func_82833_r()) : "";
        String NEW_CURRENT_LEGS_NAME = !this.isEmpty(NEW_CURRENT_LEGS) ? StringHandler.stripColors(NEW_CURRENT_LEGS.func_82833_r()) : "";
        String NEW_CURRENT_BOOTS_NAME = !this.isEmpty(NEW_CURRENT_BOOTS) ? StringHandler.stripColors(NEW_CURRENT_BOOTS.func_82833_r()) : "";
        boolean hasMainHandChanged = !this.isEmpty(NEW_CURRENT_MAINHAND_ITEM) && !NEW_CURRENT_MAINHAND_ITEM.equals(this.CURRENT_MAINHAND_ITEM) || !NEW_CURRENT_MAINHAND_ITEM_NAME.equals(this.CURRENT_MAINHAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_MAINHAND_ITEM) && !this.isEmpty(this.CURRENT_MAINHAND_ITEM);
        boolean hasOffHandChanged = !this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) && !NEW_CURRENT_OFFHAND_ITEM.equals(this.CURRENT_OFFHAND_ITEM) || !NEW_CURRENT_OFFHAND_ITEM_NAME.equals(this.CURRENT_OFFHAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_OFFHAND_ITEM) && !this.isEmpty(this.CURRENT_OFFHAND_ITEM);
        boolean hasHelmetChanged = !this.isEmpty(NEW_CURRENT_HELMET) && !NEW_CURRENT_HELMET.equals(this.CURRENT_HELMET) || !NEW_CURRENT_HELMET_NAME.equals(this.CURRENT_HELMET_NAME) || this.isEmpty(NEW_CURRENT_HELMET) && !this.isEmpty(this.CURRENT_HELMET);
        boolean hasChestChanged = !this.isEmpty(NEW_CURRENT_CHEST) && !NEW_CURRENT_CHEST.equals(this.CURRENT_CHEST) || !NEW_CURRENT_CHEST_NAME.equals(this.CURRENT_CHEST_NAME) || this.isEmpty(NEW_CURRENT_CHEST) && !this.isEmpty(this.CURRENT_CHEST);
        boolean hasLegsChanged = !this.isEmpty(NEW_CURRENT_LEGS) && !NEW_CURRENT_LEGS.equals(this.CURRENT_LEGS) || !NEW_CURRENT_LEGS_NAME.equals(this.CURRENT_LEGS_NAME) || this.isEmpty(NEW_CURRENT_LEGS) && !this.isEmpty(this.CURRENT_LEGS);
        boolean bl = hasBootsChanged = !this.isEmpty(NEW_CURRENT_BOOTS) && !NEW_CURRENT_BOOTS.equals(this.CURRENT_BOOTS) || !NEW_CURRENT_BOOTS_NAME.equals(this.CURRENT_BOOTS_NAME) || this.isEmpty(NEW_CURRENT_BOOTS) && !this.isEmpty(this.CURRENT_BOOTS);
        if (hasMainHandChanged || hasOffHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            this.CURRENT_MAINHAND_ITEM = NEW_CURRENT_MAINHAND_ITEM;
            this.CURRENT_OFFHAND_ITEM = NEW_CURRENT_OFFHAND_ITEM;
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_MAINHAND_ITEM_NAME = NEW_CURRENT_MAINHAND_ITEM_NAME;
            this.CURRENT_OFFHAND_ITEM_NAME = NEW_CURRENT_OFFHAND_ITEM_NAME;
            this.CURRENT_HELMET_NAME = NEW_CURRENT_HELMET_NAME;
            this.CURRENT_CHEST_NAME = NEW_CURRENT_CHEST_NAME;
            this.CURRENT_LEGS_NAME = NEW_CURRENT_LEGS_NAME;
            this.CURRENT_BOOTS_NAME = NEW_CURRENT_BOOTS_NAME;
            this.allItemsEmpty = this.isEmpty(this.CURRENT_MAINHAND_ITEM) && this.isEmpty(this.CURRENT_OFFHAND_ITEM) && this.isEmpty(this.CURRENT_HELMET) && this.isEmpty(this.CURRENT_CHEST) && this.isEmpty(this.CURRENT_LEGS) && this.isEmpty(this.CURRENT_BOOTS);
            this.queuedForUpdate = true;
        }
        if (this.queuedForUpdate) {
            this.updateEntityPresence();
        }
    }

    public void updateEntityPresence() {
        String defaultItemMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.itemMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String offHandItemMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_OFFHAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_OFFHAND_ITEM_NAME);
        String offHandSelector = !this.isEmpty(this.CURRENT_OFFHAND_ITEM) && !StringHandler.isNullOrEmpty(this.CURRENT_OFFHAND_ITEM_NAME) ? this.CURRENT_OFFHAND_ITEM_NAME : "";
        String formattedOffHandItemMSG = offHandItemMSG.replace("&main&", offHandSelector).replace("&offhand&", "").replace("&helmet&", "").replace("&chest&", "").replace("&legs&", "").replace("&boots&", "");
        String mainHandSelector = !this.isEmpty(this.CURRENT_MAINHAND_ITEM) && !StringHandler.isNullOrEmpty(this.CURRENT_MAINHAND_ITEM_NAME) ? this.CURRENT_MAINHAND_ITEM_NAME : offHandSelector;
        String mainItemMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_MAINHAND_ITEM_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultItemMSG);
        String helmetSelector = !this.isEmpty(this.CURRENT_HELMET) && !StringHandler.isNullOrEmpty(this.CURRENT_HELMET_NAME) ? this.CURRENT_HELMET_NAME : "";
        String helmetMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_HELMET_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_HELMET_NAME);
        String formattedHelmetMSG = helmetMSG.replace("&main&", helmetSelector).replace("&offhand&", "").replace("&helmet&", "").replace("&chest&", "").replace("&legs&", "").replace("&boots&", "");
        String chestSelector = !this.isEmpty(this.CURRENT_CHEST) && !StringHandler.isNullOrEmpty(this.CURRENT_CHEST_NAME) ? this.CURRENT_CHEST_NAME : "";
        String chestMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_CHEST_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_CHEST_NAME);
        String formattedChestMSG = chestMSG.replace("&main&", chestSelector).replace("&offhand&", "").replace("&helmet&", "").replace("&chest&", "").replace("&legs&", "").replace("&boots&", "");
        String legsSelector = !this.isEmpty(this.CURRENT_LEGS) && !StringHandler.isNullOrEmpty(this.CURRENT_LEGS_NAME) ? this.CURRENT_LEGS_NAME : "";
        String legsMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_LEGS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_LEGS_NAME);
        String formattedLegsMSG = legsMSG.replace("&main&", legsSelector).replace("&offhand&", "").replace("&helmet&", "").replace("&chest&", "").replace("&legs&", "").replace("&boots&", "");
        String bootsSelector = !this.isEmpty(this.CURRENT_BOOTS) && !StringHandler.isNullOrEmpty(this.CURRENT_BOOTS_NAME) ? this.CURRENT_BOOTS_NAME : "";
        String bootsMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.itemMessages, this.CURRENT_BOOTS_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, this.CURRENT_BOOTS_NAME);
        String formattedBootsMSG = bootsMSG.replace("&main&", bootsSelector).replace("&offhand&", "").replace("&helmet&", "").replace("&chest&", "").replace("&legs&", "").replace("&boots&", "");
        if (!this.allItemsEmpty) {
            CraftPresence.CLIENT.LARGEIMAGETEXT = mainItemMSG.replace("&main&", mainHandSelector).replace("&offhand&", formattedOffHandItemMSG).replace("&helmet&", formattedHelmetMSG).replace("&chest&", formattedChestMSG).replace("&legs&", formattedLegsMSG).replace("&boots&", formattedBootsMSG);
        } else if (CraftPresence.DIMENSIONS.isInUse) {
            CraftPresence.CLIENT.LARGEIMAGETEXT = CraftPresence.CLIENT.DETAILS;
        }
        CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
        this.queuedForUpdate = false;
    }

    public void getEntities() {
        NonNullList subtypes;
        for (Block block : Block.field_149771_c) {
            if (this.isEmpty(block)) continue;
            subtypes = NonNullList.func_191196_a();
            for (Object tab : CreativeTabs.field_78032_a) {
                if (tab == null) continue;
                block.func_149666_a(tab, subtypes);
            }
            if (!subtypes.isEmpty()) {
                for (ItemStack itemStack : subtypes) {
                    if (this.isEmpty(itemStack)) continue;
                    if (!this.BLOCK_NAMES.contains(itemStack.func_82833_r())) {
                        this.BLOCK_NAMES.add(itemStack.func_82833_r());
                    }
                    if (this.BLOCK_CLASSES.contains(itemStack.func_77973_b().getClass().getName())) continue;
                    this.BLOCK_CLASSES.add(itemStack.func_77973_b().getClass().getName());
                }
                continue;
            }
            if (!this.BLOCK_NAMES.contains(block.func_149732_F())) {
                this.BLOCK_NAMES.add(block.func_149732_F());
            }
            if (this.BLOCK_CLASSES.contains(block.getClass().getName())) continue;
            this.BLOCK_CLASSES.add(block.getClass().getName());
        }
        for (Item item : Item.field_150901_e) {
            if (this.isEmpty(item)) continue;
            subtypes = NonNullList.func_191196_a();
            for (Object tab : CreativeTabs.field_78032_a) {
                if (tab == null) continue;
                item.func_150895_a(tab, subtypes);
            }
            if (!subtypes.isEmpty()) {
                for (ItemStack itemStack : subtypes) {
                    if (this.isEmpty(itemStack)) continue;
                    if (!this.ITEM_NAMES.contains(itemStack.func_82833_r())) {
                        this.ITEM_NAMES.add(itemStack.func_82833_r());
                    }
                    if (this.ITEM_CLASSES.contains(itemStack.func_77973_b().getClass().getName())) continue;
                    this.ITEM_CLASSES.add(itemStack.func_77973_b().getClass().getName());
                }
                continue;
            }
            if (!this.ITEM_NAMES.contains(item.func_77653_i(this.getDefaultInstance(item)))) {
                this.ITEM_NAMES.add(item.func_77653_i(this.getDefaultInstance(item)));
            }
            if (this.ITEM_CLASSES.contains(item.getClass().getName())) continue;
            this.ITEM_CLASSES.add(item.getClass().getName());
        }
        for (String itemMessage : CraftPresence.CONFIG.itemMessages) {
            String[] part;
            if (StringHandler.isNullOrEmpty(itemMessage) || StringHandler.isNullOrEmpty((part = itemMessage.split(CraftPresence.CONFIG.splitCharacter))[0])) continue;
            if (!this.ITEM_NAMES.contains(part[0])) {
                this.ITEM_NAMES.add(part[0]);
            }
            if (this.BLOCK_NAMES.contains(part[0])) continue;
            this.BLOCK_NAMES.add(part[0]);
        }
        this.verifyEntities();
    }

    private void verifyEntities() {
        ArrayList removingBlocks = Lists.newArrayList();
        ArrayList removingItems = Lists.newArrayList();
        for (String itemName : this.ITEM_NAMES) {
            String lowerItemName = itemName.toLowerCase();
            if (!lowerItemName.contains("tile.") && !lowerItemName.contains("item.") && !lowerItemName.contains(".") && !lowerItemName.contains(".name")) continue;
            removingItems.add(itemName);
        }
        for (String blockName : this.BLOCK_NAMES) {
            String lowerBlockName = blockName.toLowerCase();
            if (!lowerBlockName.contains("tile.") && !lowerBlockName.contains("item.") && !lowerBlockName.contains(".") && !lowerBlockName.contains(".name")) continue;
            removingBlocks.add(blockName);
        }
        this.ITEM_NAMES.removeAll(removingItems);
        this.ITEM_NAMES.removeAll(this.BLOCK_NAMES);
        this.BLOCK_NAMES.removeAll(this.ITEM_NAMES);
        this.BLOCK_NAMES.removeAll(removingBlocks);
        this.ENTITY_NAMES.addAll(this.BLOCK_NAMES);
        this.ENTITY_NAMES.addAll(this.ITEM_NAMES);
        this.ENTITY_CLASSES.addAll(this.BLOCK_CLASSES);
        this.ENTITY_CLASSES.addAll(this.ITEM_CLASSES);
    }
}

