/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler.gui;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.ConfigGUI_Main;
import com.gitlab.cdagaming.craftpresence.handler.FileHandler;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.gui.controls.GUICheckBox;
import com.gitlab.cdagaming.craftpresence.handler.gui.controls.GUIExtendedButton;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIHandler {
    public boolean openConfigGUI = false;
    public boolean configGUIOpened = false;
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> GUI_NAMES = Lists.newArrayList();
    private String CURRENT_GUI_NAME;
    private Class CURRENT_GUI_CLASS;
    private GuiScreen CURRENT_SCREEN;
    private List<Class> GUI_CLASSES = Lists.newArrayList();
    private boolean queuedForUpdate = false;

    private static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)x, (double)(y + height), zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)y, zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)x, (double)y, zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return mouseX >= elementX && mouseX <= elementX + elementWidth && mouseY >= elementY && mouseY <= elementY + elementHeight;
    }

    public boolean isMouseOver(double mouseX, double mouseY, GUIExtendedButton button) {
        return this.isMouseOver(mouseX, mouseY, button.field_146128_h, button.field_146129_i, button.getWidth() - 1, button.getHeight() - 1);
    }

    public boolean isMouseOver(double mouseX, double mouseY, GUICheckBox checkBox) {
        return this.isMouseOver(mouseX, mouseY, checkBox.field_146128_h, checkBox.field_146129_i, checkBox.boxWidth - 1, checkBox.getHeight() - 1);
    }

    private void emptyData() {
        this.GUI_NAMES.clear();
        this.GUI_CLASSES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.CURRENT_GUI_CLASS = null;
        this.queuedForUpdate = false;
        this.isInUse = false;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enablePERGUI && !CraftPresence.CONFIG.showGameState : this.enabled;
        this.isInUse = this.enabled && (CraftPresence.instance.field_71462_r != null || this.CURRENT_SCREEN != null);
        boolean bl = needsUpdate = this.enabled && (this.GUI_NAMES.isEmpty() || this.GUI_CLASSES.isEmpty());
        if (needsUpdate) {
            this.getGUIs();
        }
        if (this.isInUse) {
            this.updateGUIData();
            if (this.enabled && CraftPresence.instance.field_71462_r == null) {
                this.clearClientData();
            } else if (!this.enabled) {
                this.emptyData();
            }
        }
        if (this.openConfigGUI) {
            CraftPresence.instance.func_147108_a((GuiScreen)new ConfigGUI_Main(CraftPresence.instance.field_71462_r));
            this.openConfigGUI = false;
        }
    }

    private void updateGUIData() {
        if (this.CURRENT_SCREEN != null && CraftPresence.instance.field_71462_r == null || this.CURRENT_SCREEN == null && !StringHandler.isNullOrEmpty(CraftPresence.CLIENT.GAME_STATE)) {
            this.clearClientData();
            CraftPresence.CLIENT.GAME_STATE = "";
            CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
        } else if (CraftPresence.instance.field_71462_r != null) {
            GuiScreen newScreen = CraftPresence.instance.field_71462_r;
            Class<?> newScreenClass = newScreen.getClass();
            String newScreenName = newScreenClass.getSimpleName();
            if (!(newScreen.equals(this.CURRENT_SCREEN) && newScreenClass.equals(this.CURRENT_GUI_CLASS) && newScreenName.equals(this.CURRENT_GUI_NAME))) {
                this.CURRENT_SCREEN = newScreen;
                this.CURRENT_GUI_CLASS = newScreenClass;
                this.CURRENT_GUI_NAME = newScreenName;
                this.queuedForUpdate = true;
                if (!this.GUI_NAMES.contains(newScreenName)) {
                    this.GUI_NAMES.add(newScreenName);
                }
                if (!this.GUI_CLASSES.contains(newScreenClass)) {
                    this.GUI_CLASSES.add(newScreenClass);
                }
            }
        }
        if (this.queuedForUpdate) {
            this.updateGUIPresence();
        }
    }

    public void getGUIs() {
        Class[] searchClasses = new Class[]{GuiScreen.class, GuiContainer.class};
        for (Class classObj : FileHandler.getClassNamesMatchingSuperType(Arrays.asList(searchClasses), "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
            if (!this.GUI_NAMES.contains(classObj.getSimpleName())) {
                this.GUI_NAMES.add(classObj.getSimpleName());
            }
            if (this.GUI_CLASSES.contains(classObj)) continue;
            this.GUI_CLASSES.add(classObj);
        }
        for (String guiMessage : CraftPresence.CONFIG.guiMessages) {
            String[] part;
            if (StringHandler.isNullOrEmpty(guiMessage) || StringHandler.isNullOrEmpty((part = guiMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.GUI_NAMES.contains(part[0])) continue;
            this.GUI_NAMES.add(part[0]);
        }
    }

    public void updateGUIPresence() {
        String defaultGUIMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.guiMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentGUIMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.guiMessages, this.CURRENT_GUI_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultGUIMSG);
        CraftPresence.CLIENT.GAME_STATE = currentGUIMSG.replace("&gui&", this.CURRENT_GUI_NAME).replace("&class&", this.CURRENT_GUI_CLASS.getSimpleName()).replace("&screen&", this.CURRENT_SCREEN.toString());
        CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
        this.queuedForUpdate = false;
    }

    public void drawMultiLineString(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, boolean withBackground) {
        if (CraftPresence.CONFIG.renderTooltips && !Constants.forceBlockTooltipRendering && !textLines.isEmpty() && font != null) {
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = StringHandler.getStringWidth(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList wrappedTextLines = Lists.newArrayList();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List<String> wrappedLine = StringHandler.splitTextByNewLine(StringHandler.wrapFormattedStringToWidth(textLine, tooltipTextWidth));
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = StringHandler.getStringWidth(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            if (withBackground) {
                String borderColor;
                String backgroundColor;
                GL11.glDisable((int)2929);
                int zLevel = 300;
                if (StringHandler.isValidColorCode(CraftPresence.CONFIG.tooltipBGColor)) {
                    backgroundColor = CraftPresence.CONFIG.tooltipBGColor.length() == 6 ? "#" + CraftPresence.CONFIG.tooltipBGColor : (CraftPresence.CONFIG.tooltipBGColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.tooltipBGColor).intValue()) : CraftPresence.CONFIG.tooltipBGColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
                } else {
                    ResourceLocation backGroundTexture;
                    backgroundColor = CraftPresence.CONFIG.tooltipBGColor.contains(CraftPresence.CONFIG.splitCharacter) ? CraftPresence.CONFIG.tooltipBGColor.replace(CraftPresence.CONFIG.splitCharacter, ":") : (CraftPresence.CONFIG.tooltipBGColor.contains(":") && !CraftPresence.CONFIG.tooltipBGColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBGColor : (CraftPresence.CONFIG.tooltipBGColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBGColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.tooltipBGColor));
                    if (backgroundColor.contains(":")) {
                        String[] splitInput = backgroundColor.split(":", 2);
                        backGroundTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        backGroundTexture = new ResourceLocation(backgroundColor);
                    }
                    this.drawTextureRect(300.0, tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 0.0, backGroundTexture);
                }
                if (StringHandler.isValidColorCode(CraftPresence.CONFIG.tooltipBorderColor)) {
                    borderColor = CraftPresence.CONFIG.tooltipBorderColor.length() == 6 ? "#" + CraftPresence.CONFIG.tooltipBorderColor : (CraftPresence.CONFIG.tooltipBorderColor.startsWith("0x") ? Long.toString(Long.decode(CraftPresence.CONFIG.tooltipBorderColor).intValue()) : CraftPresence.CONFIG.tooltipBorderColor);
                    int borderColorCode = borderColor.startsWith("#") ? StringHandler.getColorFromHex(borderColor).getRGB() : Integer.parseInt(borderColor);
                    String borderColorEnd = Integer.toString((borderColorCode & 0xFEFEFE) >> 1 | borderColorCode & 0xFF000000);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColor, borderColorEnd);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColor, borderColor);
                    this.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
                } else {
                    ResourceLocation borderTexture;
                    borderColor = CraftPresence.CONFIG.tooltipBorderColor.contains(CraftPresence.CONFIG.splitCharacter) ? CraftPresence.CONFIG.tooltipBorderColor.replace(CraftPresence.CONFIG.splitCharacter, ":") : (CraftPresence.CONFIG.tooltipBorderColor.contains(":") && !CraftPresence.CONFIG.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBorderColor : (CraftPresence.CONFIG.tooltipBorderColor.startsWith(":") ? CraftPresence.CONFIG.tooltipBorderColor.substring(1) : "minecraft:" + CraftPresence.CONFIG.tooltipBorderColor));
                    if (borderColor.contains(":")) {
                        String[] splitInput = borderColor.split(":", 2);
                        borderTexture = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        borderTexture = new ResourceLocation(borderColor);
                    }
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, tooltipTextWidth + 5, 1.0, 0.0, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipTextWidth + 5, 1.0, 0.0, borderTexture);
                    this.drawTextureRect(300.0, tooltipX - 3, tooltipY - 3, 1.0, tooltipHeight + 5, 0.0, borderTexture);
                    this.drawTextureRect(300.0, tooltipX + tooltipTextWidth + 2, tooltipY - 3, 1.0, tooltipHeight + 6, 0.0, borderTexture);
                }
            }
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            if (withBackground) {
                GL11.glEnable((int)2929);
            }
        }
    }

    public void drawBackground(double width, double height) {
        if (CraftPresence.instance.field_71441_e != null) {
            this.drawGradientRect(300.0f, 0.0, 0.0, width, height, "-1072689136", "-804253680");
        } else {
            String bgCode = CraftPresence.CONFIG.guiBGColor;
            if (StringHandler.isValidColorCode(bgCode)) {
                this.drawGradientRect(300.0f, 0.0, 0.0, width, height, bgCode, bgCode);
            } else if (!StringHandler.isNullOrEmpty(bgCode)) {
                ResourceLocation loc;
                if (bgCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                    bgCode = bgCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                }
                if (bgCode.contains(":")) {
                    String[] splitInput = bgCode.split(":", 2);
                    loc = new ResourceLocation(splitInput[0], splitInput[1]);
                } else {
                    loc = new ResourceLocation(bgCode);
                }
                this.drawTextureRect(0.0, 0.0, 0.0, width, height, 0.0, loc);
            }
        }
    }

    public void drawTextureRect(double zLevel, double xPos, double yPos, double width, double height, double tint, ResourceLocation texLocation) {
        if (texLocation != null) {
            CraftPresence.instance.func_110434_K().func_110577_a(texLocation);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float divider = 32.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(xPos, yPos + height, zLevel).func_187315_a(0.0, height / 32.0 + tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(xPos + width, yPos + height, zLevel).func_187315_a(width / 32.0, height / 32.0 + tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(xPos + width, yPos, zLevel).func_187315_a(width / 32.0, tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_181662_b(xPos, yPos, zLevel).func_187315_a(0.0, tint).func_181669_b(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawGradientRect(float zLevel, double left, double top, double right, double bottom, String startColorCode, String endColorCode) {
        Color startColorObj = null;
        Color endColorObj = null;
        int startColor = 0xFFFFFF;
        int endColor = 0xFFFFFF;
        if (!StringHandler.isNullOrEmpty(startColorCode)) {
            if (startColorCode.startsWith("#")) {
                startColorObj = StringHandler.getColorFromHex(startColorCode);
                endColorObj = !StringHandler.isNullOrEmpty(endColorCode) && endColorCode.startsWith("#") ? StringHandler.getColorFromHex(endColorCode) : startColorObj;
            } else if (StringHandler.isValidInteger(startColorCode)) {
                startColor = Integer.parseInt(startColorCode);
                endColor = StringHandler.isValidInteger(endColorCode) ? Integer.parseInt(endColorCode) : startColor;
            }
        }
        int startColorInstance = startColorObj != null ? startColorObj.getRGB() : startColor;
        int endColorInstance = endColorObj != null ? endColorObj.getRGB() : endColor;
        float startAlpha = (float)(startColorInstance >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColorInstance >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColorInstance >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColorInstance & 0xFF) / 255.0f;
        float endAlpha = (float)(endColorInstance >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColorInstance >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColorInstance >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColorInstance & 0xFF) / 255.0f;
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(right, top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b(left, top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b(left, bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_181662_b(right, bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
    }

    public void drawContinuousTexturedBox(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, double zLevel, ResourceLocation res) {
        if (res != null) {
            CraftPresence.instance.func_110434_K().func_110577_a(res);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GUIHandler.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        GUIHandler.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GUIHandler.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GUIHandler.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GUIHandler.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GUIHandler.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GUIHandler.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GUIHandler.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GUIHandler.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }
}

