/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler.server;

import com.gitlab.cdagaming.craftpresence.Constants;
import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.FileHandler;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.discord.assets.DiscordAsset;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.NetHandlerPlayClient;

public class ServerHandler {
    public boolean enabled = false;
    public boolean isInUse = false;
    public List<String> knownAddresses = Lists.newArrayList();
    public String currentServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private String currentServerMSG;
    private String timeString;
    private int currentPlayers;
    private int maxPlayers;
    private int serverIndex;
    private ServerData currentServerData;
    private ServerData requestedServerData;
    private NetHandlerPlayClient currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;

    private void emptyData() {
        this.knownAddresses.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.currentServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_Name = null;
        this.currentServerData = null;
        this.currentConnection = null;
        this.timeString = null;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.queuedForUpdate = false;
        this.isOnLAN = false;
        this.isInUse = false;
        if (!this.joinInProgress) {
            this.requestedServerData = null;
        }
    }

    public void onTick() {
        boolean needsUpdate;
        this.joinInProgress = StringHandler.isNullOrEmpty(CraftPresence.CLIENT.STATUS) || CraftPresence.CLIENT.STATUS.equalsIgnoreCase("joinGame") || CraftPresence.CLIENT.STATUS.equalsIgnoreCase("spectateGame");
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.showGameState : this.enabled;
        boolean bl = needsUpdate = this.enabled && this.knownAddresses.isEmpty();
        if (needsUpdate) {
            this.getServerAddresses();
        }
        if (this.enabled) {
            if (CraftPresence.player != null && !this.joinInProgress) {
                this.isInUse = true;
                this.updateServerData();
            } else {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
        if (this.joinInProgress && this.requestedServerData != null) {
            this.joinServer(this.requestedServerData);
        }
    }

    private void updateServerData() {
        ServerData newServerData = CraftPresence.instance.func_147104_D();
        NetHandlerPlayClient newConnection = CraftPresence.instance.func_147114_u();
        if (!this.joinInProgress) {
            String newGameTime;
            int newCurrentPlayers = newConnection != null ? newConnection.func_175106_d().size() : 1;
            int newMaxPlayers = newConnection != null && newConnection.field_147304_c >= newCurrentPlayers ? newConnection.field_147304_c : newCurrentPlayers + 1;
            boolean newLANStatus = CraftPresence.instance.func_71356_B() && newCurrentPlayers > 1 || newServerData != null && newServerData.func_181041_d();
            String newServer_IP = newServerData != null && !StringHandler.isNullOrEmpty(newServerData.field_78845_b) ? newServerData.field_78845_b : "127.0.0.1";
            String newServer_Name = newServerData != null && !StringHandler.isNullOrEmpty(newServerData.field_78847_a) ? newServerData.field_78847_a : CraftPresence.CONFIG.defaultServerName;
            String newServer_MOTD = !this.isOnLAN && !CraftPresence.instance.func_71356_B() && newServerData != null && !StringHandler.isNullOrEmpty(newServerData.field_78843_d) && !newServerData.field_78843_d.equalsIgnoreCase(Constants.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_connect", new Object[0])) && !newServerData.field_78843_d.equalsIgnoreCase(Constants.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_resolve", new Object[0])) && !newServerData.field_78843_d.equalsIgnoreCase(Constants.TRANSLATOR.translate("craftpresence.multiplayer.status.polling", new Object[0])) && !newServerData.field_78843_d.equalsIgnoreCase(Constants.TRANSLATOR.translate("craftpresence.multiplayer.status.pinging", new Object[0])) ? StringHandler.stripColors(newServerData.field_78843_d) : CraftPresence.CONFIG.defaultServerMOTD;
            String string = newGameTime = CraftPresence.player != null ? this.getTimeString(CraftPresence.player.field_70170_p.func_72820_D()) : null;
            if (newLANStatus != this.isOnLAN || newServerData != null && !newServerData.equals(this.currentServerData) || newServerData == null && this.currentServerData != null || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringHandler.isNullOrEmpty(newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringHandler.isNullOrEmpty(newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
                this.currentServer_IP = newServer_IP;
                this.currentServer_MOTD = newServer_MOTD;
                this.currentServer_Name = newServer_Name;
                this.currentServerData = newServerData;
                this.currentConnection = newConnection;
                this.isOnLAN = newLANStatus;
                this.queuedForUpdate = true;
                if (!StringHandler.isNullOrEmpty(this.currentServer_IP) && !this.knownAddresses.contains(this.currentServer_IP.contains(":") ? this.currentServer_IP : StringHandler.formatIP(this.currentServer_IP, false))) {
                    this.knownAddresses.add(this.currentServer_IP.contains(":") ? this.currentServer_IP : StringHandler.formatIP(this.currentServer_IP, false));
                }
                ServerList serverList = new ServerList(CraftPresence.instance);
                serverList.func_78853_a();
                if (serverList.func_78856_c() != this.serverIndex || CraftPresence.CONFIG.serverMessages.length != this.serverIndex) {
                    this.getServerAddresses();
                }
            }
            if (!StringHandler.isNullOrEmpty(this.currentServerMSG)) {
                if (this.currentServerMSG.toLowerCase().contains("&time&") && !StringHandler.isNullOrEmpty(newGameTime) && !newGameTime.equals(this.timeString)) {
                    this.timeString = newGameTime;
                    this.queuedForUpdate = true;
                }
                if ((this.currentServerMSG.toLowerCase().contains("&players&") || CraftPresence.CONFIG.enableJoinRequest) && (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers)) {
                    this.currentPlayers = newCurrentPlayers;
                    this.maxPlayers = newMaxPlayers;
                    this.queuedForUpdate = true;
                }
            }
        }
        if (this.queuedForUpdate) {
            this.updateServerPresence();
        }
    }

    private String getTimeString(long worldTime) {
        long remainingTicks;
        long hour = 0L;
        long minute = 0L;
        long dayLength = 24000L;
        for (remainingTicks = worldTime % dayLength; remainingTicks >= 1000L; remainingTicks -= 1000L) {
            if (++hour <= 24L) continue;
            hour -= 24L;
        }
        remainingTicks *= 3L;
        while (remainingTicks >= 50L) {
            remainingTicks -= 50L;
            ++minute;
        }
        String formattedHour = String.valueOf(hour).length() == 1 ? String.format("%02d", hour) : String.valueOf(hour);
        String formattedMinute = String.valueOf(minute).length() == 1 ? String.format("%02d", minute) : String.valueOf(minute);
        return formattedHour + ":" + formattedMinute;
    }

    private String makeSecret() {
        String formattedKey = CraftPresence.CLIENT.CLIENT_ID + "";
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringHandler.isNullOrEmpty(this.currentServer_Name)) {
            formattedKey = formattedKey + "-" + this.currentServer_Name.toLowerCase();
            containsServerName = true;
        }
        if (!StringHandler.isNullOrEmpty(this.currentServer_IP)) {
            formattedKey = formattedKey + "-" + this.currentServer_IP.toLowerCase();
            containsServerIP = true;
        }
        formattedKey = formattedKey + ";" + containsServerName + ";" + containsServerIP;
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        String[] boolParts = secret.split(";");
        String[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringHandler.elementExists(stringParts, 0) && stringParts[0].length() == 18 && StringHandler.isValidLong(stringParts[0]);
        boolean containsServerName = StringHandler.elementExists(boolParts, 1) && StringHandler.elementExists(stringParts, 1) && Boolean.parseBoolean(boolParts[1]);
        boolean containsServerIP = StringHandler.elementExists(boolParts, 2) && StringHandler.elementExists(stringParts, 2) && Boolean.parseBoolean(boolParts[2]);
        String serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.defaultServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            if (CraftPresence.CONFIG.enableJoinRequest) {
                this.requestedServerData = new ServerData(serverName, serverIP, false);
            } else {
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.warning.config.disabled.enablejoinrequest", new Object[0]), new Object[0]);
            }
        } else {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.join", secret), new Object[0]);
        }
    }

    private void joinServer(ServerData serverData) {
        try {
            if (CraftPresence.player != null) {
                CraftPresence.player.field_70170_p.func_72882_A();
                CraftPresence.instance.func_71403_a(null);
            }
            CraftPresence.instance.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)(CraftPresence.instance.field_71462_r != null ? CraftPresence.instance.field_71462_r : new GuiMainMenu()), CraftPresence.instance, serverData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.requestedServerData = null;
        }
    }

    public void updateServerPresence() {
        if (!CraftPresence.instance.func_71356_B() && !this.isOnLAN && this.currentServerData != null) {
            String defaultServerMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
            String alternateServerMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultServerMSG);
            String alternateServerIcon = StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 2, CraftPresence.CONFIG.splitCharacter, this.currentServer_Name);
            this.currentServerMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, StringHandler.formatIP(this.currentServer_IP, false), 0, 1, CraftPresence.CONFIG.splitCharacter, alternateServerMSG);
            String currentServerIcon = StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, StringHandler.formatIP(this.currentServer_IP, false), 0, 2, CraftPresence.CONFIG.splitCharacter, alternateServerIcon);
            String formattedServerIconKey = StringHandler.formatPackIcon(currentServerIcon.replace(" ", "_"));
            CraftPresence.CLIENT.GAME_STATE = this.currentServerMSG.replace("&ip&", StringHandler.formatIP(this.currentServer_IP, false)).replace("&name&", this.currentServer_Name).replace("&motd&", this.currentServer_MOTD).replace("&players&", CraftPresence.CONFIG.playerAmountPlaceholderMSG.replace("&current&", Integer.toString(this.currentPlayers)).replace("&max&", Integer.toString(this.maxPlayers))).replace("&ign&", CraftPresence.CONFIG.playerPlaceholderMSG.replace("&name&", Constants.USERNAME)).replace("&time&", CraftPresence.CONFIG.gameTimePlaceholderMSG.replace("&worldtime&", !StringHandler.isNullOrEmpty(this.timeString) ? this.timeString : "")).replace("&mods&", CraftPresence.CONFIG.modsPlaceholderMSG.replace("&modcount&", Integer.toString(FileHandler.getModCount())));
            if (CraftPresence.CONFIG.enableJoinRequest) {
                CraftPresence.CLIENT.PARTY_ID = !StringHandler.isNullOrEmpty(this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.defaultServerName) ? "Join Server: " + this.currentServer_Name : "Join Server: " + this.currentServer_IP;
                CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
            }
            if (!CraftPresence.CONFIG.overwriteServerIcon || !CraftPresence.packFound) {
                CraftPresence.CLIENT.setImage(formattedServerIconKey.replace("&icon&", CraftPresence.CONFIG.defaultServerIcon), DiscordAsset.AssetType.SMALL);
                CraftPresence.CLIENT.SMALLIMAGETEXT = CraftPresence.CLIENT.GAME_STATE;
            }
            CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
            this.queuedForUpdate = false;
        } else if (this.isOnLAN) {
            String alternateServerIcon = StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 2, CraftPresence.CONFIG.splitCharacter, this.currentServer_Name);
            String currentServerIcon = StringHandler.getConfigPart(CraftPresence.CONFIG.serverMessages, StringHandler.formatIP(this.currentServer_IP, false), 0, 2, CraftPresence.CONFIG.splitCharacter, alternateServerIcon);
            String formattedServerIconKey = StringHandler.formatPackIcon(currentServerIcon.replace(" ", "_"));
            this.currentServerMSG = CraftPresence.CONFIG.lanMSG;
            CraftPresence.CLIENT.GAME_STATE = this.currentServerMSG.replace("&ip&", StringHandler.formatIP(this.currentServer_IP, false)).replace("&name&", this.currentServer_Name).replace("&motd&", this.currentServer_MOTD).replace("&players&", CraftPresence.CONFIG.playerAmountPlaceholderMSG.replace("&current&", Integer.toString(this.currentPlayers)).replace("&max&", Integer.toString(this.maxPlayers))).replace("&ign&", CraftPresence.CONFIG.playerPlaceholderMSG.replace("&name&", Constants.USERNAME)).replace("&time&", CraftPresence.CONFIG.gameTimePlaceholderMSG.replace("&worldtime&", !StringHandler.isNullOrEmpty(this.timeString) ? this.timeString : "")).replace("&mods&", CraftPresence.CONFIG.modsPlaceholderMSG.replace("&modcount&", Integer.toString(FileHandler.getModCount())));
            if (!CraftPresence.CONFIG.overwriteServerIcon || !CraftPresence.packFound) {
                CraftPresence.CLIENT.setImage(formattedServerIconKey.replace("&icon&", CraftPresence.CONFIG.defaultServerIcon), DiscordAsset.AssetType.SMALL);
                CraftPresence.CLIENT.SMALLIMAGETEXT = CraftPresence.CLIENT.GAME_STATE;
            }
            CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
            this.queuedForUpdate = false;
        } else if (CraftPresence.instance.func_71356_B()) {
            this.currentServerMSG = CraftPresence.CONFIG.singleplayerMSG;
            CraftPresence.CLIENT.GAME_STATE = this.currentServerMSG.replace("&ign&", CraftPresence.CONFIG.playerPlaceholderMSG.replace("&name&", Constants.USERNAME)).replace("&time&", CraftPresence.CONFIG.gameTimePlaceholderMSG.replace("&worldtime&", !StringHandler.isNullOrEmpty(this.timeString) ? this.timeString : "")).replace("&mods&", CraftPresence.CONFIG.modsPlaceholderMSG.replace("&modcount&", Integer.toString(FileHandler.getModCount())));
            CraftPresence.CLIENT.SMALLIMAGEKEY = "";
            CraftPresence.CLIENT.SMALLIMAGETEXT = "";
            CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
            this.queuedForUpdate = false;
        }
    }

    public void getServerAddresses() {
        ServerList serverList = new ServerList(CraftPresence.instance);
        serverList.func_78853_a();
        this.serverIndex = serverList.func_78856_c();
        for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
            ServerData data = serverList.func_78850_a(currentIndex);
            if (StringHandler.isNullOrEmpty(data.field_78845_b) || this.knownAddresses.contains(data.field_78845_b.contains(":") ? data.field_78845_b : StringHandler.formatIP(data.field_78845_b, false))) continue;
            this.knownAddresses.add(data.field_78845_b.contains(":") ? data.field_78845_b : StringHandler.formatIP(data.field_78845_b, false));
        }
        for (String serverMessage : CraftPresence.CONFIG.serverMessages) {
            String[] part;
            if (StringHandler.isNullOrEmpty(serverMessage) || StringHandler.isNullOrEmpty((part = serverMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.knownAddresses.contains(part[0])) continue;
            this.knownAddresses.add(part[0]);
        }
    }
}

