/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.FileHandler;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;

public class BiomeHandler {
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<String> BIOME_NAMES = Lists.newArrayList();
    private List<Biome> BIOME_TYPES = Lists.newArrayList();
    private List<Integer> BIOME_IDS = Lists.newArrayList();
    private String CURRENT_BIOME_NAME;
    private Integer CURRENT_BIOME_ID;
    private boolean queuedForUpdate = false;

    private void emptyData() {
        this.BIOME_NAMES.clear();
        this.BIOME_IDS.clear();
        this.BIOME_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_BIOME_NAME = null;
        this.CURRENT_BIOME_ID = null;
        this.queuedForUpdate = false;
        this.isInUse = false;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.showCurrentBiome && !CraftPresence.CONFIG.showGameState : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.BIOME_NAMES.isEmpty() || this.BIOME_IDS.isEmpty() || this.BIOME_TYPES.isEmpty());
        if (needsUpdate) {
            this.getBiomes();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateBiomeData();
            } else {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateBiomeData() {
        Biome newBiome = CraftPresence.player.field_70170_p.func_180494_b(CraftPresence.player.func_180425_c());
        String newBiomeName = newBiome.func_185359_l();
        Integer newBiomeID = Biome.func_185362_a((Biome)newBiome);
        if (!newBiomeName.equals(this.CURRENT_BIOME_NAME) || !newBiomeID.equals(this.CURRENT_BIOME_ID)) {
            this.CURRENT_BIOME_NAME = newBiomeName;
            this.CURRENT_BIOME_ID = newBiomeID;
            this.queuedForUpdate = true;
            if (!this.BIOME_NAMES.contains(newBiomeName)) {
                this.BIOME_NAMES.add(newBiomeName);
            }
            if (!this.BIOME_IDS.contains(newBiomeID)) {
                this.BIOME_IDS.add(newBiomeID);
            }
            if (!this.BIOME_TYPES.contains(newBiome)) {
                this.BIOME_TYPES.add(newBiome);
            }
        }
        if (this.queuedForUpdate) {
            this.updateBiomePresence();
        }
    }

    public void updateBiomePresence() {
        String defaultBiomeMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.biomeMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentBiomeMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.biomeMessages, this.CURRENT_BIOME_NAME, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultBiomeMSG);
        String formattedBiomeMSG = currentBiomeMSG.replace("&biome&", this.CURRENT_BIOME_NAME).replace("&id&", this.CURRENT_BIOME_ID.toString());
        if (!CraftPresence.GUIS.isInUse && !CraftPresence.SERVER.isInUse) {
            CraftPresence.CLIENT.GAME_STATE = formattedBiomeMSG;
            CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
            this.queuedForUpdate = false;
        } else {
            this.queuedForUpdate = true;
        }
    }

    private List<Biome> getBiomeTypes() {
        ArrayList biomeTypes = Lists.newArrayList();
        if (Biome.field_185377_q != null) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || biomeTypes.contains(biome)) continue;
                biomeTypes.add(biome);
            }
        }
        if (biomeTypes.isEmpty()) {
            for (Class classObj : FileHandler.getClassNamesMatchingSuperType(Biome.class, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
                if (classObj == null) continue;
                try {
                    Biome biomeObj = (Biome)classObj.newInstance();
                    if (biomeObj == null || biomeTypes.contains(biomeObj)) continue;
                    biomeTypes.add(biomeObj);
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        }
        return biomeTypes;
    }

    public void getBiomes() {
        for (Biome biome : this.getBiomeTypes()) {
            if (biome == null) continue;
            if (!this.BIOME_NAMES.contains(biome.func_185359_l())) {
                this.BIOME_NAMES.add(biome.func_185359_l());
            }
            if (!this.BIOME_IDS.contains(Biome.func_185362_a((Biome)biome))) {
                this.BIOME_IDS.add(Biome.func_185362_a((Biome)biome));
            }
            if (this.BIOME_TYPES.contains(biome)) continue;
            this.BIOME_TYPES.add(biome);
        }
        for (String biomeMessage : CraftPresence.CONFIG.biomeMessages) {
            String[] part;
            if (StringHandler.isNullOrEmpty(biomeMessage) || StringHandler.isNullOrEmpty((part = biomeMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.BIOME_NAMES.contains(part[0])) continue;
            this.BIOME_NAMES.add(part[0]);
        }
    }
}

