/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.handler.world;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.handler.FileHandler;
import com.gitlab.cdagaming.craftpresence.handler.StringHandler;
import com.gitlab.cdagaming.craftpresence.handler.discord.assets.DiscordAsset;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;

public class DimensionHandler {
    public boolean isInUse = false;
    public boolean enabled = false;
    public String CURRENT_DIMENSION_NAME;
    public String CURRENT_DIMENSION_NAME_ID;
    public List<String> DIMENSION_NAMES = Lists.newArrayList();
    private List<Integer> DIMENSION_IDS = Lists.newArrayList();
    private List<DimensionType> DIMENSION_TYPES = Lists.newArrayList();
    private Integer CURRENT_DIMENSION_ID;
    private boolean queuedForUpdate = false;

    private void emptyData() {
        this.DIMENSION_NAMES.clear();
        this.DIMENSION_IDS.clear();
        this.DIMENSION_TYPES.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.CURRENT_DIMENSION_NAME = null;
        this.CURRENT_DIMENSION_ID = null;
        this.queuedForUpdate = false;
        this.isInUse = false;
    }

    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.showCurrentDimension : this.enabled;
        boolean bl = needsUpdate = this.enabled && (this.DIMENSION_NAMES.isEmpty() || this.DIMENSION_IDS.isEmpty() || this.DIMENSION_TYPES.isEmpty());
        if (needsUpdate) {
            this.getDimensions();
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.isInUse = true;
                this.updateDimensionData();
            } else {
                this.clearClientData();
            }
        } else {
            this.emptyData();
        }
    }

    private void updateDimensionData() {
        WorldProvider newProvider = CraftPresence.player.field_70170_p.field_73011_w;
        DimensionType newDimensionType = newProvider.func_186058_p();
        String newDimensionName = StringHandler.formatDimensionName(newDimensionType.func_186065_b(), false);
        String newDimension_primaryNameID = StringHandler.formatDimensionName(newDimensionType.func_186065_b(), true);
        String newDimension_alternativeNameID = StringHandler.formatDimensionName(newProvider.getClass().getSimpleName(), true);
        String newDimension_nameID = !this.DIMENSION_NAMES.isEmpty() && this.DIMENSION_NAMES.contains(newDimension_alternativeNameID) ? newDimension_alternativeNameID : newDimension_primaryNameID;
        Integer newDimensionID = newDimensionType.func_186068_a();
        if (!newDimension_nameID.equals(this.CURRENT_DIMENSION_NAME_ID) || !newDimensionID.equals(this.CURRENT_DIMENSION_ID)) {
            this.CURRENT_DIMENSION_NAME = newDimensionName;
            this.CURRENT_DIMENSION_NAME_ID = newDimension_nameID;
            this.CURRENT_DIMENSION_ID = newDimensionID;
            this.queuedForUpdate = true;
            if (!this.DIMENSION_NAMES.contains(newDimension_nameID)) {
                this.DIMENSION_NAMES.add(newDimension_nameID);
            }
            if (!this.DIMENSION_TYPES.contains(newDimensionType)) {
                this.DIMENSION_TYPES.add(newDimensionType);
            }
            if (!this.DIMENSION_IDS.contains(newDimensionID)) {
                this.DIMENSION_IDS.add(newDimensionID);
            }
        }
        if (this.queuedForUpdate) {
            this.updateDimensionPresence();
        }
    }

    public void updateDimensionPresence() {
        String defaultDimensionMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.dimensionMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
        String currentDimensionMSG = StringHandler.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_NAME_ID, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultDimensionMSG);
        String currentDimensionIcon = StringHandler.getConfigPart(CraftPresence.CONFIG.dimensionMessages, this.CURRENT_DIMENSION_NAME_ID, 0, 2, CraftPresence.CONFIG.splitCharacter, this.CURRENT_DIMENSION_NAME_ID);
        String formattedIconKey = StringHandler.formatPackIcon(currentDimensionIcon.replace(" ", "_"));
        CraftPresence.CLIENT.setImage(formattedIconKey.replace("&icon&", CraftPresence.CONFIG.defaultDimensionIcon), DiscordAsset.AssetType.LARGE);
        CraftPresence.CLIENT.DETAILS = StringHandler.formatWord(currentDimensionMSG.replace("&dimension&", StringHandler.formatWord(this.CURRENT_DIMENSION_NAME)).replace("&id&", this.CURRENT_DIMENSION_ID.toString()));
        if (!CraftPresence.ENTITIES.isInUse || CraftPresence.ENTITIES.allItemsEmpty) {
            CraftPresence.CLIENT.LARGEIMAGETEXT = CraftPresence.CLIENT.DETAILS;
            this.queuedForUpdate = false;
        } else {
            this.queuedForUpdate = true;
        }
        CraftPresence.CLIENT.updatePresence(CraftPresence.CLIENT.buildRichPresence());
    }

    private List<DimensionType> getDimensionTypes() {
        ArrayList dimensionTypes;
        block7: {
            dimensionTypes = Lists.newArrayList();
            Map reflectedDimensionTypes = (Map)StringHandler.lookupObject(DimensionType.class, null, "dimensionTypes");
            Collections.addAll(dimensionTypes, DimensionType.values());
            if (!dimensionTypes.isEmpty()) break block7;
            if (reflectedDimensionTypes != null) {
                for (DimensionType type : reflectedDimensionTypes.values()) {
                    if (type == null || dimensionTypes.contains(type)) continue;
                    dimensionTypes.add(type);
                }
            } else {
                for (Class classObj : FileHandler.getClassNamesMatchingSuperType(WorldProvider.class, "net.minecraft", "com.gitlab.cdagaming.craftpresence")) {
                    if (classObj == null) continue;
                    try {
                        WorldProvider providerObj = (WorldProvider)classObj.newInstance();
                        if (providerObj == null || dimensionTypes.contains(providerObj.func_186058_p())) continue;
                        dimensionTypes.add(providerObj.func_186058_p());
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {}
                }
            }
        }
        return dimensionTypes;
    }

    public void getDimensions() {
        for (DimensionType TYPE : this.getDimensionTypes()) {
            if (TYPE == null) continue;
            if (!this.DIMENSION_NAMES.contains(StringHandler.formatDimensionName(TYPE.func_186065_b(), true))) {
                this.DIMENSION_NAMES.add(StringHandler.formatDimensionName(TYPE.func_186065_b(), true));
            }
            if (!this.DIMENSION_IDS.contains(TYPE.func_186068_a())) {
                this.DIMENSION_IDS.add(TYPE.func_186068_a());
            }
            if (this.DIMENSION_TYPES.contains(TYPE)) continue;
            this.DIMENSION_TYPES.add(TYPE);
        }
        for (String dimensionMessage : CraftPresence.CONFIG.dimensionMessages) {
            String[] part;
            if (StringHandler.isNullOrEmpty(dimensionMessage) || StringHandler.isNullOrEmpty((part = dimensionMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.DIMENSION_NAMES.contains(StringHandler.formatDimensionName(part[0], true))) continue;
            this.DIMENSION_NAMES.add(StringHandler.formatDimensionName(part[0], true));
        }
    }
}

