/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.net;

import com.feed_the_beast.ftblib.lib.net.MessageBase;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MessageToClient
extends MessageBase {
    public final void sendTo(EntityPlayerMP player) {
        if (ServerUtils.isFake(player)) {
            return;
        }
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToAll() {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToDimension(int dim) {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dim);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToAllAround(int dim, BlockPos pos, double range) {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(dim, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, range));
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToAllTracking(NetworkRegistry.TargetPoint pos) {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TRACKING_POINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)pos);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToAllTracking(int dim, double x, double y, double z) {
        this.sendToAllTracking(new NetworkRegistry.TargetPoint(dim, x, y, z, 0.0));
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
    }
}

