/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.items;

import java.util.Locale;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.DispenseClayBucket;
import knightminer.ceramics.library.FluidClayBucketWrapper;
import knightminer.ceramics.library.Util;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemClayBucket
extends Item {
    public static final String TAG_FLUIDS = "fluids";
    public static ItemStack MILK_BUCKET = new ItemStack(Items.field_151117_aB);
    public static ItemStack BRICK = new ItemStack(Items.field_151118_aC);

    public ItemClayBucket() {
        this.func_77637_a(Ceramics.tab);
        this.field_77787_bX = true;
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseClayBucket.INSTANCE);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getSpecialFluid(stack) == SpecialFluid.MILK) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)this.func_77621_a(world, player, !this.hasFluid(stack)));
        if (ret != null) {
            return ret;
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBucketEvent(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack stack = event.getEmptyBucket();
        if (stack == null || !stack.func_77973_b().equals((Object)this)) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.func_178782_a();
        EntityPlayer player = event.getEntityPlayer();
        if (!world.func_175660_a(player, pos)) {
            event.setCanceled(true);
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        ItemStack result = null;
        if (!(state.func_177230_c() != Blocks.field_150383_bp || player != null && player.func_70093_af())) {
            result = this.interactWithCauldron(event, player, world, pos, state, stack);
            if (event.getResult() == Event.Result.DENY) {
                return;
            }
        }
        if (result == null) {
            if (this.hasFluid(stack)) {
                if (!player.func_175151_a(pos, target.field_178784_b, stack)) {
                    event.setCanceled(true);
                    return;
                }
                BlockPos targetPos = pos.func_177972_a(target.field_178784_b);
                result = this.hasSpecialFluid(stack) ? this.tryPlaceSpecialFluid(stack, player, world, targetPos) : this.tryPlaceFluid(stack, player, world, targetPos);
            } else {
                result = this.tryFillBucket(stack, player, world, pos, state, target.field_178784_b);
            }
        }
        if (result != null) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(result);
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    private ItemStack tryFillBucket(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state, EnumFacing side) {
        ItemStack single = stack.func_77946_l();
        single.func_190920_e(1);
        FluidActionResult result = FluidUtil.tryPickUpFluid((ItemStack)single, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (result.isSuccess()) {
            return result.getResult();
        }
        if (!Config.bucketSand) {
            return null;
        }
        SpecialFluid fluid = SpecialFluid.fromState(state);
        if (fluid != null) {
            world.func_184133_a(player, pos, state.func_177230_c().getSoundType(state, world, pos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 0.8f);
            if (!world.field_72995_K) {
                world.func_175698_g(pos);
            }
            return new ItemStack((Item)this, 1, fluid.getMeta());
        }
        return null;
    }

    private ItemStack tryPlaceFluid(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        stack = stack.func_77946_l();
        FluidStack fluidStack = this.getFluid(stack);
        FluidActionResult result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)player.func_130014_f_(), (BlockPos)pos, (ItemStack)stack, (FluidStack)fluidStack);
        if (result.isSuccess()) {
            if (fluidStack.getFluid() == FluidRegistry.WATER || fluidStack.getFluid() == FluidRegistry.LAVA) {
                IBlockState state = world.func_180495_p(pos);
                world.func_190524_a(pos, state.func_177230_c(), pos);
            }
            return result.getResult();
        }
        return null;
    }

    private ItemStack tryPlaceSpecialFluid(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = this.getSpecialFluid(stack).getState();
        IBlockState currentState = world.func_180495_p(pos);
        if (currentState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, state);
            }
            world.func_184133_a(player, pos, state.func_177230_c().getSoundType(state, world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.8f);
            if (player != null) {
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
            return new ItemStack((Item)this);
        }
        return null;
    }

    private ItemStack interactWithCauldron(FillBucketEvent event, EntityPlayer player, World world, BlockPos pos, IBlockState state, ItemStack stack) {
        int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
        if (!this.hasFluid(stack)) {
            if (level == 3) {
                if (player != null) {
                    player.func_71029_a(StatList.field_188078_L);
                }
                if (!world.field_72995_K) {
                    Blocks.field_150383_bp.func_176590_a(world, pos, state, 0);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return this.withFluid(FluidRegistry.WATER);
            }
            event.setResult(Event.Result.DENY);
        } else if (this.getFluid(stack).getFluid() == FluidRegistry.WATER) {
            if (level < 3) {
                if (player != null) {
                    player.func_71029_a(StatList.field_188077_K);
                }
                if (!world.field_72995_K) {
                    Blocks.field_150383_bp.func_176590_a(world, pos, state, 3);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return new ItemStack((Item)this);
            }
            event.setResult(Event.Result.DENY);
        }
        return null;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.getSpecialFluid(stack) == SpecialFluid.MILK ? EnumAction.DRINK : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return this.getSpecialFluid(stack) == SpecialFluid.MILK ? 32 : 0;
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (this.getSpecialFluid(stack) != SpecialFluid.MILK) {
            return stack;
        }
        if (entityLiving instanceof EntityPlayer && !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
            stack = new ItemStack((Item)this);
        }
        if (!worldIn.field_72995_K) {
            entityLiving.curePotionEffects(MILK_BUCKET);
        }
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_71029_a(StatList.func_188057_b((Item)this));
        }
        return stack;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!this.hasFluid(stack) && target instanceof EntityCow && !player.field_71075_bZ.field_75098_d) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            if (stack.func_190916_E() == 1) {
                stack.func_77964_b(SpecialFluid.MILK.getMeta());
            } else {
                stack.func_190918_g(1);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.withSpecialFluid(SpecialFluid.MILK));
            }
            return true;
        }
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.hasFluid(stack) ? 1 : 16;
    }

    public int getItemBurnTime(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.getFluid() == FluidRegistry.LAVA) {
            return 20000;
        }
        return 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.doesBreak(stack)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)this);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.doesBreak(stack);
    }

    @SubscribeEvent
    public void onItemDestroyed(PlayerDestroyItemEvent event) {
        ItemStack original = event.getOriginal();
        if (original.func_77973_b() == this) {
            event.getEntityPlayer().func_70669_a(BRICK);
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (this.hasSpecialFluid(stack)) {
            String specialFluid = this.getSpecialFluid(stack).getName();
            return I18n.func_74838_a((String)("item." + Util.prefix("clay_bucket." + specialFluid) + ".name"));
        }
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return I18n.func_74838_a((String)("item." + Util.prefix("clay_bucket.empty") + ".name"));
        }
        String unloc = this.func_77657_g(stack);
        if (I18n.func_94522_b((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return I18n.func_74838_a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return I18n.func_74837_a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (Config.bucketEnabled && this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid.getName().equals("milk") || !Config.bucketHotFluids && this.doesBreak(fluid)) continue;
                subItems.add((Object)this.withFluid(fluid));
            }
            for (SpecialFluid fluid : SpecialFluid.values()) {
                if (!fluid.show()) continue;
                subItems.add((Object)new ItemStack((Item)this, 1, fluid.getMeta()));
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidClayBucketWrapper(stack);
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.getSpecialFluid(container) == SpecialFluid.MILK) {
            return FluidRegistry.getFluidStack((String)"milk", (int)1000);
        }
        NBTTagCompound tags = container.func_77978_p();
        if (tags != null) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l(TAG_FLUIDS));
        }
        return null;
    }

    public boolean hasFluid(ItemStack container) {
        if (this.hasSpecialFluid(container)) {
            return true;
        }
        return this.getFluid(container) != null;
    }

    protected boolean hasSpecialFluid(ItemStack stack) {
        return stack.func_77952_i() != 0;
    }

    public SpecialFluid getSpecialFluid(ItemStack stack) {
        return SpecialFluid.fromMeta(stack.func_77952_i());
    }

    public ItemStack withFluid(Fluid fluid) {
        if ("milk".equals(fluid.getName())) {
            return new ItemStack((Item)this, 1, SpecialFluid.MILK.getMeta());
        }
        ItemStack stack = new ItemStack((Item)this, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(TAG_FLUIDS, (NBTBase)new FluidStack(fluid, 1000).writeToNBT(new NBTTagCompound()));
        stack.func_77982_d(tag);
        return stack;
    }

    public ItemStack withSpecialFluid(SpecialFluid fluid) {
        return new ItemStack((Item)this, 1, fluid.getMeta());
    }

    public boolean doesBreak(ItemStack stack) {
        return !this.hasSpecialFluid(stack) && this.doesBreak(this.getFluid(stack));
    }

    public boolean doesBreak(FluidStack fluid) {
        return fluid != null && this.doesBreak(fluid.getFluid());
    }

    protected boolean doesBreak(Fluid fluid) {
        return fluid != null && fluid.getTemperature() >= 450;
    }

    public static enum SpecialFluid {
        EMPTY,
        MILK,
        SAND(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.SAND)),
        RED_SAND(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND)),
        GRAVEL(Blocks.field_150351_n.func_176223_P());

        private int meta = this.ordinal();
        private IBlockState state;

        private SpecialFluid() {
            this.state = null;
        }

        private SpecialFluid(IBlockState state) {
            this.state = state;
        }

        public String getName() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }

        public static SpecialFluid fromMeta(int meta) {
            if (meta < 0 || meta > SpecialFluid.values().length) {
                meta = 0;
            }
            return SpecialFluid.values()[meta];
        }

        public boolean show() {
            return this != EMPTY && this.state == null;
        }

        public IBlockState getState() {
            return this.state;
        }

        @Nullable
        public static SpecialFluid fromState(IBlockState state) {
            if (!Config.bucketSand && state == null) {
                return null;
            }
            for (SpecialFluid fluid : SpecialFluid.values()) {
                if (state != fluid.getState()) continue;
                return fluid;
            }
            return null;
        }
    }
}

