/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.network.ExtensionMasterUpdatePacket;
import knightminer.ceramics.tileentity.TileBarrel;
import knightminer.ceramics.tileentity.TileBarrelBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileBarrelExtension
extends TileBarrelBase {
    private BlockPos masterPos;
    public static final String TAG_MASTER = "masterPos";

    public void setMaster(BlockPos pos) {
        if (pos != this.masterPos || pos != null && !pos.equals((Object)this.masterPos)) {
            this.masterPos = pos;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
                CeramicsNetwork.sendToAllAround(this.field_145850_b, this.field_174879_c, new ExtensionMasterUpdatePacket(this.field_174879_c, pos));
            }
        }
    }

    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    public TileBarrel getMaster() {
        if (this.masterPos == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.masterPos);
        if (te instanceof TileBarrel) {
            return (TileBarrel)te;
        }
        return null;
    }

    @Override
    public void checkBarrelStructure() {
        TileBarrel master = this.getMaster();
        if (master != null) {
            master.checkBarrelStructure();
        }
    }

    public void clearMaster() {
        if (!this.field_145850_b.field_72995_K && this.masterPos != null) {
            this.setMaster(null);
            TileEntity above = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
            if (above instanceof TileBarrelExtension) {
                ((TileBarrelExtension)above).clearMaster();
            }
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        TileBarrel master;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (master = this.getMaster()) != null) {
            return master.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        TileBarrel master;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (master = this.getMaster()) != null) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast(master.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        if (this.masterPos != null) {
            NBTTagCompound top = new NBTTagCompound();
            top.func_74768_a("x", this.masterPos.func_177958_n());
            top.func_74768_a("y", this.masterPos.func_177956_o());
            top.func_74768_a("z", this.masterPos.func_177952_p());
            tags.func_74782_a(TAG_MASTER, (NBTBase)top);
        }
        return tags;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        NBTTagCompound top = tags.func_74775_l(TAG_MASTER);
        if (top != null && top.func_74764_b("x") && top.func_74764_b("y") && top.func_74764_b("z")) {
            this.masterPos = new BlockPos(top.func_74762_e("x"), top.func_74762_e("y"), top.func_74762_e("z"));
        }
    }
}

