/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.inventory.slot.SlotDankNull;
import p455w0rd.danknull.inventory.slot.SlotDankNullDock;
import p455w0rd.danknull.inventory.slot.SlotHotbar;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.network.PacketUpdateSlot;

public abstract class ContainerDankNull
extends Container {
    protected final EntityPlayer player;

    public ContainerDankNull(EntityPlayer player) {
        this.player = player;
    }

    protected void init() {
        int i;
        InventoryPlayer playerInv = this.player.field_71071_by;
        IDankNullHandler handler = this.getHandler();
        int lockedSlot = -1;
        int numRows = handler.getTier().getNumRows();
        for (i = 0; i < playerInv.func_70302_i_(); ++i) {
            ItemStack currStack = playerInv.func_70301_a(i);
            if (currStack.func_190926_b() || currStack != this.getDankNullStack()) continue;
            lockedSlot = i;
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotHotbar((IInventory)playerInv, i, i * 20 + 9 + i, 90 + numRows - 1 + numRows * 20 + 6, lockedSlot == i));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, j * 20 + 9 + j, 149 + numRows - 1 + i - (6 - numRows) * 20 + i * 20));
            }
        }
        for (i = 0; i < handler.getTier().getNumRows(); ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)this.createDankNullSlot(handler, i, j));
            }
        }
    }

    public abstract IDankNullHandler getHandler();

    public abstract ItemStack getDankNullStack();

    protected boolean isDock() {
        return false;
    }

    private SlotDankNull createDankNullSlot(IDankNullHandler handler, int i, int j) {
        return this.isDock() ? new SlotDankNullDock((IItemHandler)handler, j + i * 9, j * 20 + 9 + j, 19 + i + i * 20) : new SlotDankNull((IItemHandler)handler, j + i * 9, j * 20 + 9 + j, 19 + i + i * 20);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.getHandler() != null;
    }

    public Slot func_75139_a(int slotId) {
        if (slotId < this.field_75151_b.size() && slotId >= 0) {
            return (Slot)this.field_75151_b.get(slotId);
        }
        return null;
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack slotStack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack clientStack = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)clientStack, (ItemStack)slotStack) || ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)clientStack, (ItemStack)slotStack)) continue;
            clientStack = slotStack.func_190926_b() ? ItemStack.field_190927_a : slotStack.func_77946_l();
            this.field_75153_a.set(i, (Object)clientStack);
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                ModNetworking.getInstance().sendTo((IMessage)new PacketUpdateSlot(i, clientStack), (EntityPlayerMP)listener);
            }
        }
    }

    public ItemStack func_184996_a(int index, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot = this.func_75139_a(index);
        if (slot == null || index < 36 && clickType != ClickType.QUICK_MOVE || clickType == ClickType.CLONE) {
            return super.func_184996_a(index, dragType, clickType, player);
        }
        if (clickType == ClickType.QUICK_MOVE) {
            return this.func_82846_b(player, index);
        }
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        ItemStack heldStack = inventoryPlayer.func_70445_o();
        if (slot instanceof SlotDankNull && clickType == ClickType.PICKUP) {
            ItemStack slotStack = slot.func_75211_c();
            if (ItemDankNull.isDankNull(slotStack)) {
                return ItemStack.field_190927_a;
            }
            if (!heldStack.func_190926_b()) {
                ItemStack toAdd = heldStack.func_77946_l();
                if (dragType == 1) {
                    toAdd.func_190920_e(1);
                }
                ItemStack leftover = this.addStack(toAdd);
                if (dragType == 0) {
                    if (!leftover.func_190926_b()) {
                        inventoryPlayer.func_70437_b(leftover);
                    } else {
                        inventoryPlayer.func_70437_b(ItemStack.field_190927_a);
                    }
                } else if (dragType == 1 && leftover.func_190926_b()) {
                    heldStack.func_190918_g(1);
                    inventoryPlayer.func_70437_b(heldStack);
                }
                inventoryPlayer.func_70296_d();
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71113_k();
                }
            } else if (!slotStack.func_190926_b()) {
                int amount = Math.min(slotStack.func_190916_E(), slotStack.func_77976_d());
                if (dragType == 1) {
                    amount = Math.floorDiv(amount, 2);
                }
                ItemStack newStack = slot.func_75209_a(amount);
                inventoryPlayer.func_70437_b(newStack);
                inventoryPlayer.func_70296_d();
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71113_k();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot clickSlot = (Slot)this.field_75151_b.get(index);
        if (clickSlot.func_75216_d()) {
            PlayerMainInvWrapper playerHandler;
            ItemStack notAdded;
            if (!(clickSlot instanceof SlotDankNull)) {
                ItemStack leftover = this.addStack(clickSlot.func_75211_c());
                clickSlot.func_75215_d(leftover);
                player.field_71071_by.func_70296_d();
                return ItemStack.field_190927_a;
            }
            int slotIndex = clickSlot.getSlotIndex();
            ItemStack slotStack = this.getHandler().extractItem(slotIndex, this.getHandler().getFullStackInSlot(slotIndex).func_77976_d(), true);
            if (!this.getHandler().getTier().isCreative() && (notAdded = ItemHandlerHelper.insertItemStacked((IItemHandler)(playerHandler = new PlayerMainInvWrapper(player.field_71071_by)), (ItemStack)slotStack, (boolean)false)).func_190916_E() < slotStack.func_190916_E()) {
                this.getHandler().extractItem(slotIndex, slotStack.func_190916_E() - notAdded.func_190916_E(), false);
            }
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack addStack(ItemStack stack) {
        int i;
        ItemStack leftover = stack.func_77946_l();
        IDankNullHandler handler = this.getHandler();
        for (i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, leftover)) continue;
            leftover = handler.insertItem(i, leftover, false);
        }
        for (i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getFullStackInSlot(i).func_190926_b() || !handler.isItemValid(i, leftover)) continue;
            handler.setStackInSlot(i, leftover);
            return ItemStack.field_190927_a;
        }
        return leftover;
    }
}

