/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.init.ModLogger;
import p455w0rd.danknull.items.ItemBlockDankNullDock;

public class ModDataFixing {
    private static final int DANKNULL_FIXES_VERSION = 101;

    public static void registerWalkers() {
        FMLCommonHandler.instance().getDataFixer().func_188255_a((IFixType)FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileDankNullDock.class, new String[]{"danknull-inventory"}));
    }

    public static void registerFixes() {
        CompoundDataFixer vanillaFixer = FMLCommonHandler.instance().getDataFixer();
        ModFixs fixs = vanillaFixer.init("danknull", 101);
        fixs.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new DankNullFixer(FixTypes.ITEM_INSTANCE));
        fixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new DankNullFixer(FixTypes.BLOCK_ENTITY));
        fixs.registerFix((IFixType)FixTypes.CHUNK, (IFixableData)new DankNullFixer(FixTypes.CHUNK));
        fixs.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new DankNullFixer(FixTypes.ENTITY));
        fixs.registerFix((IFixType)FixTypes.PLAYER, (IFixableData)new DankNullFixer(FixTypes.PLAYER));
    }

    public static class DankNullFixer
    implements IFixableData {
        private static final ResourceLocation oldDankNull = new ResourceLocation("danknull", "dank_null");
        private static final ResourceLocation oldDankNullPanel = new ResourceLocation("danknull", "dank_null_panel");
        final FixTypes fixType;

        public DankNullFixer(FixTypes fixType) {
            this.fixType = fixType;
        }

        public int func_188216_a() {
            return 101;
        }

        public NBTTagCompound func_188217_a(NBTTagCompound nbt) {
            if (this.fixType == FixTypes.BLOCK_ENTITY || this.fixType == FixTypes.CHUNK) {
                NBTTagList entityList;
                NBTTagCompound lvlNBT;
                if (nbt.func_74764_b("Level") && (lvlNBT = nbt.func_74775_l("Level")).func_150297_b("Entities", 9) && !(entityList = lvlNBT.func_150295_c("Entities", 0)).func_82582_d()) {
                    System.out.println(entityList);
                }
                if (nbt.func_150297_b("DankNullStack", 10)) {
                    nbt.func_74782_a("DankNullStack", (NBTBase)this.getNewDankNull(nbt.func_74775_l("DankNullStack")));
                }
            }
            if (nbt.func_150297_b("id", 8)) {
                if (this.isDankNullDock(nbt)) {
                    if (!ItemBlockDankNullDock.getDockedDankNull(new ItemStack(nbt)).func_190926_b()) {
                        nbt = this.getNewDankDock(nbt);
                    }
                } else if (this.isDankNullItem(nbt)) {
                    nbt = this.getNewDankNull(nbt);
                }
            } else if (nbt.func_150297_b("Inventory", 9)) {
                NBTTagList nbttaglist = nbt.func_150295_c("Inventory", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound currentNBT = nbttaglist.func_150305_b(i);
                    if (this.isDankNullDock(currentNBT)) {
                        if (!ItemBlockDankNullDock.getDockedDankNull(new ItemStack(currentNBT)).func_190926_b()) {
                            currentNBT = this.getNewDankDock(currentNBT);
                        }
                    } else if (this.isDankNullItem(currentNBT)) {
                        currentNBT = this.getNewDankNull(currentNBT);
                    }
                    nbttaglist.func_150304_a(i, (NBTBase)currentNBT);
                }
                nbt.func_74782_a("Inventory", (NBTBase)nbttaglist);
            } else if (nbt.func_150297_b("DankNullStack", 10)) {
                nbt.func_74782_a("DankNullStack", (NBTBase)this.getNewDankNull(nbt.func_74775_l("DankNullStack")));
            }
            return nbt;
        }

        private NBTTagCompound getNewDankDock(NBTTagCompound dockNBT) {
            ItemStack dankDock = new ItemStack(dockNBT);
            ItemStack dankNull = ItemBlockDankNullDock.getDockedDankNull(new ItemStack(dockNBT));
            if (!dankNull.func_190926_b()) {
                DankNullFixer.setDockedDankNull(dankDock, new ItemStack(this.getNewDankNull(dankNull.serializeNBT())));
            }
            return dankDock.serializeNBT();
        }

        private static void setDockedDankNull(ItemStack dankNullDock, ItemStack newDankNull) {
            if (!dankNullDock.func_77942_o()) {
                dankNullDock.func_77982_d(new NBTTagCompound());
            }
            if (dankNullDock.func_77978_p().func_150297_b("BlockEntityTag", 10)) {
                NBTTagCompound nbt = dankNullDock.func_77978_p().func_74775_l("BlockEntityTag");
                nbt.func_74782_a("DankNullStack", (NBTBase)newDankNull.serializeNBT());
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74782_a("DankNullStack", (NBTBase)newDankNull.serializeNBT());
                dankNullDock.func_77978_p().func_74782_a("BlockEntityTag", (NBTBase)nbt);
            }
        }

        private NBTTagCompound getNewDankNull(NBTTagCompound dankNullNBT) {
            ResourceLocation regName = new ResourceLocation(dankNullNBT.func_74779_i("id"));
            short dmg = dankNullNBT.func_74765_d("Damage");
            String newName = regName.equals((Object)oldDankNull) ? this.getNewDNRegName(dmg) : this.getNewPanelRegName(dmg);
            dankNullNBT.func_74778_a("id", newName);
            dankNullNBT.func_74777_a("Damage", (short)0);
            ModLogger.debug("Item with id {}:{} found. Updated to {}:0", regName.toString(), dmg, newName);
            return dankNullNBT;
        }

        private boolean isDankNullDock(NBTTagCompound nbt) {
            ResourceLocation regName = new ResourceLocation(nbt.func_74779_i("id"));
            return regName != null && regName.equals((Object)new ResourceLocation("danknull", "danknull_dock"));
        }

        private boolean isDankNullItem(NBTTagCompound nbt) {
            ResourceLocation regName = new ResourceLocation(nbt.func_74779_i("id"));
            return regName != null && (regName.equals((Object)oldDankNull) || regName.equals((Object)oldDankNullPanel));
        }

        private String getNewDNRegName(int oldMeta) {
            return "danknull:dank_null_" + oldMeta;
        }

        private String getNewPanelRegName(int oldMeta) {
            return "danknull:dank_null_panel_" + oldMeta;
        }
    }
}

