/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.gui.GuiDankNull;
import p455w0rd.danknull.client.render.HUDRenderer;
import p455w0rd.danknull.init.ModBlocks;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModItems;
import p455w0rd.danknull.init.ModKeyBindings;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.init.ModRecipes;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.inventory.cap.CapabilityDankNull;
import p455w0rd.danknull.inventory.slot.SlotDankNull;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.network.PacketChangeMode;
import p455w0rd.danknull.network.PacketEmptyDock;
import p455w0rd.danknull.network.PacketOpenGui;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.ItemUtils;

@Mod.EventBusSubscriber(modid="danknull")
public class ModEvents {
    @SubscribeEvent
    public static void onRecipeRegistryReady(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.register(event);
    }

    @SubscribeEvent
    public static void onBlockRegistryReady(RegistryEvent.Register<Block> event) {
        ModBlocks.register(event);
    }

    @SubscribeEvent
    public static void onItemRegistryReady(RegistryEvent.Register<Item> event) {
        ModItems.register(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        ModBlocks.registerModels();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderOverlayEvent(RenderGameOverlayEvent event) {
        if (ModGlobals.GUI_DANKNULL_ISOPEN && (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR || event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS || event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.getType() == RenderGameOverlayEvent.ElementType.FOOD || event.getType() == RenderGameOverlayEvent.ElementType.HEALTH || event.getType() == RenderGameOverlayEvent.ElementType.ARMOR)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemPickUp(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack entityStack = event.getItem().func_92059_d();
        if (entityStack.func_190926_b() || player == null || !(player instanceof EntityPlayerMP)) {
            return;
        }
        if (event.getItem().getEntityData().func_74764_b("PreventRemoteMovement")) {
            return;
        }
        PlayerSlot dankNull = ModEvents.getDankNullForStack(player, entityStack);
        if (dankNull != null) {
            IDankNullHandler dankNullHandler = (IDankNullHandler)dankNull.getStackInSlot(player).getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
            ItemStack leftover = dankNullHandler.insertItem(0, entityStack, false);
            if (entityStack.func_190916_E() != leftover.func_190916_E()) {
                entityStack.func_190920_e(leftover.func_190916_E());
                if (leftover.func_190926_b()) {
                    player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, player.func_184176_by(), 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
            }
        }
    }

    private static PlayerSlot getDankNullForStack(EntityPlayer player, ItemStack stack) {
        List<PlayerSlot> dankNulls = ItemDankNull.getDankNullsForPlayer(player);
        for (PlayerSlot slot : dankNulls) {
            ItemStack itemStack = slot.getStackInSlot(player);
            if (!itemStack.hasCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null)) continue;
            IDankNullHandler dankNullHandler = (IDankNullHandler)itemStack.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
            if (dankNullHandler.containsItemStack(stack)) {
                return slot;
            }
            if (!dankNullHandler.isOreDictFiltered(stack)) continue;
            return slot;
        }
        return null;
    }

    @SubscribeEvent
    public static void updateMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String modId = mapping.key.func_110624_b();
            String regPath = mapping.key.func_110623_a();
            if (!modId.equals("danknull")) continue;
            if (regPath.equals("dank_null")) {
                mapping.remap((IForgeRegistryEntry)ModItems.REDSTONE_DANKNULL);
                continue;
            }
            if (!regPath.equals("dank_null_panel")) continue;
            mapping.remap((IForgeRegistryEntry)ModItems.REDSTONE_PANEL);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (ModKeyBindings.isAnyModKeybindPressed()) {
            List<PlayerSlot> dankNulls;
            if (ModKeyBindings.getToggleHUDKeyBind().func_151468_f()) {
                HUDRenderer.toggleHUD();
            }
            EntityPlayer player = EasyMappings.player();
            if (ModKeyBindings.getOpenDankNullKeyBind().func_151468_f() && !(dankNulls = ItemDankNull.getDankNullsForPlayer(player)).isEmpty()) {
                ModNetworking.getInstance().sendToServer((IMessage)new PacketOpenGui(dankNulls.get(0)));
            }
        }
    }

    @SubscribeEvent
    public static void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT) {
            if (ModGlobals.TIME >= 360.1f) {
                ModGlobals.TIME = 0.0f;
            }
            ModGlobals.TIME += 0.75f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseEventCustom(GuiScreenEvent.MouseInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiDankNull && Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            int mouseY;
            EntityPlayerSP player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            boolean shouldCancel = false;
            GuiDankNull dankNullGui = (GuiDankNull)mc.field_71462_r;
            IDankNullHandler dankNullHandler = dankNullGui.getDankNullHandler();
            int width = dankNullGui.field_146294_l;
            int height = dankNullGui.field_146295_m;
            int mouseX = Mouse.getEventX() * width / mc.field_71443_c;
            Slot hoveredSlot = dankNullGui.getSlotAtPos(mouseX, mouseY = height - Mouse.getEventY() * height / mc.field_71440_d - 1);
            if (hoveredSlot instanceof SlotDankNull && hoveredSlot.func_75216_d() && Mouse.isButtonDown((int)0)) {
                PacketChangeMode syncPacket = null;
                if (GuiScreen.func_146271_m() && !GuiScreen.func_175283_s()) {
                    dankNullHandler.cycleExtractionMode(hoveredSlot.func_75211_c(), true);
                    syncPacket = new PacketChangeMode(dankNullHandler.getExtractionMode(hoveredSlot.func_75211_c()), hoveredSlot.getSlotIndex());
                    shouldCancel = true;
                } else if (GuiScreen.func_175283_s() && !GuiScreen.func_146271_m()) {
                    if (dankNullHandler.getSelected() < 0 || !ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)dankNullHandler.getFullStackInSlot(dankNullHandler.getSelected()), (ItemStack)hoveredSlot.func_75211_c())) {
                        int count = 0;
                        for (Slot slotHovered : dankNullGui.field_147002_h.field_75151_b) {
                            ++count;
                            if (!slotHovered.equals(hoveredSlot)) continue;
                            int index = count - 1 - 36;
                            dankNullHandler.setSelected(index);
                            syncPacket = new PacketChangeMode(PacketChangeMode.ChangeType.SELECTED, hoveredSlot.getSlotIndex());
                            shouldCancel = true;
                        }
                    }
                } else if (Keyboard.isKeyDown((int)24) && !GuiScreen.func_175283_s() && !GuiScreen.func_146271_m()) {
                    if (ModConfig.isOreDictBlacklistEnabled() && !ModConfig.isItemOreDictBlacklisted(hoveredSlot.func_75211_c()) || ModConfig.isOreDictWhitelistEnabled() && ModConfig.isItemOreDictWhitelisted(hoveredSlot.func_75211_c()) || !ModConfig.isOreDictBlacklistEnabled() && !ModConfig.isOreDictWhitelistEnabled()) {
                        dankNullHandler.setOre(hoveredSlot.func_75211_c(), !dankNullHandler.isOre(hoveredSlot.func_75211_c()));
                        syncPacket = new PacketChangeMode(dankNullHandler.isOre(hoveredSlot.func_75211_c()) ? PacketChangeMode.ChangeType.ORE_ON : PacketChangeMode.ChangeType.ORE_OFF, hoveredSlot.getSlotIndex());
                        shouldCancel = true;
                    }
                } else if (Keyboard.isKeyDown((int)25) && !GuiScreen.func_175283_s() && !GuiScreen.func_146271_m()) {
                    dankNullHandler.cyclePlacementMode(hoveredSlot.func_75211_c(), true);
                    syncPacket = new PacketChangeMode(dankNullHandler.getPlacementMode(hoveredSlot.func_75211_c()), hoveredSlot.getSlotIndex());
                    shouldCancel = true;
                }
                if (syncPacket != null) {
                    ModNetworking.getInstance().sendToServer(syncPacket);
                }
                if (shouldCancel) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseEvent(MouseEvent event) {
        IDankNullHandler dankNullHandler;
        EntityPlayer player = EasyMappings.player();
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (event.isButtonstate() && event.getButton() == 2 && event.getDwheel() == 0) {
            dankNullHandler = ModEvents.getHandlerFromHeld(player);
            if (dankNullHandler == null) {
                return;
            }
            RayTraceResult target = mc.field_71476_x;
            if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState state = world.func_180495_p(target.func_178782_a());
                if (world.func_175623_d(target.func_178782_a())) {
                    return;
                }
                ItemStack stackToSelect = state.func_177230_c().getPickBlock(state, target, (World)world, target.func_178782_a(), player);
                if (!stackToSelect.func_190926_b() && (dankNullHandler.containsItemStack(stackToSelect) || dankNullHandler.isOre(stackToSelect))) {
                    int newIndex = dankNullHandler.findItemStack(stackToSelect);
                    dankNullHandler.setSelected(newIndex);
                    ModNetworking.getInstance().sendToServer((IMessage)new PacketChangeMode(PacketChangeMode.ChangeType.SELECTED, newIndex, dankNullHandler.getUUID()));
                    event.setCanceled(true);
                }
            }
        }
        if (ModKeyBindings.isAnyModKeybindPressed() && event.getDwheel() == 0) {
            dankNullHandler = ModEvents.getHandlerFromHeld(player);
            if (dankNullHandler == null) {
                return;
            }
            int currentIndex = dankNullHandler.getSelected();
            int totalSize = dankNullHandler.stackCount();
            if (currentIndex == -1 || totalSize <= 1) {
                return;
            }
            if (ModKeyBindings.getNextItemKeyBind().func_151468_f()) {
                dankNullHandler.cycleSelected(true);
                ModNetworking.getInstance().sendToServer((IMessage)new PacketChangeMode(PacketChangeMode.ChangeType.SELECTED, dankNullHandler.getSelected(), dankNullHandler.getUUID()));
                event.setCanceled(true);
            } else if (ModKeyBindings.getPreviousItemKeyBind().func_151468_f()) {
                dankNullHandler.cycleSelected(false);
                ModNetworking.getInstance().sendToServer((IMessage)new PacketChangeMode(PacketChangeMode.ChangeType.SELECTED, dankNullHandler.getSelected(), dankNullHandler.getUUID()));
                event.setCanceled(true);
            }
        } else if (event.getDwheel() != 0 && player.func_70093_af()) {
            dankNullHandler = ModEvents.getHandlerFromHeld(player);
            if (dankNullHandler == null) {
                return;
            }
            int currentIndex = dankNullHandler.getSelected();
            int totalSize = dankNullHandler.stackCount();
            if (currentIndex == -1 || totalSize <= 1) {
                return;
            }
            int scrollForward = event.getDwheel();
            if (scrollForward < 0) {
                dankNullHandler.cycleSelected(true);
                ModNetworking.getInstance().sendToServer((IMessage)new PacketChangeMode(PacketChangeMode.ChangeType.SELECTED, dankNullHandler.getSelected(), dankNullHandler.getUUID()));
                event.setCanceled(true);
            } else if (scrollForward > 0) {
                dankNullHandler.cycleSelected(false);
                ModNetworking.getInstance().sendToServer((IMessage)new PacketChangeMode(PacketChangeMode.ChangeType.SELECTED, dankNullHandler.getSelected(), dankNullHandler.getUUID()));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        TileDankNullDock dankDock = null;
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileDankNullDock) {
            dankDock = (TileDankNullDock)world.func_175625_s(pos);
        }
        if (dankDock != null) {
            if (player.func_184102_h().func_175579_a(world, pos, player)) {
                return;
            }
            if (player.func_184586_b(hand).func_190926_b() && player.func_70093_af() && !dankDock.getDankNull().func_190926_b()) {
                player.func_184611_a(hand, dankDock.getDankNull().func_77946_l());
                dankDock.removeDankNull();
                ModNetworking.getInstance().sendToAll((IMessage)new PacketEmptyDock(dankDock.func_174877_v()));
                dankDock.func_70296_d();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPostRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            HUDRenderer.renderHUD(mc, new ScaledResolution(mc));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onWorldLoaded(WorldEvent.Load event) {
        if (!LibGlobals.Mods.NEI.isLoaded() || FMLCommonHandler.instance().getSide().isClient()) {
            // empty if block
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player != null && event.player instanceof EntityPlayerMP) {
            ModConfig.sendConfigsToClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("danknull")) {
            ModConfig.init();
        }
    }

    private static IDankNullHandler getHandlerFromHeld(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        if (ItemDankNull.isDankNull(player.func_184614_ca())) {
            return (IDankNullHandler)player.func_184614_ca().getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
        }
        if (ItemDankNull.isDankNull(player.func_184592_cb())) {
            return (IDankNullHandler)player.func_184592_cb().getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
        }
        return null;
    }
}

