/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory.cap;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.api.IDankNullHandler;

public class CapabilityDankNull {
    @CapabilityInject(value=IDankNullHandler.class)
    public static Capability<IDankNullHandler> DANK_NULL_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IDankNullHandler.class, (Capability.IStorage)new Capability.IStorage<IDankNullHandler>(){

            public NBTBase writeNBT(Capability<IDankNullHandler> capability, IDankNullHandler instance, EnumFacing side) {
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagList items = new NBTTagList();
                for (int i = 0; i < instance.getSlots(); ++i) {
                    ItemStack stack2 = instance.getFullStackInSlot(i);
                    if (stack2.func_190926_b()) continue;
                    NBTTagCompound item = new NBTTagCompound();
                    stack2.func_77955_b(item);
                    item.func_74768_a("Slot", i);
                    item.func_74768_a("Count", stack2.func_190916_E());
                    items.func_74742_a((NBTBase)item);
                }
                NBTTagList ores = new NBTTagList();
                instance.getOres().forEach((stack, ore) -> {
                    NBTTagCompound oreTag = new NBTTagCompound();
                    oreTag.func_74757_a("OreDict", ore.booleanValue());
                    oreTag.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
                    ores.func_74742_a((NBTBase)oreTag);
                });
                NBTTagList extractionModes = new NBTTagList();
                instance.getExtractionModes().forEach((stack, mode) -> {
                    NBTTagCompound extractionTag = new NBTTagCompound();
                    extractionTag.func_74768_a("Mode", mode.ordinal());
                    extractionTag.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
                    extractionModes.func_74742_a((NBTBase)extractionTag);
                });
                NBTTagList placementModes = new NBTTagList();
                instance.getPlacementMode().forEach((stack, mode) -> {
                    NBTTagCompound placementTag = new NBTTagCompound();
                    placementTag.func_74768_a("Mode", mode.ordinal());
                    placementTag.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
                    placementModes.func_74742_a((NBTBase)placementTag);
                });
                if (!items.func_82582_d()) {
                    tag.func_74782_a("danknull-inventory", (NBTBase)items);
                }
                if (!ores.func_82582_d()) {
                    tag.func_74782_a("OreDictModes", (NBTBase)ores);
                }
                if (!extractionModes.func_82582_d()) {
                    tag.func_74782_a("ExtractionModes", (NBTBase)extractionModes);
                }
                if (!placementModes.func_82582_d()) {
                    tag.func_74782_a("PlacementModes", (NBTBase)placementModes);
                }
                if (instance.getSelected() > -1) {
                    tag.func_74768_a("selectedIndex", instance.getSelected());
                }
                if (instance.isLocked()) {
                    tag.func_74757_a("Locked", instance.isLocked());
                }
                if (!instance.getUUID().isEmpty()) {
                    tag.func_74778_a("UUID", instance.getUUID());
                }
                return tag;
            }

            public void readNBT(Capability<IDankNullHandler> capability, IDankNullHandler instance, EnumFacing side, NBTBase base) {
                int mode;
                NBTTagCompound item;
                int i;
                NBTTagList items;
                NBTTagCompound tag = (NBTTagCompound)base;
                if (tag.func_82582_d()) {
                    return;
                }
                if (tag.func_74764_b("danknull-inventory")) {
                    items = tag.func_150295_c("danknull-inventory", 10);
                    for (i = 0; i < items.func_74745_c(); ++i) {
                        item = items.func_150305_b(i);
                        int slot = item.func_74762_e("Slot");
                        int count = item.func_74762_e("Count");
                        ItemStack stack = new ItemStack(item);
                        stack.func_190920_e(count);
                        instance.setStackInSlot(slot, stack);
                    }
                }
                if (tag.func_74764_b("OreDictModes")) {
                    items = tag.func_150295_c("OreDictModes", 10);
                    for (i = 0; i < items.func_74745_c(); ++i) {
                        item = items.func_150305_b(i);
                        boolean oreDict = item.func_74767_n("OreDict");
                        ItemStack stack = new ItemStack(item.func_74775_l("Stack"));
                        instance.setOre(stack, oreDict);
                    }
                }
                if (tag.func_74764_b("ExtractionModes")) {
                    items = tag.func_150295_c("ExtractionModes", 10);
                    for (i = 0; i < items.func_74745_c(); ++i) {
                        item = items.func_150305_b(i);
                        mode = item.func_74762_e("Mode");
                        ItemStack stack = new ItemStack(item.func_74775_l("Stack"));
                        instance.setExtractionMode(stack, DankNullItemModes.ItemExtractionMode.VALUES[mode]);
                    }
                }
                if (tag.func_74764_b("PlacementModes")) {
                    items = tag.func_150295_c("PlacementModes", 10);
                    for (i = 0; i < items.func_74745_c(); ++i) {
                        item = items.func_150305_b(i);
                        mode = item.func_74762_e("Mode");
                        ItemStack stack = new ItemStack(item.func_74775_l("Stack"));
                        instance.setPlacementMode(stack, DankNullItemModes.ItemPlacementMode.VALUES[mode]);
                    }
                }
                if (tag.func_74764_b("selectedIndex")) {
                    instance.setSelected(tag.func_74762_e("selectedIndex"));
                }
                if (tag.func_74764_b("Locked")) {
                    instance.setLocked(tag.func_74767_n("Locked"));
                }
                if (tag.func_74764_b("UUID")) {
                    instance.setUUID(tag.func_74779_i("UUID"));
                }
            }
        }, () -> null);
    }
}

