/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.container.ContainerDankNull;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.inventory.cap.CapabilityDankNull;
import p455w0rd.danknull.items.ItemDankNull;

public class PacketChangeMode
implements IMessage {
    private ChangeType changeType;
    private int slot = -1;
    private String uuid = "";

    public PacketChangeMode() {
    }

    public PacketChangeMode(ChangeType changeType) {
        this.changeType = changeType;
    }

    public PacketChangeMode(DankNullItemModes.ItemPlacementMode mode, int slot) {
        switch (mode) {
            case KEEP_NONE: {
                this.changeType = ChangeType.PLACE_KEEP_NONE;
                break;
            }
            case KEEP_1: {
                this.changeType = ChangeType.PLACE_KEEP_1;
                break;
            }
            case KEEP_16: {
                this.changeType = ChangeType.PLACE_KEEP_16;
                break;
            }
            case KEEP_64: {
                this.changeType = ChangeType.PLACE_KEEP_64;
                break;
            }
            case KEEP_ALL: {
                this.changeType = ChangeType.PLACE_KEEP_ALL;
                break;
            }
            default: {
                throw new RuntimeException("Unknown ItemPlacementMode " + mode.name());
            }
        }
        this.slot = slot;
    }

    public PacketChangeMode(DankNullItemModes.ItemExtractionMode mode, int slot) {
        switch (mode) {
            case KEEP_NONE: {
                this.changeType = ChangeType.EXTRACT_KEEP_NONE;
                break;
            }
            case KEEP_1: {
                this.changeType = ChangeType.EXTRACT_KEEP_1;
                break;
            }
            case KEEP_16: {
                this.changeType = ChangeType.EXTRACT_KEEP_16;
                break;
            }
            case KEEP_64: {
                this.changeType = ChangeType.EXTRACT_KEEP_64;
                break;
            }
            case KEEP_ALL: {
                this.changeType = ChangeType.EXTRACT_KEEP_ALL;
                break;
            }
            default: {
                throw new RuntimeException("Unknown ItemExtractionMode " + mode.name());
            }
        }
        this.slot = slot;
    }

    public PacketChangeMode(ChangeType type, int slot) {
        this.changeType = type;
        this.slot = slot;
    }

    public PacketChangeMode(ChangeType type, int slot, String uuid) {
        this.changeType = type;
        this.slot = slot;
        this.uuid = uuid;
    }

    public PacketChangeMode(ChangeType type, String uuid) {
        this.changeType = type;
        this.uuid = uuid;
    }

    public void fromBytes(ByteBuf buf) {
        this.changeType = ChangeType.VALUES[buf.readInt()];
        this.slot = buf.readInt();
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.changeType.ordinal());
        buf.writeInt(this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
    }

    private static void handleModeUpdate(IDankNullHandler handler, ChangeType changeType, int slot) {
        ItemStack slotStack = slot >= 0 && slot < handler.getSlots() ? handler.getFullStackInSlot(slot) : ItemStack.field_190927_a;
        switch (changeType) {
            case SELECTED: {
                handler.setSelected(slot);
                break;
            }
            case LOCK: {
                handler.setLocked(true);
                break;
            }
            case UNLOCK: {
                handler.setLocked(false);
                break;
            }
            case ORE_ON: {
                handler.setOre(slotStack, true);
                break;
            }
            case ORE_OFF: {
                handler.setOre(slotStack, false);
                break;
            }
            case EXTRACT_KEEP_ALL: {
                handler.setExtractionMode(slotStack, DankNullItemModes.ItemExtractionMode.KEEP_ALL);
                break;
            }
            case EXTRACT_KEEP_1: {
                handler.setExtractionMode(slotStack, DankNullItemModes.ItemExtractionMode.KEEP_1);
                break;
            }
            case EXTRACT_KEEP_16: {
                handler.setExtractionMode(slotStack, DankNullItemModes.ItemExtractionMode.KEEP_16);
                break;
            }
            case EXTRACT_KEEP_64: {
                handler.setExtractionMode(slotStack, DankNullItemModes.ItemExtractionMode.KEEP_64);
                break;
            }
            case EXTRACT_KEEP_NONE: {
                handler.setExtractionMode(slotStack, DankNullItemModes.ItemExtractionMode.KEEP_NONE);
                break;
            }
            case PLACE_KEEP_ALL: {
                handler.setPlacementMode(slotStack, DankNullItemModes.ItemPlacementMode.KEEP_ALL);
                break;
            }
            case PLACE_KEEP_1: {
                handler.setPlacementMode(slotStack, DankNullItemModes.ItemPlacementMode.KEEP_1);
                break;
            }
            case PLACE_KEEP_16: {
                handler.setPlacementMode(slotStack, DankNullItemModes.ItemPlacementMode.KEEP_16);
                break;
            }
            case PLACE_KEEP_64: {
                handler.setPlacementMode(slotStack, DankNullItemModes.ItemPlacementMode.KEEP_64);
                break;
            }
            case PLACE_KEEP_NONE: {
                handler.setPlacementMode(slotStack, DankNullItemModes.ItemPlacementMode.KEEP_NONE);
            }
        }
    }

    public static enum ChangeType {
        LOCK,
        UNLOCK,
        SELECTED,
        ORE_ON,
        ORE_OFF,
        EXTRACT_KEEP_ALL,
        EXTRACT_KEEP_1,
        EXTRACT_KEEP_16,
        EXTRACT_KEEP_64,
        EXTRACT_KEEP_NONE,
        PLACE_KEEP_ALL,
        PLACE_KEEP_1,
        PLACE_KEEP_16,
        PLACE_KEEP_64,
        PLACE_KEEP_NONE;

        public static ChangeType[] VALUES;

        static {
            VALUES = ChangeType.values();
        }
    }

    public static class Handler
    implements IMessageHandler<PacketChangeMode, IMessage> {
        private static ItemStack findDankNull(EntityPlayer player, String uuid) {
            List<PlayerSlot> dankNulls = ItemDankNull.getDankNullsForPlayer(player);
            for (PlayerSlot slot : dankNulls) {
                IDankNullHandler dankNullHandler;
                ItemStack itemStack = slot.getStackInSlot(player);
                if (!itemStack.hasCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null) || !(dankNullHandler = (IDankNullHandler)itemStack.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null)).getUUID().equalsIgnoreCase(uuid)) continue;
                return itemStack;
            }
            return null;
        }

        public IMessage onMessage(PacketChangeMode message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                ItemStack stack;
                Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
                if (container instanceof ContainerDankNull) {
                    PacketChangeMode.handleModeUpdate(((ContainerDankNull)container).getHandler(), message.changeType, message.slot);
                } else if (message.uuid != null && !message.uuid.isEmpty() && (stack = Handler.findDankNull((EntityPlayer)ctx.getServerHandler().field_147369_b, message.uuid)) != null && stack.hasCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null)) {
                    PacketChangeMode.handleModeUpdate((IDankNullHandler)stack.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null), message.changeType, message.slot);
                }
            });
            return null;
        }
    }
}

