/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.Random;
import lumien.randomthings.RandomThings;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.lib.INoItem;
import lumien.randomthings.tileentity.TileEntityAdvancedRedstoneRepeater;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAdvancedRedstoneRepeater
extends BlockContainerBase
implements INoItem {
    public static final PropertyBool LOCKED = PropertyBool.func_177716_a((String)"locked");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB REDSTONE_DIODE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected final boolean isRepeaterPowered;

    protected BlockAdvancedRedstoneRepeater(boolean powered) {
        super("advancedRedstoneRepeater" + (powered ? "_powered" : ""), Material.field_151594_q);
        this.isRepeaterPowered = powered;
    }

    @Override
    public boolean hasNoItem() {
        return this.func_149739_a().endsWith("_powered");
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)RandomThings.instance, 27, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return enumfacing == side || enumfacing.func_176734_d() == side;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAdvancedRedstoneRepeater();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return REDSTONE_DIODE_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() ? super.func_176196_c(worldIn, pos) : false;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.isLocked((IBlockAccess)worldIn, pos, state)) {
            boolean flag = this.shouldBePowered(worldIn, pos, state);
            if (this.isRepeaterPowered && !flag) {
                worldIn.func_180501_a(pos, this.getUnpoweredState(state), 2);
            } else if (!this.isRepeaterPowered) {
                worldIn.func_180501_a(pos, this.getPoweredState(state), 2);
                if (!flag) {
                    worldIn.func_175654_a(pos, this.getPoweredState(state).func_177230_c(), this.getDelay((IBlockAccess)worldIn, pos, true, false), -1);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side.func_176740_k() != EnumFacing.Axis.Y;
    }

    protected boolean isPowered(IBlockState state) {
        return this.isRepeaterPowered;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.isPowered(blockState)) {
            return 0;
        }
        return blockState.func_177229_b((IProperty)FACING) == side ? this.getActiveSignal(blockAccess, pos, blockState) : 0;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.canBlockStay(worldIn, pos)) {
            this.updateState(worldIn, pos, state);
        } else {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    protected void updateState(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag;
        if (!this.isLocked((IBlockAccess)worldIn, pos, state) && this.isRepeaterPowered != (flag = this.shouldBePowered(worldIn, pos, state)) && !worldIn.func_175691_a(pos, (Block)this)) {
            int i = -1;
            if (this.isFacingTowardsRepeater(worldIn, pos, state)) {
                i = -3;
            } else if (this.isRepeaterPowered) {
                i = -2;
            }
            worldIn.func_175654_a(pos, (Block)this, this.getDelay((IBlockAccess)worldIn, pos, this.isRepeaterPowered, flag), i);
        }
    }

    protected boolean shouldBePowered(World worldIn, BlockPos pos, IBlockState state) {
        return this.calculateInputStrength(worldIn, pos, state) > 0;
    }

    protected int calculateInputStrength(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(enumfacing);
        int i = worldIn.func_175651_c(blockpos, enumfacing);
        if (i >= 15) {
            return i;
        }
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        return Math.max(i, iblockstate.func_177230_c() == Blocks.field_150488_af ? (Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0);
    }

    protected int getPowerOnSides(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing enumfacing1 = enumfacing.func_176746_e();
        EnumFacing enumfacing2 = enumfacing.func_176735_f();
        return Math.max(this.getPowerOnSide(worldIn, pos.func_177972_a(enumfacing1), enumfacing1), this.getPowerOnSide(worldIn, pos.func_177972_a(enumfacing2), enumfacing2));
    }

    protected int getPowerOnSide(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (this.isAlternateInput(iblockstate)) {
            if (block == Blocks.field_150451_bX) {
                return 15;
            }
            return block == Blocks.field_150488_af ? ((Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : worldIn.func_175627_a(pos, side);
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.shouldBePowered(worldIn, pos, state)) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.notifyNeighbors(worldIn, pos, state);
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(enumfacing.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), EnumSet.of(enumfacing.func_176734_d()), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(blockpos, (Block)this, pos);
        worldIn.func_175695_a(blockpos, (Block)this, enumfacing);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isRepeaterPowered) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
        super.func_176206_d(worldIn, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected int getActiveSignal(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        return 15;
    }

    public static boolean isDiode(IBlockState state) {
        return ModBlocks.unpoweredAdvancedRedstoneRepeater.isSameDiode(state) || ModBlocks.unpoweredAdvancedRedstoneRepeater.isSameDiode(state);
    }

    public boolean isSameDiode(IBlockState state) {
        Block block = state.func_177230_c();
        return block == this.getPoweredState(this.func_176223_P()).func_177230_c() || block == this.getUnpoweredState(this.func_176223_P()).func_177230_c();
    }

    public boolean isFacingTowardsRepeater(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing);
        if (BlockAdvancedRedstoneRepeater.isDiode(worldIn.func_180495_p(blockpos))) {
            return worldIn.func_180495_p(blockpos).func_177229_b((IProperty)FACING) != enumfacing;
        }
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(this.isLocked(worldIn, pos, state)));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected int getDelay(IBlockAccess world, BlockPos pos, boolean oldState, boolean newState) {
        TileEntityAdvancedRedstoneRepeater te = (TileEntityAdvancedRedstoneRepeater)world.func_175625_s(pos);
        if (oldState && !newState) {
            return te.getTurnOffDelay();
        }
        return te.getTurnOnDelay();
    }

    protected IBlockState getPoweredState(IBlockState unpoweredState) {
        Boolean obool = (Boolean)unpoweredState.func_177229_b((IProperty)LOCKED);
        EnumFacing enumfacing = (EnumFacing)unpoweredState.func_177229_b((IProperty)FACING);
        return ModBlocks.poweredAdvancedRedstoneRepeater.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)LOCKED, (Comparable)obool);
    }

    protected IBlockState getUnpoweredState(IBlockState poweredState) {
        Boolean obool = (Boolean)poweredState.func_177229_b((IProperty)LOCKED);
        EnumFacing enumfacing = (EnumFacing)poweredState.func_177229_b((IProperty)FACING);
        return ModBlocks.unpoweredAdvancedRedstoneRepeater.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)LOCKED, (Comparable)obool);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.unpoweredAdvancedRedstoneRepeater);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.unpoweredAdvancedRedstoneRepeater);
    }

    public boolean isLocked(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        return this.getPowerOnSides(worldIn, pos, state) > 0;
    }

    protected boolean isAlternateInput(IBlockState state) {
        return BlockAdvancedRedstoneRepeater.isDiode(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isRepeaterPowered) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)pos.func_177956_o() + 0.4f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            float f = -5.0f;
            double d3 = (f /= 16.0f) * (float)enumfacing.func_82601_c();
            double d4 = f * (float)enumfacing.func_82599_e();
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState newState = worldIn.func_180495_p(pos);
        if (newState.func_177230_c() == ModBlocks.poweredAdvancedRedstoneRepeater || newState.func_177230_c() == ModBlocks.unpoweredAdvancedRedstoneRepeater) {
            return;
        }
        super.func_180663_b(worldIn, pos, state);
        this.notifyNeighbors(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)LOCKED, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LOCKED});
    }

    public boolean func_149667_c(Block other) {
        return this.isSameDiode(other.func_176223_P());
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (super.rotateBlock(world, pos, axis)) {
            IBlockState state = world.func_180495_p(pos);
            state = this.getUnpoweredState(state);
            world.func_175656_a(pos, state);
            if (this.shouldBePowered(world, pos, state)) {
                world.func_175684_a(pos, (Block)this, 1);
            }
            return true;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

