/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block.plates;

import com.google.common.base.Predicate;
import lumien.randomthings.RandomThings;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.tileentity.TileEntityProcessingPlate;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockProcessingPlate
extends BlockContainerBase {
    protected static final AxisAlignedBB AABB = null;
    protected static final AxisAlignedBB VISUAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    public static final PropertyDirection INPUT_FACING = PropertyDirection.func_177712_a((String)"inputfacing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection OUTPUT_FACING = PropertyDirection.func_177712_a((String)"outputfacing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockProcessingPlate() {
        super("plate_processing", Material.field_151576_e);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityProcessingPlate();
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceOn(worldIn, pos.func_177977_b());
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos, EnumFacing.UP);
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceOn(worldIn, pos.func_177977_b())) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return VISUAL_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side == EnumFacing.UP && playerIn.func_70093_af()) {
            EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OUTPUT_FACING, (Comparable)currentOutput.func_176734_d()));
            return true;
        }
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)RandomThings.instance, 32, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)INPUT_FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)placer.func_174811_aO().func_176746_e());
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
        EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
        return currentInput.ordinal() - 2 + (currentOutput.ordinal() - 2) * 4;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing output = EnumFacing.values()[meta / 4 + 2];
        EnumFacing input = EnumFacing.values()[meta - (output.ordinal() - 2) * 4 + 2];
        return this.func_176223_P().func_177226_a((IProperty)INPUT_FACING, (Comparable)input).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)output);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INPUT_FACING, OUTPUT_FACING});
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityItem && !worldIn.field_72995_K) {
            IItemHandler itemHandler;
            EntityItem ei = (EntityItem)entityIn;
            TileEntityProcessingPlate me = (TileEntityProcessingPlate)worldIn.func_175625_s(pos);
            TileEntity downTE = worldIn.func_175625_s(pos.func_177977_b());
            EnumFacing inputFacing = me.getInsertFacing();
            if (downTE != null && downTE.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inputFacing) && (itemHandler = (IItemHandler)downTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inputFacing)) != null) {
                ItemStack entityItem = ei.func_92059_d();
                ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)entityItem, (boolean)false);
                if (remaining.func_190926_b()) {
                    ei.func_70106_y();
                } else {
                    ei.func_92058_a(remaining);
                }
            }
        }
        if (!entityIn.field_70128_L && entityIn instanceof EntityItem) {
            Vec3d motionVec = new Vec3d(entityIn.field_70159_w, entityIn.field_70181_x, entityIn.field_70179_y);
            EnumFacing roughMovingFacing = EnumFacing.func_176737_a((float)((float)motionVec.field_72450_a), (float)((float)motionVec.field_72448_b), (float)((float)motionVec.field_72449_c)).func_176734_d();
            Vec3d center = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.0, 0.5);
            Vec3d difVec = center.func_178788_d(entityIn.func_174791_d());
            EnumFacing facing = EnumFacing.func_176737_a((float)((float)difVec.field_72450_a), (float)((float)difVec.field_72448_b), (float)((float)difVec.field_72449_c)).func_176734_d();
            EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
            EnumFacing currentSkipFacing = currentInput.func_176734_d();
            EnumFacing outputFacing = null;
            if (facing == currentInput && roughMovingFacing == currentInput) {
                outputFacing = currentSkipFacing;
            } else if (facing == currentSkipFacing && roughMovingFacing == currentSkipFacing) {
                outputFacing = currentInput;
            }
            if (outputFacing != null) {
                Vec3d facingVec = new Vec3d(outputFacing.func_176730_m()).func_186678_a(0.4).func_178787_e(center);
                float dif = facing.func_176734_d().func_185119_l() - outputFacing.func_185119_l();
                Vec3d outputMotionVec = motionVec.func_178785_b((float)Math.toRadians(dif));
                entityIn.func_70107_b(facingVec.field_72450_a, facingVec.field_72448_b, facingVec.field_72449_c);
                entityIn.field_70159_w = outputMotionVec.field_72450_a;
                entityIn.field_70181_x = outputMotionVec.field_72448_b;
                entityIn.field_70179_y = outputMotionVec.field_72449_c;
            }
        }
    }
}

