/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablepump.fluid;

import com.lothrazar.cyclicmagic.block.cable.TileEntityCableBase;
import com.lothrazar.cyclicmagic.block.cablepump.TileEntityBasePump;
import com.lothrazar.cyclicmagic.data.FluidWrapper;
import com.lothrazar.cyclicmagic.data.ITileFluidWrapper;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankBase;
import com.lothrazar.cyclicmagic.util.UtilFluid;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPump
extends TileEntityBasePump
implements ITickable,
ITileRedstoneToggle,
ITileFluidWrapper {
    private NonNullList<FluidWrapper> stacksWrapped = NonNullList.func_191197_a((int)9, (Object)new FluidWrapper());
    private int transferRate = 1000;
    private int filterType = 0;

    public TileEntityFluidPump() {
        super(0);
        this.tank = new FluidTankBase(1000);
    }

    @Override
    public EnumFacing getCurrentFacing() {
        EnumFacing facingTo = super.getCurrentFacing();
        if (facingTo.func_176740_k().func_176720_b()) {
            facingTo = facingTo.func_176734_d();
        }
        return facingTo;
    }

    public void func_73660_a() {
        if (!this.isPowered() && this.onlyRunIfPowered()) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(this.getCurrentFacing());
        UtilFluid.tryFillTankFromPosition(this.field_145850_b, target, this.getCurrentFacing().func_176734_d(), this.tank, this.transferRate, this.isWhitelist(), this.getFilterNonempty());
        if (!this.tank.isFull() && this.field_145850_b.func_180495_p(target).func_185904_a().func_76224_d() && this.transferRate == 1000) {
            UtilParticle.spawnParticle(this.field_145850_b, EnumParticleTypes.WATER_BUBBLE, target);
            IFluidHandler handle = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)target, (EnumFacing)EnumFacing.UP);
            if (handle.getTankProperties() == null || handle.getTankProperties().length == 0) {
                return;
            }
            FluidStack fluidFromWorld = handle.getTankProperties()[0].getContents();
            if (fluidFromWorld != null && UtilFluid.isStackInvalid(fluidFromWorld, this.isWhitelist(), this.getFilterNonempty()) && this.tank.canFillFluidType(fluidFromWorld)) {
                this.tank.fill(fluidFromWorld, true);
                this.field_145850_b.func_175698_g(target);
            }
        }
        List<EnumFacing> sidesOut = this.getSidesNotFacing();
        Collections.shuffle(sidesOut);
        for (EnumFacing exportToSide : sidesOut) {
            this.moveFluid(exportToSide);
        }
    }

    private void moveFluid(EnumFacing myFacingDir) {
        TileEntityCableBase cable;
        if (!this.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, myFacingDir)) {
            return;
        }
        EnumFacing themFacingMe = myFacingDir.func_176734_d();
        BlockPos posSide = this.field_174879_c.func_177972_a(myFacingDir);
        boolean outputSuccess = UtilFluid.tryFillPositionFromTank(this.field_145850_b, posSide, themFacingMe, this.tank, this.transferRate);
        if (outputSuccess && this.field_145850_b.func_175625_s(posSide) instanceof TileEntityCableBase && (cable = (TileEntityCableBase)this.field_145850_b.func_175625_s(posSide)).isFluidPipe()) {
            cable.updateIncomingFluidFace(themFacingMe);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.transferRate = compound.func_74762_e("transferSaved");
        NBTTagList invList = compound.func_150295_c("fluidGhostSlots", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = invList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            FluidWrapper wrapper = FluidWrapper.loadStackWrapperFromNBT(stackTag);
            if (wrapper == null) {
                wrapper = new FluidWrapper();
            }
            this.stacksWrapped.set((int)slot, (Object)wrapper);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("transferSaved", this.transferRate);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.getWrapperCount(); ++i) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            if (this.getStackWrapper(i) != null) {
                this.getStackWrapper(i).writeToNBT(stackTag);
            }
            invList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("fluidGhostSlots", (NBTBase)invList);
        return super.func_189515_b(compound);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
            case FILTERTYPE: {
                return this.filterType;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                if (value <= 0) break;
                this.transferRate = value;
                break;
            }
            case FILTERTYPE: {
                this.filterType = value % 2;
            }
        }
    }

    private boolean isWhitelist() {
        return this.filterType == 1;
    }

    private List<FluidStack> getFilterNonempty() {
        ArrayList<FluidStack> filt = new ArrayList<FluidStack>();
        for (FluidWrapper wrap : this.stacksWrapped) {
            if (wrap.isEmpty()) continue;
            filt.add(wrap.getStack().copy());
        }
        return filt;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int getWrapperCount() {
        return this.stacksWrapped.size();
    }

    @Override
    public FluidWrapper getStackWrapper(int i) {
        FluidWrapper f = (FluidWrapper)this.stacksWrapped.get(i);
        return f;
    }

    @Override
    public void setStackWrapper(int i, FluidWrapper stack) {
        if (stack == null) {
            this.stacksWrapped.set(i, (Object)new FluidWrapper());
        } else {
            this.stacksWrapped.set(i, (Object)stack);
        }
    }

    public static enum Fields {
        REDSTONE,
        TRANSFER_RATE,
        FILTERTYPE;

    }
}

