/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cyclicmagic")
public class EntityProjectileRegistry {
    private static List<EntityEntry> ENTITIES = new ArrayList<EntityEntry>();
    static final int trackingRange = 64;
    static final int updateFrequency = 20;
    static final boolean sendsVelocityUpdates = true;
    static int modEntityId = 1100;

    public static void registerModEntity(Class<? extends Entity> entityClass, String entityName, @Deprecated int id) {
        ENTITIES.add(EntityProjectileRegistry.createEntityEntry(entityName, entityClass));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ENTITIES.toArray(new EntityEntry[0]));
    }

    private static <T extends Entity> EntityEntry createEntityEntry(String name, Class<T> cls) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.entity(cls);
        builder.name("cyclicmagic." + name);
        builder.id(new ResourceLocation("cyclicmagic", name), modEntityId++);
        builder.tracker(64, 20, true);
        return builder.build();
    }
}

