/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;

public class MaterialRegistry {
    private static final int diamondDurability = 33;
    private static final int ironDurability = 15;
    private static final String emeraldName = "emerald";
    private static final String POWER = "power";
    private static final String CRYSTAL = "crystal";
    private static final String GLOWING = "glowing";
    public static Item.ToolMaterial netherToolMaterial;
    public static Item.ToolMaterial sandstoneToolMaterial;
    public static Item.ToolMaterial emeraldToolMaterial;
    public static ItemArmor.ArmorMaterial emeraldArmorMaterial;
    public static ItemArmor.ArmorMaterial crystalArmorMaterial;
    public static Item.ToolMaterial crystalToolMaterial;
    public static Item.ToolMaterial powerToolMaterial;
    public static ItemArmor.ArmorMaterial glowingArmorMaterial;

    public static void register() {
        MaterialRegistry.registerPurpleMaterial();
        MaterialRegistry.registerEmeraldMaterial();
        MaterialRegistry.registerSandstoneMaterials();
        MaterialRegistry.registerGlowingMaterials();
        MaterialRegistry.registerNetherMaterials();
    }

    private static void registerGlowingMaterials() {
        ItemArmor.ArmorMaterial mimicArmor = ItemArmor.ArmorMaterial.IRON;
        glowingArmorMaterial = EnumHelper.addArmorMaterial((String)GLOWING, (String)"cyclicmagic:glowing", (int)15, (int[])new int[]{mimicArmor.func_78044_b(EntityEquipmentSlot.FEET), mimicArmor.func_78044_b(EntityEquipmentSlot.LEGS), mimicArmor.func_78044_b(EntityEquipmentSlot.CHEST), mimicArmor.func_78044_b(EntityEquipmentSlot.HEAD)}, (int)(mimicArmor.func_78045_a() + 1), (SoundEvent)mimicArmor.func_185017_b(), (float)(mimicArmor.func_189416_e() + 1.0f));
        MaterialRegistry.glowingArmorMaterial.repairMaterial = new ItemStack(Blocks.field_150426_aN);
    }

    private static void registerPurpleMaterial() {
        ItemArmor.ArmorMaterial mimicArmor = ItemArmor.ArmorMaterial.DIAMOND;
        crystalArmorMaterial = EnumHelper.addArmorMaterial((String)CRYSTAL, (String)"cyclicmagic:crystal", (int)66, (int[])new int[]{mimicArmor.func_78044_b(EntityEquipmentSlot.FEET) + 1, mimicArmor.func_78044_b(EntityEquipmentSlot.LEGS) + 1, mimicArmor.func_78044_b(EntityEquipmentSlot.CHEST) + 1, mimicArmor.func_78044_b(EntityEquipmentSlot.HEAD) + 2}, (int)(mimicArmor.func_78045_a() / 4), (SoundEvent)mimicArmor.func_185017_b(), (float)(mimicArmor.func_189416_e() + 2.0f));
        MaterialRegistry.crystalArmorMaterial.repairMaterial = new ItemStack(Blocks.field_150343_Z);
        crystalToolMaterial = EnumHelper.addToolMaterial((String)CRYSTAL, (int)Item.ToolMaterial.DIAMOND.func_77996_d(), (int)(Item.ToolMaterial.DIAMOND.func_77997_a() * 2), (float)(Item.ToolMaterial.DIAMOND.func_77998_b() * 2.0f), (float)(Item.ToolMaterial.DIAMOND.func_78000_c() * 2.0f), (int)(Item.ToolMaterial.GOLD.func_77995_e() * 2));
        crystalToolMaterial.setRepairItem(MaterialRegistry.crystalArmorMaterial.repairMaterial);
        powerToolMaterial = EnumHelper.addToolMaterial((String)POWER, (int)Item.ToolMaterial.DIAMOND.func_77996_d(), (int)(Item.ToolMaterial.DIAMOND.func_77997_a() * 3), (float)Item.ToolMaterial.DIAMOND.func_77998_b(), (float)(Item.ToolMaterial.DIAMOND.func_78000_c() * 7.8f), (int)(Item.ToolMaterial.GOLD.func_77995_e() * 2));
        powerToolMaterial.setRepairItem(new ItemStack(Items.field_185157_bK));
    }

    private static void registerEmeraldMaterial() {
        emeraldArmorMaterial = EnumHelper.addArmorMaterial((String)emeraldName, (String)"cyclicmagic:emerald", (int)63, (int[])new int[]{ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.FEET), ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.LEGS), ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.CHEST), ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.HEAD)}, (int)ItemArmor.ArmorMaterial.GOLD.func_78045_a(), (SoundEvent)ItemArmor.ArmorMaterial.DIAMOND.func_185017_b(), (float)(ItemArmor.ArmorMaterial.DIAMOND.func_189416_e() + 1.0f));
        MaterialRegistry.emeraldArmorMaterial.repairMaterial = new ItemStack(Items.field_151166_bC);
        emeraldToolMaterial = EnumHelper.addToolMaterial((String)emeraldName, (int)Item.ToolMaterial.DIAMOND.func_77996_d(), (int)Item.ToolMaterial.DIAMOND.func_77997_a(), (float)Item.ToolMaterial.DIAMOND.func_77998_b(), (float)(Item.ToolMaterial.DIAMOND.func_78000_c() * 1.5f), (int)Item.ToolMaterial.GOLD.func_77995_e());
        emeraldToolMaterial.setRepairItem(MaterialRegistry.emeraldArmorMaterial.repairMaterial);
    }

    private static void registerSandstoneMaterials() {
        sandstoneToolMaterial = EnumHelper.addToolMaterial((String)"sandstone", (int)Item.ToolMaterial.STONE.func_77996_d(), (int)((Item.ToolMaterial.STONE.func_77997_a() + Item.ToolMaterial.WOOD.func_77997_a()) / 2), (float)((Item.ToolMaterial.STONE.func_77998_b() + Item.ToolMaterial.STONE.func_77998_b()) / 2.0f), (float)((Item.ToolMaterial.STONE.func_78000_c() + Item.ToolMaterial.WOOD.func_78000_c()) / 2.0f), (int)Item.ToolMaterial.GOLD.func_77995_e());
        sandstoneToolMaterial.setRepairItem(new ItemStack(Blocks.field_150322_A));
    }

    private static void registerNetherMaterials() {
        netherToolMaterial = EnumHelper.addToolMaterial((String)"nether", (int)Item.ToolMaterial.STONE.func_77996_d(), (int)((Item.ToolMaterial.STONE.func_77997_a() + Item.ToolMaterial.IRON.func_77997_a()) / 2), (float)((Item.ToolMaterial.STONE.func_77998_b() + Item.ToolMaterial.IRON.func_77998_b()) / 2.0f), (float)Item.ToolMaterial.IRON.func_78000_c(), (int)Item.ToolMaterial.GOLD.func_77995_e());
        netherToolMaterial.setRepairItem(new ItemStack(Items.field_151130_bT));
    }
}

