/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.data.OffsetEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderUtil {
    public static final int MAX_LIGHT_X = 0xF000F0;
    public static final int MAX_LIGHT_Y = 0xF000F0;

    @SideOnly(value=Side.CLIENT)
    public static void renderLaser(LaserConfig conf) {
        if (conf.first == null || conf.second == null) {
            return;
        }
        double offsetX = conf.xOffset.getOffset();
        double offsetY = conf.yOffset.getOffset();
        double offsetZ = conf.zOffset.getOffset();
        RenderUtil.renderLaser((double)conf.first.func_177958_n() + offsetX, (double)conf.first.func_177956_o() + offsetY, (double)conf.first.func_177952_p() + offsetZ, (double)conf.second.func_177958_n() + offsetX, (double)conf.second.func_177956_o() + offsetY, (double)conf.second.func_177952_p() + offsetZ, conf.rotationTime, conf.alpha, conf.beamWidth, conf.color, conf.timer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderLaser(double firstX, double firstY, double firstZ, double secondX, double secondY, double secondZ, double rotationTime, float alpha, double beamWidth, float[] color, double timer) {
        Tessellator tessy = Tessellator.func_178181_a();
        BufferBuilder buffer = tessy.func_178180_c();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        float r = color[0];
        float g = color[1];
        float b = color[2];
        Vec3d vecFirst = new Vec3d(firstX, firstY, firstZ);
        Vec3d vecSecond = new Vec3d(secondX, secondY, secondZ);
        Vec3d combinedVec = vecSecond.func_178788_d(vecFirst);
        double rot = rotationTime > 0.0 ? 360.0 * ((double)world.func_82737_E() % rotationTime / rotationTime) : 0.0;
        double pitch = Math.atan2(combinedVec.field_72448_b, Math.sqrt(combinedVec.field_72450_a * combinedVec.field_72450_a + combinedVec.field_72449_c * combinedVec.field_72449_c));
        double yaw = Math.atan2(-combinedVec.field_72449_c, combinedVec.field_72450_a);
        double length = combinedVec.func_72433_c();
        length *= timer / 100.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(firstX - TileEntityRendererDispatcher.field_147554_b), (double)(firstY - TileEntityRendererDispatcher.field_147555_c), (double)(firstZ - TileEntityRendererDispatcher.field_147552_d));
        GlStateManager.func_179114_b((float)((float)(180.0 * yaw / Math.PI)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(180.0 * pitch / Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)rot), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        for (double i = 0.0; i < 4.0; i += 1.0) {
            double width = beamWidth * (i / 4.0);
            buffer.func_181662_b(length, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(length, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(length, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(length, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(length, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(length, width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(length, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, -width, width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(0.0, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
            buffer.func_181662_b(length, -width, -width).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181666_a(r, g, b, alpha).func_181675_d();
        }
        tessy.func_78381_a();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static class LaserConfig {
        public static final int MAX_TIMER = 100;
        BlockPos first;
        BlockPos second;
        double rotationTime;
        float alpha;
        double beamWidth;
        float[] color;
        public int timer = 100;
        public OffsetEnum xOffset = OffsetEnum.CENTER;
        public OffsetEnum yOffset = OffsetEnum.CENTER;
        public OffsetEnum zOffset = OffsetEnum.CENTER;

        public LaserConfig(BlockPos first, BlockPos second, double rotationTime, float alpha, double beamWidth, float[] color) {
            this.first = first;
            this.second = second;
            this.rotationTime = rotationTime;
            this.alpha = alpha;
            this.beamWidth = beamWidth;
            this.color = color;
        }

        public String toString() {
            return this.second + " : " + this.first;
        }
    }
}

