/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import net.minecraft.entity.player.EntityPlayer;

public class UtilExperience {
    public static double getExpTotal(EntityPlayer player) {
        UtilExperience.validateExpPositive(player);
        int level = player.field_71068_ca;
        double totalExp = UtilExperience.getXpForLevel(level);
        double progress = Math.round((float)player.func_71050_bK() * player.field_71106_cc);
        return totalExp += (double)((int)progress);
    }

    public static boolean drainExp(EntityPlayer player, float f) {
        double totalExp = UtilExperience.getExpTotal(player);
        if (totalExp - (double)f < 0.0) {
            return false;
        }
        int result = (int)(totalExp - (double)f);
        UtilExperience.setXp(player, result);
        return true;
    }

    public static int getXpToGainLevel(int level) {
        int nextLevelExp = 0;
        nextLevelExp = level <= 15 ? 2 * level + 7 : (level <= 30 ? 5 * level - 38 : 9 * level - 158);
        return nextLevelExp;
    }

    public static int getXpForLevel(int level) {
        int totalExp = 0;
        totalExp = level <= 15 ? level * level + 6 * level : (level <= 30 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        return totalExp;
    }

    public static int getLevelForXp(int xp) {
        int lev = 0;
        while (UtilExperience.getXpForLevel(lev) < xp) {
            ++lev;
        }
        return lev - 1;
    }

    public static void incrementExp(EntityPlayer player, int xp) {
        UtilExperience.setXp(player, (int)UtilExperience.getExpTotal(player) + xp);
    }

    public static void setXp(EntityPlayer player, int xp) {
        if (xp < 0) {
            xp = 0;
        }
        player.field_71067_cb = xp;
        player.field_71068_ca = UtilExperience.getLevelForXp(xp);
        int next = UtilExperience.getXpForLevel(player.field_71068_ca);
        player.field_71106_cc = player.field_71067_cb == 0 || player.field_71068_ca == 0 ? 0.0f : (float)(player.field_71067_cb - next) / (float)player.func_71050_bK();
        UtilExperience.validateExpPositive(player);
    }

    private static void validateExpPositive(EntityPlayer player) {
        if (player.field_71106_cc < 0.0f) {
            player.field_71106_cc = 0.0f;
        }
        if (player.field_71067_cb < 0) {
            player.field_71067_cb = 0;
        }
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
        }
    }
}

