/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.google.common.collect.UnmodifiableIterator;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.util.UtilReflection;
import com.lothrazar.cyclicmagic.util.UtilString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class UtilHarvester {
    private static final int FORTUNE = 5;
    private static final String AGE = "age";
    static final boolean tryRemoveOneSeed = true;
    private static NonNullList<String> breakGetDrops;
    private static NonNullList<String> breakSilkTouch;
    private static NonNullList<String> blockIgnore;
    private static NonNullList<String> harvestReflectionRegrow;
    private static NonNullList<String> harvestGetDropsDeprecated;
    private static NonNullList<String> breakGetDropsDeprecated;
    private static NonNullList<String> blocksBreakAboveIfMatching;
    private static NonNullList<String> blocksBreakAboveIfMatchingAfterHarvest;
    private static Map<String, Integer> harvestCustomMaxAge;
    private static Map<String, String> modsThatDontUseAge;
    private static Map<String, String> useBooleanProperty;
    private static NonNullList<String> blocksDoNotRemoveSeeds;

    public static void syncConfig(Configuration config) {
        String category = "modpacks";
        String[] deflist = new String[]{"terraqueous:pergola", "minecraft:*_stem", "croparia:stem_*", "rustic:grape_stem"};
        Object[] blacklist = config.getStringList("HarvesterBlacklist", category, deflist, "Crops & bushes that are blocked from harvesting (Garden Scythe and Harvester).  A star is for a wildcard");
        blockIgnore = NonNullList.func_193580_a((Object)"", (Object[])blacklist);
        breakGetDrops = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"minecraft:pumpkin", "croparia:block_plant_*", "croparia:block_cane_*", "extrautils2:redorchid"});
        breakSilkTouch = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"minecraft:melon_block"});
        harvestGetDropsDeprecated = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"rustic:tomato_crop", "rustic:chili_crop", "harvestcraft:pamapple", "harvestcraft:pamalmond", "harvestcraft:pamapricot", "harvestcraft:pamavocado", "harvestcraft:pamcashew", "harvestcraft:pamcherry", "harvestcraft:pamchestnut", "harvestcraft:pamcoconut", "harvestcraft:pamdate", "harvestcraft:pamdragonfruit", "harvestcraft:pamdurian", "harvestcraft:pamfig", "harvestcraft:pamgooseberry", "harvestcraft:pamlemon", "harvestcraft:pamlime", "harvestcraft:pammango", "harvestcraft:pamnutmeg", "harvestcraft:pamolive", "harvestcraft:pamorange", "harvestcraft:pampapaya", "harvestcraft:pampeach", "harvestcraft:pampear", "harvestcraft:pampecan", "harvestcraft:pampeppercorn", "harvestcraft:pampersimmon", "harvestcraft:pampistachio", "harvestcraft:pamplum", "harvestcraft:pampomegranate", "harvestcraft:pamstarfruit", "harvestcraft:pamvanillabean", "harvestcraft:pamwalnut", "harvestcraft:pamspiderweb", "harvestcraft:pamcinnamon", "harvestcraft:pammaple", "harvestcraft:pampaperbark"});
        harvestReflectionRegrow = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"natura:overworld_berrybush_*", "natura:overworld_berrybush_blackberry", "natura:overworld_berrybush_raspberry", "natura:overworld_berrybush_maloberry", "natura:nether_berrybush_duskberry", "natura:nether_berrybush_stingberry", "natura:nether_berrybush_skyberry", "natura:nether_berrybush_blightberry", "natura:nether_berrybush_duskberry"});
        breakGetDropsDeprecated = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"attaineddrops2:bulb"});
        blocksBreakAboveIfMatching = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"immersiveengineering:hemp", "minecraft:reeds", "minecraft:cactus"});
        blocksBreakAboveIfMatchingAfterHarvest = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"simplecorn:corn"});
        blocksDoNotRemoveSeeds = NonNullList.func_193580_a((Object)"", (Object[])new String[]{"plants2:crop_1"});
        useBooleanProperty.put("rustic:grape_leaves", "grapes");
        modsThatDontUseAge.put("rustic:leaves_apple", "apple_age");
        modsThatDontUseAge.put("extrautils2:enderlilly", "growth");
        harvestCustomMaxAge = new HashMap<String, Integer>();
        harvestCustomMaxAge.put("simplecorn:corn", 9);
    }

    private static boolean doNotRemoveSeeds(ResourceLocation blockId) {
        return UtilString.isInList(blocksDoNotRemoveSeeds, blockId);
    }

    private static boolean isHarvestReflectionRegrow(ResourceLocation blockId) {
        return UtilString.isInList(harvestReflectionRegrow, blockId);
    }

    private static boolean isIgnored(ResourceLocation blockId) {
        return UtilString.isInList(blockIgnore, blockId);
    }

    private static boolean isBreakGetDrops(ResourceLocation blockId) {
        return UtilString.isInList(breakGetDrops, blockId);
    }

    private static boolean isBreakGetDropsDeprec(ResourceLocation blockId) {
        return UtilString.isInList(breakGetDropsDeprecated, blockId);
    }

    private static boolean isSimpleSilktouch(ResourceLocation blockId) {
        return UtilString.isInList(breakSilkTouch, blockId);
    }

    private static boolean isHarvestingGetDropsOld(ResourceLocation blockId) {
        return UtilString.isInList(harvestGetDropsDeprecated, blockId);
    }

    private static boolean isBreakAboveIfMatching(ResourceLocation blockId) {
        return UtilString.isInList(blocksBreakAboveIfMatching, blockId);
    }

    private static boolean isBreakAboveIfMatchingAfterHarvest(ResourceLocation blockId) {
        return UtilString.isInList(blocksBreakAboveIfMatchingAfterHarvest, blockId);
    }

    private static boolean doesBlockMatch(World world, Block blockCheck, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().equals(blockCheck);
    }

    private static PropertyBool getBoolProperty(IBlockState blockState, String property) {
        UnmodifiableIterator unmodifiableiterator = blockState.func_177228_b().entrySet().iterator();
        while (unmodifiableiterator.hasNext()) {
            IProperty iproperty = (IProperty)((Map.Entry)unmodifiableiterator.next()).getKey();
            if (!(iproperty instanceof PropertyBool) || !iproperty.func_177701_a().equals(property)) continue;
            return (PropertyBool)iproperty;
        }
        return null;
    }

    private static PropertyInteger getAgeProperty(IBlockState blockState, ResourceLocation blockId) {
        for (Map.Entry entry : blockState.func_177228_b().entrySet()) {
            IProperty iproperty = (IProperty)entry.getKey();
            if (iproperty.func_177701_a() == null) continue;
            if (iproperty.func_177701_a().equals(AGE) && iproperty instanceof PropertyInteger) {
                return (PropertyInteger)iproperty;
            }
            if (!modsThatDontUseAge.containsKey(blockId.toString()) || !iproperty.func_177701_a().equals(modsThatDontUseAge.get(blockId.toString())) || !(iproperty instanceof PropertyInteger)) continue;
            return (PropertyInteger)iproperty;
        }
        return null;
    }

    public static NonNullList<ItemStack> harvestSingle(World world, BlockPos posCurrent) {
        NonNullList drops;
        block24: {
            PropertyInteger propInt;
            String property;
            PropertyBool propFlag;
            drops = NonNullList.func_191196_a();
            if (world.func_175623_d(posCurrent)) {
                return drops;
            }
            IBlockState blockState = world.func_180495_p(posCurrent);
            Block blockCheck = blockState.func_177230_c();
            ResourceLocation blockId = blockCheck.getRegistryName();
            if (UtilHarvester.isIgnored(blockId)) {
                return drops;
            }
            if (UtilHarvester.isBreakGetDrops(blockId)) {
                blockCheck.getDrops(drops, (IBlockAccess)world, posCurrent, blockState, 5);
                world.func_175698_g(posCurrent);
                return drops;
            }
            if (UtilHarvester.isBreakGetDropsDeprec(blockId)) {
                drops.addAll((Collection)blockCheck.getDrops((IBlockAccess)world, posCurrent, blockState, 5));
                world.func_175698_g(posCurrent);
                return drops;
            }
            if (UtilHarvester.isSimpleSilktouch(blockId)) {
                drops.add((Object)new ItemStack(blockCheck));
                world.func_175698_g(posCurrent);
                return drops;
            }
            if (UtilHarvester.isBreakAboveIfMatching(blockId) && UtilHarvester.doesBlockMatch(world, blockCheck, posCurrent.func_177984_a())) {
                blockCheck.getDrops(drops, (IBlockAccess)world, posCurrent, world.func_180495_p(posCurrent.func_177984_a()), 5);
                if (UtilHarvester.doesBlockMatch(world, blockCheck, posCurrent.func_177981_b(2))) {
                    blockCheck.getDrops(drops, (IBlockAccess)world, posCurrent, world.func_180495_p(posCurrent.func_177981_b(2)), 5);
                    world.func_175655_b(posCurrent.func_177981_b(2), false);
                }
                world.func_175655_b(posCurrent.func_177984_a(), false);
                return drops;
            }
            if (useBooleanProperty.containsKey(blockId) && ((Boolean)blockState.func_177229_b((IProperty)(propFlag = UtilHarvester.getBoolProperty(blockState, property = useBooleanProperty.get(blockId))))).booleanValue()) {
                blockCheck.getDrops(drops, (IBlockAccess)world, posCurrent, blockState, 5);
                if (drops.size() == 0) {
                    drops.addAll((Collection)blockCheck.getDrops((IBlockAccess)world, posCurrent, blockState, 5));
                }
                world.func_175656_a(posCurrent, blockState.func_177226_a((IProperty)propFlag, (Comparable)Boolean.valueOf(false)));
            }
            if ((propInt = UtilHarvester.getAgeProperty(blockState, blockId)) != null) {
                boolean removeSeed;
                ItemStack crop;
                Object toDrop;
                int currentAge = (Integer)blockState.func_177229_b((IProperty)propInt);
                int minAge = (Integer)Collections.min(propInt.func_177700_c());
                int maxAge = (Integer)Collections.max(propInt.func_177700_c());
                if (harvestCustomMaxAge.containsKey(blockId.toString())) {
                    maxAge = harvestCustomMaxAge.get(blockId.toString());
                }
                if (minAge == maxAge || currentAge < maxAge) {
                    return drops;
                }
                if (UtilHarvester.isHarvestReflectionRegrow(blockId) && (toDrop = UtilReflection.getFirstPrivate(blockCheck, ItemStack.class)) != null && !(crop = (ItemStack)toDrop).func_190926_b()) {
                    drops.add((Object)crop.func_77946_l());
                    world.func_175656_a(posCurrent, blockState.func_177226_a((IProperty)propInt, (Comparable)Integer.valueOf(maxAge - 1)));
                    return drops;
                }
                if (UtilHarvester.isHarvestingGetDropsOld(blockId)) {
                    drops.addAll((Collection)blockCheck.getDrops((IBlockAccess)world, posCurrent, blockState, 5));
                } else {
                    blockCheck.getDrops(drops, (IBlockAccess)world, posCurrent, blockState.func_177226_a((IProperty)propInt, (Comparable)Integer.valueOf(maxAge)), 5);
                }
                world.func_175656_a(posCurrent, blockState.func_177226_a((IProperty)propInt, (Comparable)Integer.valueOf(minAge)));
                if (UtilHarvester.isBreakAboveIfMatchingAfterHarvest(blockId)) {
                    if (UtilHarvester.doesBlockMatch(world, blockCheck, posCurrent.func_177984_a())) {
                        world.func_175655_b(posCurrent.func_177984_a(), false);
                    }
                    if (UtilHarvester.doesBlockMatch(world, blockCheck, posCurrent.func_177981_b(2))) {
                        world.func_175655_b(posCurrent.func_177981_b(2), false);
                    }
                    if (world.func_175623_d(posCurrent.func_177977_b()) && world.func_175623_d(posCurrent.func_177979_c(2))) {
                        world.func_175655_b(posCurrent, false);
                    }
                }
                boolean bl = removeSeed = drops.size() > 1 && !UtilHarvester.doNotRemoveSeeds(blockId);
                if (removeSeed) {
                    Item seedItem = blockCheck.func_180660_a(blockCheck.func_176223_P(), world.field_73012_v, 0);
                    if (seedItem == null) {
                        seedItem = Item.func_150898_a((Block)blockCheck);
                    }
                    try {
                        if (seedItem == null) break block24;
                        Iterator iterator = drops.iterator();
                        while (iterator.hasNext()) {
                            ItemStack drop = (ItemStack)iterator.next();
                            if (drop.func_77973_b() != seedItem) continue;
                            iterator.remove();
                            break;
                        }
                    }
                    catch (Exception e) {
                        ModCyclic.logger.error("Crop could not be harvested by Cyclic, contact both mod authors    " + blockId, e);
                    }
                }
            }
        }
        return drops;
    }

    static {
        modsThatDontUseAge = new HashMap<String, String>();
        useBooleanProperty = new HashMap<String, String>();
    }
}

