/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens;

import com.setycz.chickens.block.BlockHenhouse;
import com.setycz.chickens.block.TileEntityHenhouse;
import com.setycz.chickens.client.gui.TileEntityGuiHandler;
import com.setycz.chickens.common.CommonProxy;
import com.setycz.chickens.common.LogUtil;
import com.setycz.chickens.config.ConfigHandler;
import com.setycz.chickens.entity.EntityChickensChicken;
import com.setycz.chickens.entity.EntityColoredEgg;
import com.setycz.chickens.handler.ChickenNetherPopulateHandler;
import com.setycz.chickens.handler.ChickenTeachHandler;
import com.setycz.chickens.handler.ChickensTab;
import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.item.ItemAnalyzer;
import com.setycz.chickens.item.ItemColoredEgg;
import com.setycz.chickens.item.ItemLiquidEgg;
import com.setycz.chickens.item.ItemSpawnEgg;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import com.setycz.chickens.registry.LiquidEggRegistry;
import com.setycz.chickens.registry.LiquidEggRegistryItem;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="chickens", name="Chickens", version="6.1.0", acceptedMinecraftVersions="[1.12, 1.12.2]", dependencies="required-after:forge@[14.21.1.2387,);")
@Mod.EventBusSubscriber
public class ChickensMod {
    public static final String MODID = "chickens";
    public static final String VERSION = "6.1.0";
    public static final String CHICKEN = "chickenschicken";
    public static final String NAME = "Chickens";
    public static final LogUtil log = new LogUtil("chickens");
    @Mod.Instance(value="chickens")
    public static ChickensMod instance;
    public static boolean isDev;
    public static final CreativeTabs chickensTab;
    public static final Item spawnEgg;
    public static final Item coloredEgg;
    public static final Item liquidEgg;
    public static final Item analyzer;
    public static final Block henhouse;
    public static final Block henhouse_acacia;
    public static final Block henhouse_birch;
    public static final Block henhouse_dark_oak;
    public static final Block henhouse_jungle;
    public static final Block henhouse_spruce;
    public static final TileEntityGuiHandler guiHandler;
    @SidedProxy(clientSide="com.setycz.chickens.client.ClientProxy", serverSide="com.setycz.chickens.common.CommonProxy")
    public static CommonProxy proxy;
    private static IForgeRegistry<Item> itemRegistry;
    private static IForgeRegistry<Block> blockRegistry;

    public boolean getAlwaysShowStats() {
        return ConfigHandler.alwaysShowStats;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, CHICKEN), EntityChickensChicken.class, (String)CHICKEN, (int)ConfigHandler.chickenEntityId, (Object)this, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "thown_egg"), EntityColoredEgg.class, (String)CHICKEN, (int)2, (Object)this, (int)64, (int)3, (boolean)true);
        GameRegistry.registerTileEntity(TileEntityHenhouse.class, (String)"henhouse");
        proxy.preInit();
        this.registerLiquidEggs();
        ConfigHandler.LoadConfigs(this.generateDefaultChickens());
        log.info(String.format("Enabled chickens: %s", this.getChickenNames(ChickensRegistry.getItems())));
        log.info(String.format("Disabled chickens: %s", this.getChickenNames(ChickensRegistry.getDisabledItems())));
        for (SpawnType spawnType : SpawnType.values()) {
            log.info(String.format("[%s] biome type will spawn %s", new Object[]{spawnType, this.getChickenNames(ChickensRegistry.getPossibleChickensToSpawn(spawnType))}));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.dumpChickens(ChickensRegistry.getItems());
    }

    @SubscribeEvent
    public static void itemRegistry(RegistryEvent.Register<Item> event) {
        itemRegistry = event.getRegistry();
        itemRegistry.register((IForgeRegistryEntry)coloredEgg);
        itemRegistry.register((IForgeRegistryEntry)spawnEgg);
        itemRegistry.register((IForgeRegistryEntry)liquidEgg);
        itemRegistry.register((IForgeRegistryEntry)analyzer);
        ChickensMod.registerItemForBlock(henhouse);
        ChickensMod.registerItemForBlock(henhouse_acacia);
        ChickensMod.registerItemForBlock(henhouse_birch);
        ChickensMod.registerItemForBlock(henhouse_dark_oak);
        ChickensMod.registerItemForBlock(henhouse_jungle);
        ChickensMod.registerItemForBlock(henhouse_spruce);
        OreDictionary.registerOre((String)"egg", (Item)coloredEgg);
        OreDictionary.registerOre((String)"listAllegg", (Item)coloredEgg);
    }

    @SubscribeEvent
    public static void blockRegistry(RegistryEvent.Register<Block> event) {
        blockRegistry = event.getRegistry();
        blockRegistry.register((IForgeRegistryEntry)henhouse);
        blockRegistry.register((IForgeRegistryEntry)henhouse_acacia);
        blockRegistry.register((IForgeRegistryEntry)henhouse_birch);
        blockRegistry.register((IForgeRegistryEntry)henhouse_dark_oak);
        blockRegistry.register((IForgeRegistryEntry)henhouse_jungle);
        blockRegistry.register((IForgeRegistryEntry)henhouse_spruce);
    }

    public static void registerBlock(Block block) {
        blockRegistry.register(block.setRegistryName(block.func_149739_a().substring(5)));
    }

    public static void registerItemForBlock(Block block) {
        itemRegistry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    private List<String> getChickenNames(Collection<ChickensRegistryItem> chickens) {
        ArrayList<String> result = new ArrayList<String>();
        for (ChickensRegistryItem chicken : chickens) {
            result.add(chicken.getEntityName());
        }
        return result;
    }

    private String getAllAvailableSpawnTypes() {
        String spawnTypes = "";
        String[] spawnTypeNames = SpawnType.names();
        for (int spawnTypeIndex = 0; spawnTypeIndex < spawnTypeNames.length; ++spawnTypeIndex) {
            if (spawnTypeIndex > 0) {
                spawnTypes = spawnTypes + ", ";
            }
            spawnTypes = spawnTypes + spawnTypeNames[spawnTypeIndex];
        }
        return spawnTypes;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChickenTeachHandler());
        List<Biome> biomesForSpawning = this.getAllSpawnBiomes();
        if (biomesForSpawning.size() > 0) {
            EntityRegistry.addSpawn(EntityChickensChicken.class, (int)ConfigHandler.spawnProbability, (int)ConfigHandler.minBroodSize, (int)ConfigHandler.maxBroodSize, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomesForSpawning.toArray(new Biome[biomesForSpawning.size()]));
            if (biomesForSpawning.contains(Biomes.field_76778_j)) {
                MinecraftForge.TERRAIN_GEN_BUS.register((Object)new ChickenNetherPopulateHandler(ConfigHandler.netherSpawnChanceMultiplier));
            }
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"GetTheOneProbe", (String)"com.setycz.chickens.top.TheOneProbePlugin$GetTheOneProbe");
        }
    }

    private boolean requiresVisitingNether(ChickensRegistryItem chicken) {
        return chicken.getTier() == 1 ? chicken.getSpawnType() == SpawnType.HELL : chicken.isBreedable() && (this.requiresVisitingNether(chicken.getParent1()) || this.requiresVisitingNether(chicken.getParent2()));
    }

    private void dumpChickens(Collection<ChickensRegistryItem> items) {
        try {
            FileWriter file = new FileWriter("logs/chickens/chickens.gml");
            file.write("graph [\n");
            file.write("\tdirected 1\n");
            for (ChickensRegistryItem item : items) {
                file.write("\tnode [\n");
                file.write("\t\tid " + item.getRegistryName().toString() + "\n");
                file.write("\t\tlabel \"" + item.getEntityName() + "\"\n");
                if (this.requiresVisitingNether(item)) {
                    file.write("\t\tgraphics [\n");
                    file.write("\t\t\tfill \"#FF6600\"\n");
                    file.write("\t\t]\n");
                }
                file.write("\t]\n");
            }
            for (ChickensRegistryItem item : items) {
                if (item.getParent1() != null) {
                    file.write("\tedge [\n");
                    file.write("\t\tsource " + item.getParent1().getRegistryName().toString() + "\n");
                    file.write("\t\ttarget " + item.getRegistryName().toString() + "\n");
                    file.write("\t]\n");
                }
                if (item.getParent2() == null) continue;
                file.write("\tedge [\n");
                file.write("\t\tsource " + item.getParent2().getRegistryName().toString() + "\n");
                file.write("\t\ttarget " + item.getRegistryName().toString() + "\n");
                file.write("\t]\n");
            }
            file.write("]\n");
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void registerChicken(ChickensRegistryItem chicken, IForgeRegistry<IRecipe> event) {
        if (chicken.isDye() && chicken.isEnabled()) {
            ShapelessOreRecipe recipe = new ShapelessOreRecipe(new ResourceLocation("egg"), new ItemStack(coloredEgg, 1, chicken.getDyeMetadata()), new Object[]{new ItemStack(Items.field_151110_aK), new ItemStack(Items.field_151100_aR, 1, chicken.getDyeMetadata())});
            event.register(recipe.setRegistryName(chicken.getRegistryName() + "_egg"));
        }
    }

    private static void registerHenhouse(Block henhouse, BlockPlanks.EnumType type, IForgeRegistry<IRecipe> event) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ResourceLocation("henhouse"), new ItemStack(Item.func_150898_a((Block)henhouse)), new Object[]{"PPP", "PHP", "PPP", Character.valueOf('P'), type == BlockPlanks.EnumType.OAK ? "plankWood" : new ItemStack(Blocks.field_150344_f, 1, type.func_176839_a()), Character.valueOf('H'), Blocks.field_150407_cf});
        event.register(recipe.setRegistryName(MODID, henhouse.func_149739_a()));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            ChickensMod.registerChicken(chicken, (IForgeRegistry<IRecipe>)event.getRegistry());
        }
        for (LiquidEggRegistryItem liquidEgg : LiquidEggRegistry.getAll()) {
            proxy.registerLiquidEgg(liquidEgg);
        }
        ChickensMod.registerHenhouse(henhouse_acacia, BlockPlanks.EnumType.ACACIA, (IForgeRegistry<IRecipe>)event.getRegistry());
        ChickensMod.registerHenhouse(henhouse_birch, BlockPlanks.EnumType.BIRCH, (IForgeRegistry<IRecipe>)event.getRegistry());
        ChickensMod.registerHenhouse(henhouse_dark_oak, BlockPlanks.EnumType.DARK_OAK, (IForgeRegistry<IRecipe>)event.getRegistry());
        ChickensMod.registerHenhouse(henhouse_jungle, BlockPlanks.EnumType.JUNGLE, (IForgeRegistry<IRecipe>)event.getRegistry());
        ChickensMod.registerHenhouse(henhouse_spruce, BlockPlanks.EnumType.SPRUCE, (IForgeRegistry<IRecipe>)event.getRegistry());
        ChickensMod.registerHenhouse(henhouse, BlockPlanks.EnumType.OAK, (IForgeRegistry<IRecipe>)event.getRegistry());
        event.getRegistry().register(new ShapelessOreRecipe(new ResourceLocation("analyzer"), new ItemStack(analyzer, 1), new Object[]{new ItemStack(Items.field_151110_aK), new ItemStack(Items.field_151111_aL)}).setRegistryName(MODID, "analyzer"));
    }

    private List<Biome> getAllSpawnBiomes() {
        ArrayList<Biome> allPossibleBiomes = new ArrayList<Biome>();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.VOID) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) continue;
            allPossibleBiomes.add(biome);
        }
        ArrayList<Biome> biomesForSpawning = new ArrayList<Biome>();
        for (Biome biome : allPossibleBiomes) {
            if (!ChickensRegistry.isAnyIn(ChickensRegistry.getSpawnType(biome))) continue;
            biomesForSpawning.add(biome);
        }
        return biomesForSpawning;
    }

    private void registerLiquidEggs() {
        LiquidEggRegistry.register(new LiquidEggRegistryItem(0, (Block)Blocks.field_150358_i, 255, FluidRegistry.WATER));
        LiquidEggRegistry.register(new LiquidEggRegistryItem(1, (Block)Blocks.field_150356_k, 0xFF0000, FluidRegistry.LAVA));
    }

    ChickensRegistryItem createDyeChicken(EnumDyeColor color, String name) {
        return new ChickensRegistryItem(new ResourceLocation(MODID, name), name, new ResourceLocation(MODID, "textures/entity/" + Strings.join((String[])name.split("(?=[A-Z])"), (String)"_").toLowerCase() + ".png"), new ItemStack(Items.field_151100_aR, 1, color.func_176767_b()), 0xF2F2F2, this.getRGB(color)).setSpawnType(SpawnType.NONE);
    }

    private int getRGB(EnumDyeColor color) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return color.func_193350_e();
        }
        return 0;
    }

    private List<ChickensRegistryItem> generateDefaultChickens() {
        ArrayList<ChickensRegistryItem> chickens = new ArrayList<ChickensRegistryItem>();
        chickens.add(new ChickensRegistryItem(ChickensRegistry.SMART_CHICKEN_ID, "SmartChicken", new ResourceLocation(MODID, "textures/entity/smart_chicken.png"), new ItemStack(Items.field_151110_aK), 0xFFFFFF, 0xFFFF00).setSpawnType(SpawnType.NONE));
        ChickensRegistryItem whiteChicken = this.createDyeChicken(EnumDyeColor.WHITE, "WhiteChicken").setDropItem(new ItemStack(Items.field_151103_aS)).setSpawnType(SpawnType.NORMAL);
        chickens.add(whiteChicken);
        ChickensRegistryItem yellowChicken = this.createDyeChicken(EnumDyeColor.YELLOW, "YellowChicken");
        chickens.add(yellowChicken);
        ChickensRegistryItem blueChicken = this.createDyeChicken(EnumDyeColor.BLUE, "BlueChicken");
        chickens.add(blueChicken);
        ChickensRegistryItem greenChicken = this.createDyeChicken(EnumDyeColor.GREEN, "GreenChicken");
        chickens.add(greenChicken);
        ChickensRegistryItem redChicken = this.createDyeChicken(EnumDyeColor.RED, "RedChicken");
        chickens.add(redChicken);
        ChickensRegistryItem blackChicken = this.createDyeChicken(EnumDyeColor.BLACK, "BlackChicken");
        chickens.add(blackChicken);
        ChickensRegistryItem pinkChicken = this.createDyeChicken(EnumDyeColor.PINK, "PinkChicken").setParentsNew(redChicken, whiteChicken);
        chickens.add(pinkChicken);
        ChickensRegistryItem purpleChicken = this.createDyeChicken(EnumDyeColor.PURPLE, "PurpleChicken").setParentsNew(blueChicken, redChicken);
        chickens.add(purpleChicken);
        chickens.add(this.createDyeChicken(EnumDyeColor.ORANGE, "OrangeChicken").setParentsNew(redChicken, yellowChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.LIGHT_BLUE, "LightBlueChicken").setParentsNew(whiteChicken, blueChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.LIME, "LimeChicken").setParentsNew(greenChicken, whiteChicken));
        ChickensRegistryItem grayChicken = this.createDyeChicken(EnumDyeColor.GRAY, "GrayChicken").setParentsNew(blackChicken, whiteChicken);
        chickens.add(grayChicken);
        chickens.add(this.createDyeChicken(EnumDyeColor.CYAN, "CyanChicken").setParentsNew(blueChicken, greenChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.SILVER, "SilverDyeChicken").setParentsNew(grayChicken, whiteChicken));
        chickens.add(this.createDyeChicken(EnumDyeColor.MAGENTA, "MagentaChicken").setParentsNew(purpleChicken, pinkChicken));
        ChickensRegistryItem flintChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "FlintChicken"), "FlintChicken", new ResourceLocation(MODID, "textures/entity/flint_chicken.png"), new ItemStack(Items.field_151145_ak), 7039815, 10724213);
        chickens.add(flintChicken);
        ChickensRegistryItem quartzChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "QuartzChicken"), "QuartzChicken", new ResourceLocation(MODID, "textures/entity/quartz_chicken.png"), new ItemStack(Items.field_151128_bU), 0x4D0000, 0x1A0000).setSpawnType(SpawnType.HELL);
        chickens.add(quartzChicken);
        ChickensRegistryItem logChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "LogChicken"), "LogChicken", new ResourceLocation(MODID, "textures/entity/log_chicken.png"), new ItemStack(Blocks.field_150364_r), 9995373, 5407576);
        chickens.add(logChicken);
        ChickensRegistryItem sandChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "SandChicken"), "SandChicken", new ResourceLocation(MODID, "textures/entity/sand_chicken.png"), new ItemStack((Block)Blocks.field_150354_m), 15525297, 10985580);
        chickens.add(sandChicken);
        ChickensRegistryItem stringChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "StringChicken"), "StringChicken", new ResourceLocation(MODID, "textures/entity/string_chicken.png"), new ItemStack(Items.field_151007_F), 3348992, 0x800000, blackChicken, logChicken).setDropItem(new ItemStack(Items.field_151070_bp));
        chickens.add(stringChicken);
        ChickensRegistryItem glowstoneChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "GlowstoneChicken"), "GlowstoneChicken", new ResourceLocation(MODID, "textures/entity/glowstone_chicken.png"), new ItemStack(Items.field_151114_aO), 0xFFFF66, 0xFFFF00, quartzChicken, yellowChicken);
        chickens.add(glowstoneChicken);
        ChickensRegistryItem gunpowderChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "GunpowderChicken"), "GunpowderChicken", new ResourceLocation(MODID, "textures/entity/gunpowder_chicken.png"), new ItemStack(Items.field_151016_H), 0x999999, 0x404040, sandChicken, flintChicken);
        chickens.add(gunpowderChicken);
        ChickensRegistryItem redstoneChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "RedstoneChicken"), "RedstoneChicken", new ResourceLocation(MODID, "textures/entity/redstone_chicken.png"), new ItemStack(Items.field_151137_ax), 0xE60000, 0x800000, redChicken, sandChicken);
        chickens.add(redstoneChicken);
        ChickensRegistryItem glassChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "GlassChicken"), "GlassChicken", new ResourceLocation(MODID, "textures/entity/glass_chicken.png"), new ItemStack(Blocks.field_150359_w), 0xFFFFFF, 0xEEEEFF, quartzChicken, redstoneChicken);
        chickens.add(glassChicken);
        ChickensRegistryItem ironChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "IronChicken"), "IronChicken", new ResourceLocation(MODID, "textures/entity/iron_chicken.png"), new ItemStack(Items.field_151042_j), 0xFFFFCC, 0xFFCCCC, flintChicken, whiteChicken);
        chickens.add(ironChicken);
        ChickensRegistryItem coalChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "CoalChicken"), "CoalChicken", new ResourceLocation(MODID, "textures/entity/coal_chicken.png"), new ItemStack(Items.field_151044_h), 0x262626, 0, flintChicken, logChicken);
        chickens.add(coalChicken);
        ChickensRegistryItem brownChicken = this.createDyeChicken(EnumDyeColor.BROWN, "BrownChicken").setParentsNew(redChicken, greenChicken);
        chickens.add(brownChicken);
        ChickensRegistryItem goldChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "GoldChicken"), "GoldChicken", new ResourceLocation(MODID, "textures/entity/gold_chicken.png"), new ItemStack(Items.field_151074_bl), 0xCCCC00, 0xFFFF80, ironChicken, yellowChicken);
        chickens.add(goldChicken);
        ChickensRegistryItem snowballChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "SnowballChicken"), "SnowballChicken", new ResourceLocation(MODID, "textures/entity/snowball_chicken.png"), new ItemStack(Items.field_151126_ay), 0x33BBFF, 35020, blueChicken, logChicken).setSpawnType(SpawnType.SNOW);
        chickens.add(snowballChicken);
        ChickensRegistryItem waterChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "WaterChicken"), "WaterChicken", new ResourceLocation(MODID, "textures/entity/water_chicken.png"), new ItemStack(liquidEgg, 1, 0), 153, 0x8080FF, gunpowderChicken, snowballChicken);
        chickens.add(waterChicken);
        ChickensRegistryItem lavaChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "LavaChicken"), "LavaChicken", new ResourceLocation(MODID, "textures/entity/lava_chicken.png"), new ItemStack(liquidEgg, 1, 1), 0xCC3300, 0xFFFF00, coalChicken, quartzChicken).setSpawnType(SpawnType.HELL);
        chickens.add(lavaChicken);
        ChickensRegistryItem clayChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "ClayChicken"), "ClayChicken", new ResourceLocation(MODID, "textures/entity/clay_chicken.png"), new ItemStack(Items.field_151119_aD), 0xCCCCCC, 0xBFBFBF, snowballChicken, sandChicken);
        chickens.add(clayChicken);
        ChickensRegistryItem leatherChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "LeatherChicken"), "LeatherChicken", new ResourceLocation(MODID, "textures/entity/leather_chicken.png"), new ItemStack(Items.field_151116_aA), 10985580, 0x919191, stringChicken, brownChicken);
        chickens.add(leatherChicken);
        ChickensRegistryItem netherwartChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "NetherwartChicken"), "NetherwartChicken", new ResourceLocation(MODID, "textures/entity/netherwart_chicken.png"), new ItemStack(Items.field_151075_bm), 0x800000, 3348992, brownChicken, glowstoneChicken);
        chickens.add(netherwartChicken);
        ChickensRegistryItem diamondChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "DiamondChicken"), "DiamondChicken", new ResourceLocation(MODID, "textures/entity/diamond_chicken.png"), new ItemStack(Items.field_151045_i), 0x99CCFF, 15135487, glassChicken, goldChicken);
        chickens.add(diamondChicken);
        ChickensRegistryItem blazeChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "BlazeChicken"), "BlazeChicken", new ResourceLocation(MODID, "textures/entity/blaze_chicken.png"), new ItemStack(Items.field_151072_bj), 0xFFFF66, 0xFF3300, goldChicken, lavaChicken);
        chickens.add(blazeChicken);
        ChickensRegistryItem slimeChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "SlimeChicken"), "SlimeChicken", new ResourceLocation(MODID, "textures/entity/slime_chicken.png"), new ItemStack(Items.field_151123_aH), 39219, 0x99FFBB, clayChicken, greenChicken);
        chickens.add(slimeChicken);
        ChickensRegistryItem enderChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "EnderChicken"), "EnderChicken", new ResourceLocation(MODID, "textures/entity/ender_chicken.png"), new ItemStack(Items.field_151079_bi), 6656, 6707, diamondChicken, netherwartChicken);
        chickens.add(enderChicken);
        ChickensRegistryItem ghastChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "GhastChicken"), "GhastChicken", new ResourceLocation(MODID, "textures/entity/ghast_chicken.png"), new ItemStack(Items.field_151073_bk), 0xFFFFCC, 0xFFFFFF, whiteChicken, blazeChicken);
        chickens.add(ghastChicken);
        ChickensRegistryItem emeraldChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "EmeraldChicken"), "EmeraldChicken", new ResourceLocation(MODID, "textures/entity/emerald_chicken.png"), new ItemStack(Items.field_151166_bC), 52224, 13056, diamondChicken, greenChicken);
        chickens.add(emeraldChicken);
        ChickensRegistryItem magmaChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "MagmaChicken"), "MagmaChicken", new ResourceLocation(MODID, "textures/entity/magma_chicken.png"), new ItemStack(Items.field_151064_bs), 1705216, 0, slimeChicken, blazeChicken);
        chickens.add(magmaChicken);
        ChickensRegistryItem pShardChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "pShardChicken"), "pShardChicken", new ResourceLocation(MODID, "textures/entity/pshard_chicken.png"), new ItemStack(Items.field_179562_cC), 4423790, 10472380, waterChicken, blueChicken);
        chickens.add(pShardChicken);
        ChickensRegistryItem pCrystalChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "pCrystalChicken"), "pCrystalChicken", new ResourceLocation(MODID, "textures/entity/pcrystal_chicken.png"), new ItemStack(Items.field_179563_cD, 1, 0), 5138785, 14674396, waterChicken, emeraldChicken);
        chickens.add(pCrystalChicken);
        ChickensRegistryItem obsidianChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "obsidianChicken"), "obsidianChicken", new ResourceLocation(MODID, "textures/entity/obsidian_chicken.png"), new ItemStack(Blocks.field_150343_Z, 1, 0), 526350, 4602464, waterChicken, lavaChicken);
        chickens.add(obsidianChicken);
        ChickensRegistryItem soulSandChicken = new ChickensRegistryItem(new ResourceLocation(MODID, "soulSandChicken"), "soulSandChicken", new ResourceLocation(MODID, "textures/entity/soulsand_chicken.png"), new ItemStack(Blocks.field_150425_aM, 1, 0), 4534565, 13971208).setSpawnType(SpawnType.HELL);
        chickens.add(soulSandChicken);
        return chickens;
    }

    public static String getItemName(Item item) {
        return item.func_77658_a().substring(5);
    }

    public static String getBlockName(Block block) {
        return block.func_149739_a().substring(5);
    }

    static {
        isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        chickensTab = new ChickensTab();
        spawnEgg = (Item)new ItemSpawnEgg().func_77655_b("spawn_egg").func_77637_a(chickensTab).setRegistryName(MODID, "spawn_egg");
        coloredEgg = (Item)new ItemColoredEgg().func_77655_b("colored_egg").func_77637_a(chickensTab).setRegistryName(MODID, "colored_egg");
        liquidEgg = (Item)new ItemLiquidEgg().func_77655_b("liquid_egg").func_77637_a(chickensTab).setRegistryName(MODID, "liquid_egg");
        analyzer = (Item)new ItemAnalyzer().func_77655_b("analyzer").func_77637_a(chickensTab).setRegistryName(MODID, "analyzer");
        henhouse = (Block)new BlockHenhouse().func_149663_c("henhouse").func_149647_a(chickensTab).setRegistryName(MODID, "henhouse");
        henhouse_acacia = (Block)new BlockHenhouse().func_149663_c("henhouse_acacia").func_149647_a(chickensTab).setRegistryName(MODID, "henhouse_acacia");
        henhouse_birch = (Block)new BlockHenhouse().func_149663_c("henhouse_birch").func_149647_a(chickensTab).setRegistryName(MODID, "henhouse_birch");
        henhouse_dark_oak = (Block)new BlockHenhouse().func_149663_c("henhouse_dark_oak").func_149647_a(chickensTab).setRegistryName(MODID, "henhouse_dark_oak");
        henhouse_jungle = (Block)new BlockHenhouse().func_149663_c("henhouse_jungle").func_149647_a(chickensTab).setRegistryName(MODID, "henhouse_jungle");
        henhouse_spruce = (Block)new BlockHenhouse().func_149663_c("henhouse_spruce").func_149647_a(chickensTab).setRegistryName(MODID, "henhouse_spruce");
        guiHandler = new TileEntityGuiHandler();
        itemRegistry = null;
        blockRegistry = null;
    }
}

