/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.jei.henhousing;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class HenhousingRecipeCategory
implements IRecipeCategory {
    public static final String UID = "chickens.Henhousing";
    private final String title = Translator.translateToLocal((String)"gui.henhousing");
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic icon;

    public HenhousingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("chickens", "textures/gui/henhouse.png");
        this.background = guiHelper.createDrawable(location, 18, 12, 72, 62);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 195, 0, 12, 57);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.TOP, true);
        ResourceLocation iconLocation = new ResourceLocation("chickens", "textures/gui/henhousing_icon.png");
        this.icon = guiHelper.createDrawable(iconLocation, 0, 0, 16, 16);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 57, 2);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int inputSlot = 0;
        guiItemStacks.init(inputSlot, true, 6, 5);
        guiItemStacks.set(ingredients);
        int outputSlot = 1;
        guiItemStacks.init(outputSlot, false, 6, 42);
        guiItemStacks.set(ingredients);
    }

    public String getModName() {
        return "Chickens";
    }
}

