/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol.api;

import com.bartz24.voidislandcontrol.api.IslandGen;
import com.bartz24.voidislandcontrol.api.IslandPos;
import com.bartz24.voidislandcontrol.api.VICTeleporter;
import com.bartz24.voidislandcontrol.config.ConfigOptions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandGive;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class IslandManager {
    public static ArrayList<IslandGen> IslandGenerations = new ArrayList();
    public static ArrayList<IslandPos> CurrentIslandsList = new ArrayList();
    public static ArrayList<String> spawnedPlayers = new ArrayList();
    public static boolean worldOneChunk = false;
    public static boolean worldLoaded = false;
    public static int initialIslandDistance = ConfigOptions.islandSettings.islandDistance;

    public static void registerIsland(IslandGen gen) {
        IslandGenerations.add(gen);
    }

    public static List<String> getIslandGenTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (IslandGen g : IslandGenerations) {
            types.add(g.Identifier);
        }
        return types;
    }

    public static int getIndexOfIslandType(String type) {
        for (int i = 0; i < IslandGenerations.size(); ++i) {
            if (!IslandManager.IslandGenerations.get((int)i).Identifier.equals(type)) continue;
            return i;
        }
        return -1;
    }

    public static IslandPos getNextIsland() {
        int size = (int)Math.floor(Math.sqrt(CurrentIslandsList.size()));
        if (size % 2 == 0 && size > 0) {
            --size;
        }
        size = (size + 1) / 2;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (IslandManager.hasPosition(x, z)) continue;
                return new IslandPos(x, z, new UUID[0]);
            }
        }
        return null;
    }

    public static IslandPos getPlayerIsland(UUID playerUUID) {
        for (IslandPos pos : CurrentIslandsList) {
            if (!pos.getPlayerUUIDs().contains(playerUUID.toString())) continue;
            return pos;
        }
        return null;
    }

    public static IslandPos getIslandAtPos(int x, int y) {
        for (IslandPos pos : CurrentIslandsList) {
            if (pos.getX() != x || pos.getY() != y) continue;
            return pos;
        }
        return null;
    }

    public static List<String> getPlayerNames(World world) {
        ArrayList<String> names = new ArrayList<String>();
        for (IslandPos pos : CurrentIslandsList) {
            for (String s : pos.getPlayerUUIDs()) {
                names.add(world.func_152378_a(UUID.fromString(s)).func_70005_c_());
            }
        }
        return names;
    }

    public static boolean hasPosition(int x, int y) {
        for (IslandPos pos : CurrentIslandsList) {
            if (pos.getX() != x || pos.getY() != y) continue;
            return true;
        }
        return false;
    }

    public static boolean playerHasIsland(UUID playerUUID) {
        for (IslandPos pos : CurrentIslandsList) {
            if (!pos.getPlayerUUIDs().contains(playerUUID.toString())) continue;
            return true;
        }
        return false;
    }

    public static void addPlayer(UUID playerUUID, IslandPos posAdd) {
        for (IslandPos pos : CurrentIslandsList) {
            if (pos.getX() != posAdd.getX() || pos.getY() != posAdd.getY()) continue;
            pos.addNewPlayer(playerUUID);
            return;
        }
    }

    public static void removePlayer(UUID playerUUID) {
        IslandPos pos = IslandManager.getPlayerIsland(playerUUID);
        pos.removePlayer(playerUUID);
    }

    public static boolean hasPlayerSpawned(UUID playerUUID) {
        return spawnedPlayers.contains(playerUUID.toString());
    }

    public static void setStartingInv(EntityPlayerMP player) {
        if (ConfigOptions.islandSettings.resetInventory) {
            player.field_71071_by.func_174888_l();
            try {
                for (int i = 0; i < Math.max(ConfigOptions.islandSettings.startingItems.length, 36); ++i) {
                    String s = ConfigOptions.islandSettings.startingItems[i];
                    if (Strings.isNullOrEmpty((String)s) || !s.contains(":") || !s.contains("*")) continue;
                    String trimmed = s.replaceAll(" ", "");
                    String itemName = trimmed.split(":")[0] + ":" + trimmed.split(":")[1];
                    int meta = Integer.parseInt(trimmed.split(":")[2].split("\\*")[0]);
                    int amt = Integer.parseInt(trimmed.split(":")[2].split("\\*")[1]);
                    Item item = CommandGive.func_147179_f((ICommandSender)player, (String)itemName);
                    ItemStack stack = new ItemStack(item, amt, meta);
                    player.field_71071_by.func_70299_a(i, stack);
                }
            }
            catch (Exception e) {
                player.field_71071_by.func_174888_l();
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error getting starting inventory.\n" + e.toString()));
            }
        }
    }

    public static void tpPlayerToPos(EntityPlayer player, BlockPos pos, IslandPos islandPos) {
        pos = IslandManager.getSpawnOffset(islandPos) != null ? pos.func_177971_a((Vec3i)IslandManager.getSpawnOffset(islandPos)) : pos.func_177971_a((Vec3i)IslandManager.getSpawnOffset(CurrentIslandsList.get(0)));
        if (ConfigOptions.islandSettings.forceSpawn && !player.func_130014_f_().func_175623_d(pos) && !player.func_130014_f_().func_175623_d(pos.func_177984_a())) {
            pos = player.func_130014_f_().func_175672_r(pos.func_177981_b(2));
            player.func_145747_a((ITextComponent)new TextComponentString("Failed to spawn. Sent to top block of platform spawn."));
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, ConfigOptions.islandSettings.buffTimer, 20, false, false));
        player.func_70066_B();
        player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, ConfigOptions.islandSettings.buffTimer, 20, false, false));
        player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, ConfigOptions.islandSettings.buffTimer, 20, false, false));
        if (player.field_71093_bK != ConfigOptions.worldGenSettings.baseDimension && player instanceof EntityPlayerMP) {
            player.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, ConfigOptions.worldGenSettings.baseDimension, (Teleporter)new VICTeleporter(player.func_184102_h().func_71218_a(ConfigOptions.worldGenSettings.baseDimension), (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 2.6f, (float)pos.func_177952_p() + 0.5f));
        } else {
            player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.6, (double)pos.func_177952_p() + 0.5);
        }
    }

    public static BlockPos getSpawnOffset(IslandPos islandPos) {
        if (islandPos == null) {
            return null;
        }
        if (islandPos.getX() == 0 && islandPos.getY() == 0) {
            if (ConfigOptions.islandSettings.islandMainSpawnType.equals("bedrock") || ConfigOptions.islandSettings.islandMainSpawnType.equals("random")) {
                return new BlockPos(0, 7, 0);
            }
            if (IslandManager.getIndexOfIslandType(ConfigOptions.islandSettings.islandMainSpawnType) != -1) {
                return IslandManager.IslandGenerations.get((int)IslandManager.getIndexOfIslandType((String)ConfigOptions.islandSettings.islandMainSpawnType)).spawnOffset;
            }
            return new BlockPos(0, 0, 0);
        }
        return IslandManager.IslandGenerations.get((int)IslandManager.getIndexOfIslandType((String)islandPos.getType())).spawnOffset;
    }

    public static void tpPlayerToPosSpawn(EntityPlayer player, BlockPos pos, IslandPos islandPos) {
        IslandManager.tpPlayerToPos(player, pos, islandPos);
        pos = IslandManager.getSpawnOffset(islandPos) != null ? pos.func_177971_a((Vec3i)IslandManager.getSpawnOffset(islandPos)) : pos.func_177971_a((Vec3i)IslandManager.getSpawnOffset(CurrentIslandsList.get(0)));
        player.func_180473_a(pos, true);
    }

    public static void setVisitLoc(EntityPlayer player, int x, int y) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_74768_a("VICVisitX", x);
        persist.func_74768_a("VICVisitY", y);
    }

    public static void removeVisitLoc(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_82580_o("VICVisitX");
        persist.func_82580_o("VICVisitY");
    }

    public static boolean hasVisitLoc(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        return persist.func_74764_b("VICVisitX") && persist.func_74764_b("VICVisitY");
    }

    public static IslandPos getVisitLoc(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        return IslandManager.hasVisitLoc(player) ? new IslandPos(persist.func_74762_e("VICVisitX"), persist.func_74762_e("VICVisitY"), new UUID[0]) : null;
    }

    public static void setJoinLoc(EntityPlayer player, int x, int y) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_74768_a("VICJoinX", x);
        persist.func_74768_a("VICJoinY", y);
        persist.func_74768_a("VICJoinTime", 400);
    }

    public static void setLeaveConfirm(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_74768_a("VICLeaveTime", 400);
    }

    public static void removeJoinLoc(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_82580_o("VICJoinX");
        persist.func_82580_o("VICJoinY");
        persist.func_82580_o("VICJoinTime");
    }

    public static void removeLeaveConfirm(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_82580_o("VICLeaveTime");
    }

    public static boolean hasJoinLoc(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        return persist.func_74764_b("VICJoinX") && persist.func_74764_b("VICJoinY");
    }

    public static boolean hasLeaveConfirm(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        return persist.func_74764_b("VICLeaveTime");
    }

    public static IslandPos getJoinLoc(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        return IslandManager.hasJoinLoc(player) ? new IslandPos(persist.func_74762_e("VICJoinX"), persist.func_74762_e("VICJoinY"), new UUID[0]) : null;
    }

    public static int getJoinTime(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        return IslandManager.hasJoinLoc(player) ? persist.func_74762_e("VICJoinTime") : -1;
    }

    public static int getLeaveTime(EntityPlayer player) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        return IslandManager.hasLeaveConfirm(player) ? persist.func_74762_e("VICLeaveTime") : -1;
    }

    public static void setJoinTime(EntityPlayer player, int val) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_74768_a("VICJoinTime", val);
    }

    public static void setLeaveTime(EntityPlayer player, int val) {
        NBTTagCompound persist = IslandManager.setPlayerData(player);
        persist.func_74768_a("VICLeaveTime", val);
    }

    public static NBTTagCompound setPlayerData(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        if (!data.func_74764_b("PlayerPersisted")) {
            data.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        return data.func_74775_l("PlayerPersisted");
    }
}

