/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol.config;

import java.util.Arrays;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="voidislandcontrol")
public class ConfigOptions {
    @Config.Comment(value={"Config Settings for the world generation"})
    public static WorldGenSettings worldGenSettings = new WorldGenSettings();
    @Config.Comment(value={"Config Settings for the world generation"})
    public static IslandSettings islandSettings = new IslandSettings();
    @Config.Comment(value={"Config Settings for the world generation"})
    public static CommandSettings commandSettings = new CommandSettings();
    @Config.Comment(value={"Config Settings for other stuff"})
    public static OtherSettings otherSettings = new OtherSettings();

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("voidislandcontrol")) {
            ConfigManager.sync((String)"voidislandcontrol", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static String[] emptyFilledArray(int length) {
        Object[] array = new String[length];
        Arrays.fill(array, "");
        return array;
    }

    public static class OtherSettings {
        @Config.Comment(value={"Hide the toasts when at spawn"})
        public boolean hideToasts = false;
    }

    public static class CommandSettings {
        @Config.Comment(value={"Name of the main command"})
        public String commandName = "island";
        @Config.Comment(value={"Allow the one chunk command to be used"})
        public boolean oneChunkCommandAllowed = false;
        @Config.Comment(value={"Offset position for command block from the center block above the bedrock"})
        public CommandBlockPos commandBlockPos = new CommandBlockPos();
        @Config.Comment(value={"Type of command block to spawn"})
        public CommandBlockType commandBlockType = CommandBlockType.NONE;
        @Config.Comment(value={"Run always or require redstone"})
        public boolean commandBlockAuto = false;
        @Config.Comment(value={"Allows the visit command to be used"})
        public boolean allowVisitCommand = true;
        @Config.Comment(value={"Allows the home command to be used"})
        public boolean allowHomeCommand = true;
        @Config.Comment(value={"Command for the command block to run"})
        public String commandBlockCommand = "";
        @Config.Comment(value={"Command Block direction to face"})
        public EnumFacing commandBlockDirection = EnumFacing.UP;
        @Config.Comment(value={"Commands to run when the world loads"})
        public String[] worldLoadCommands = ConfigOptions.emptyFilledArray(0);

        public static enum CommandBlockType {
            NONE,
            IMPULSE,
            REPEATING,
            CHAIN;

        }

        public class CommandBlockPos {
            @Config.Comment(value={"The x coordinate (Offset from the center block above the bedrock)"})
            public int x = 0;
            @Config.Comment(value={"The y coordinate (Offset from the center block above the bedrock)"})
            public int y = 0;
            @Config.Comment(value={"The z coordinate (Offset from the center block above the bedrock)"})
            public int z = 0;
        }
    }

    public static class IslandSettings {
        @Config.Comment(value={"This is for the island at 0,0! Valids are random, bedrock, sand, snow, wood, grass, gog, or others added by addons/custom islands"})
        public String islandMainSpawnType = "bedrock";
        @Config.Comment(value={"Valids are random, sand, snow, wood, grass, gog, or others added by addons/custom islands"})
        public String islandSpawnType = "random";
        @Config.Comment(value={"Distance between islands"})
        public int islandDistance = 1000;
        @Config.Comment(value={"Range where players from other islands are not allowed and the range furthest players of an island can go. Affects spawn too (Max of islandDistance/2)"})
        public int protectionBuildRange = 500;
        @Config.Comment(value={"Protect spawn from building, destroying, interactions with blocks and machines, etc. Those in creative are ignored"})
        public boolean spawnProtection = true;
        @Config.Comment(value={"Disables effect of protectionBuildRange"})
        public boolean islandProtection = true;
        @Config.Comment(value={"Width of islands"})
        public int islandSize = 3;
        @Config.Comment(value={"Spawn a chest on the island"})
        public boolean spawnChest = false;
        @Config.Comment(value={"Start the world in one chunk mode"})
        public boolean oneChunk = false;
        @Config.Comment(value={"Starting items given to new players. Use the /startingInv command in game"})
        public String[] startingItems = ConfigOptions.emptyFilledArray(36);
        @Config.Comment(value={"Biome used for islands"})
        public int islandBiomeID = -1;
        @Config.Comment(value={"Biome range (width) used for islands"})
        public int islandBiomeRange = 0;
        @Config.Comment(value={"Y Level to spawn islands at (Set to 2 above where you want the ground block)"})
        public int islandYLevel = 88;
        @Config.Comment(value={"Type of block to spawn under islands"})
        public BottomBlockType bottomBlockType = BottomBlockType.BEDROCK;
        @Config.Comment(value={"Automatically give new players islands"})
        public boolean autoCreate = false;
        @Config.Comment(value={"ONLY TAKES EFFECT ON DEDICATED SERVERS-Automatically give new players islands"})
        public boolean autoCreateServersOnly = false;
        @Config.Comment(value={"Allow players to create or reset their islands"})
        public boolean allowIslandCreation = true;
        @Config.Comment(value={"Reset players inventory with the starting inventory"})
        public boolean resetInventory = true;
        @Config.Comment(value={"Custom islands using the structure block data. Files are to be placed in the voidislandcontrolstructures config folder. The names in this list should be the same as the structure names. These names are the ids for the island type as well"})
        public String[] customIslands = ConfigOptions.emptyFilledArray(0);
        @Config.Comment(value={"Forces players to spawn at the spawn position. By default, the player will be teleported to a safe spot above it if spawning fails. This config disables that"})
        public boolean forceSpawn = false;
        @Config.Comment(value={"Sets how long the buffs are given when spawning on an island in ticks (I think)"})
        public int buffTimer = 1200;
        @Config.Comment(value={"Settings for the grass island"})
        public GrassIslandSettings grassSettings = new GrassIslandSettings();
        @Config.Comment(value={"Settings for the sand island"})
        public SandIslandSettings sandSettings = new SandIslandSettings();
        @Config.Comment(value={"Settings for the snow island"})
        public SnowIslandSettings snowSettings = new SnowIslandSettings();
        @Config.Comment(value={"Settings for the wood island"})
        public WoodIslandSettings woodSettings = new WoodIslandSettings();
        @Config.Comment(value={"Settings for the Garden of Glass island (Requires Botania and Garden of Glass!)"})
        public GoGSettings gogSettings = new GoGSettings();

        public static enum BottomBlockType {
            BEDROCK,
            SECONDARYBLOCK;

        }

        public class GoGSettings {
            @Config.Comment(value={"Allow garden of glass island to be used"})
            public boolean enableGoGIsland = true;
        }

        public static enum WoodBlockType {
            OAK,
            SPRUCE,
            BIRCH,
            JUNGLE,
            ACACIA,
            DARKOAK;

        }

        public class WoodIslandSettings {
            @Config.Comment(value={"Allow wood island to be used"})
            public boolean enableWoodIsland = true;
            @Config.Comment(value={"Spawn water"})
            public boolean spawnWater = true;
            @Config.Comment(value={"Spawn string"})
            public boolean spawnString = true;
            @Config.Comment(value={"Type of wood"})
            public WoodBlockType woodBlockType = WoodBlockType.DARKOAK;
        }

        public class SnowIslandSettings {
            @Config.Comment(value={"Allow snow island to be used"})
            public boolean enableSnowIsland = true;
            @Config.Comment(value={"Spawn pumpkins"})
            public boolean spawnPumpkins = true;
            @Config.Comment(value={"Spawn an igloo"})
            public boolean spawnIgloo = false;
        }

        public static enum SandBlockType {
            NORMAL,
            RED;

        }

        public class SandIslandSettings {
            @Config.Comment(value={"Allow sand island to be used"})
            public boolean enableSandIsland = true;
            @Config.Comment(value={"Spawn a cactus"})
            public boolean spawnCactus = true;
            @Config.Comment(value={"Type of sand"})
            public SandBlockType sandBlockType = SandBlockType.RED;
        }

        public static enum GrassBlockType {
            GRASS,
            DIRT,
            COARSEDIRT;

        }

        public class GrassIslandSettings {
            @Config.Comment(value={"Allow grass island to be used"})
            public boolean enableGrassIsland = true;
            @Config.Comment(value={"Spawn a tree"})
            public boolean spawnTree = true;
            @Config.Comment(value={"Type of grass/dirt"})
            public GrassBlockType grassBlockType = GrassBlockType.GRASS;
        }
    }

    public static class WorldGenSettings {
        @Config.Comment(value={"Nether dimension will be a void world"})
        public boolean netherVoid = true;
        @Config.Comment(value={"Nether dimension will generate structures (Only takes effect if nether is a void world)"})
        public boolean netherVoidStructures = true;
        @Config.Comment(value={"End dimension will be a void world"})
        public boolean endVoid = true;
        @Config.Comment(value={"End dimension will generate structures (Only takes effect if end is a void world)"})
        public boolean endVoidStructures = true;
        @Config.Comment(value={"Overworld generation type"})
        public WorldGenType worldGenType = WorldGenType.VOID;
        @Config.Comment(value={"VOID-NOT USED, OVERWORLD-NOT USED, SUPERFLAT-Use the string as used for normal flat worlds, WORLDTYPE-world type to be used (set like server level-types), CUSTOMIZED-NOT USED"})
        public String worldGenSpecialParameters = "";
        @Config.Comment(value={"Biome used for entire world"})
        public int worldBiomeID = -1;
        @Config.Comment(value={"Level where clouds appear"})
        public int cloudLevel = 32;
        @Config.Comment(value={"Level where the horizon appears"})
        public int horizonLevel = 40;
        @Config.Comment(value={"Dimension for island management to occur in"})
        public int baseDimension = 0;

        public static enum WorldGenType {
            VOID,
            OVERWORLD,
            SUPERFLAT,
            WORLDTYPE,
            CUSTOMIZED;

        }
    }
}

