/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.api.client;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.AEConfig;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import p455w0rd.ae2wtlib.api.client.StackSizeRenderer;

public class FluidStackSizeRenderer
extends StackSizeRenderer<IAEFluidStack> {
    private static final FluidStackSizeRenderer INSTANCE = new FluidStackSizeRenderer();
    private static final String[] NUMBER_FORMATS = new String[]{"#.000", "#.00", "#.0", "#"};

    public static final FluidStackSizeRenderer getInstance() {
        return INSTANCE;
    }

    @Override
    public void renderStackSize(FontRenderer fontRenderer, IAEFluidStack aeStack, int xPos, int yPos) {
        if (aeStack != null) {
            float scaleFactor = AEConfig.instance().useTerminalUseLargeFont() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            int offset = AEConfig.instance().useTerminalUseLargeFont() ? 0 : -1;
            boolean unicodeFlag = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(false);
            if (aeStack.getStackSize() > 0L) {
                String stackSize = this.getToBeRenderedStackSize(aeStack.getStackSize());
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                int X = (int)(((float)xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
                int Y = (int)(((float)yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_175063_a(stackSize, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            fontRenderer.func_78264_a(unicodeFlag);
        }
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (originalSize < 100000L && AEConfig.instance().useTerminalUseLargeFont()) {
            return this.getSlimRenderedStacksize(originalSize);
        }
        if (originalSize < 1000000L && !AEConfig.instance().useTerminalUseLargeFont()) {
            return this.getWideRenderedStacksize(originalSize);
        }
        if (AEConfig.instance().useTerminalUseLargeFont()) {
            return this.getConverter().toSlimReadableForm(originalSize / 1000L);
        }
        return this.getConverter().toWideReadableForm(originalSize / 1000L);
    }

    private String getSlimRenderedStacksize(long originalSize) {
        int log = 1 + (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private String getWideRenderedStacksize(long originalSize) {
        int log = (int)Math.floor(Math.log10(originalSize)) / 2;
        return this.getRenderedFluidStackSize(originalSize, log);
    }

    private String getRenderedFluidStackSize(long originalSize, int log) {
        int index = Math.max(0, Math.min(3, log));
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(NUMBER_FORMATS[index]);
        format.setDecimalFormatSymbols(symbols);
        format.setRoundingMode(RoundingMode.DOWN);
        return format.format((float)originalSize / 1000.0f);
    }
}

