/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.ItemOptional;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.crafting.Ingredient;

public class Grid
implements IRecipeConfigElement {
    private Optional<String> size = this.empty();
    private final NNList<ItemOptional> items = new NNList();
    private transient int width;
    private transient int height;
    private transient boolean valid;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            if (this.size.isPresent() && !"3x3".equals(this.size.get())) {
                if (this.size.get().length() != 3 || this.size.get().charAt(1) != 'x') {
                    throw new InvalidRecipeConfigException("Invalid size attribute '" + this.size.get());
                }
                String widthString = this.size.get().substring(0, 1);
                String heightString = this.size.get().substring(2, 3);
                try {
                    this.width = Integer.parseInt(widthString);
                    this.height = Integer.parseInt(heightString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidRecipeConfigException("Invalid size attribute '" + this.size.get());
                }
                if (this.width < 1 || this.width > 3 || this.height < 1 || this.height > 3) {
                    throw new InvalidRecipeConfigException("Invalid size attribute '" + this.size.get());
                }
            } else {
                this.height = 3;
                this.width = 3;
            }
            if (this.items.isEmpty()) {
                throw new InvalidRecipeConfigException("No items");
            }
            if (this.items.size() < this.width * this.height) {
                throw new InvalidRecipeConfigException("Not enough items (required=" + this.width * this.height + ", provided=" + this.items.size() + ")");
            }
            if (this.items.size() > this.width * this.height) {
                throw new InvalidRecipeConfigException("Too many items (required=" + this.width * this.height + ", provided=" + this.items.size() + ")");
            }
            this.valid = true;
            for (ItemOptional item : this.items) {
                this.valid = this.valid && item.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <grid>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        boolean hasAtLeastOneItem = false;
        for (ItemOptional item : this.items) {
            item.enforceValidity();
            hasAtLeastOneItem = hasAtLeastOneItem || item.getRecipeObject() != null;
        }
        if (!hasAtLeastOneItem) {
            throw new InvalidRecipeConfigException("Rejecting crafting recipe without any items, only empty spaces in <grid>");
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public NNList<Ingredient> getIngredients() {
        NNList result = new NNList();
        for (ItemOptional item : this.items) {
            Ingredient ingredient = item.getRecipeObject();
            if (ingredient == null) {
                result.add((Object)Ingredient.field_193370_a);
                continue;
            }
            result.add((Object)ingredient);
        }
        return result;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("size".equals(name)) {
            this.size = this.ofString(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            this.items.add(factory.read(new ItemOptional().setAllowDelaying(false), startElement));
            return true;
        }
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

