/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.recipes;

import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IItemFilterUpgrade;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CopyFilterRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    @Nonnull
    private ItemStack output = ItemStack.field_190927_a;

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        ItemStack filterInput = Prep.getEmpty();
        int sourceSlot = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack checkStack = inv.func_70301_a(i);
            if (!Prep.isValid(checkStack)) continue;
            if (checkStack.func_77973_b() instanceof IItemFilterUpgrade) {
                if (!FilterRegistry.isFilterSet(checkStack)) continue;
                if (sourceSlot >= 0) {
                    return false;
                }
                filterInput = checkStack;
                sourceSlot = i;
                continue;
            }
            return false;
        }
        if (sourceSlot < 0) {
            return false;
        }
        int blankCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack checkStack = inv.func_70301_a(i);
            if (i == sourceSlot || !Prep.isValid(checkStack)) continue;
            if (!this.isSameType(filterInput, checkStack)) {
                return false;
            }
            ++blankCount;
        }
        if (blankCount == 0) {
            return false;
        }
        this.output = filterInput.func_77946_l();
        this.output.func_190920_e(blankCount + 1);
        return true;
    }

    private boolean isSameType(@Nonnull ItemStack template, @Nonnull ItemStack candidate) {
        return template.func_77973_b() == candidate.func_77973_b() && template.func_77952_i() == candidate.func_77952_i();
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        return this.output.func_77946_l();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }
}

