/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.storage;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class StorageCap
extends ItemStackHandler {
    @Nonnull
    protected final NbtValue NBT;
    @Nonnull
    protected final EntityEquipmentSlot equipmentSlot;
    @Nonnull
    protected final ItemStack owner;
    protected final EntityPlayer player;
    protected Function<ItemStack, Boolean> validator = x -> true;

    public StorageCap(@Nonnull NbtValue NBT2, @Nonnull EntityEquipmentSlot equipmentSlot, int size, @Nonnull EntityPlayer player) {
        super(size);
        this.NBT = NBT2;
        this.equipmentSlot = equipmentSlot;
        this.player = size > 0 ? player : null;
        this.owner = size > 0 ? player.func_184582_a(equipmentSlot) : Prep.getEmpty();
        size = Prep.isValid(this.owner) ? size : 0;
        this.deserializeNBT(NBT2.getTag(this.owner));
        if (size != super.getSlots()) {
            if (size < super.getSlots()) {
                Iterator itr = this.stacks.iterator();
                while (itr.hasNext()) {
                    ItemStack next = (ItemStack)itr.next();
                    if (next != null && !Prep.isInvalid(next)) continue;
                    itr.remove();
                }
            }
            while (size < super.getSlots()) {
                player.func_71019_a((ItemStack)this.stacks.remove(this.stacks.size() - 1), true);
            }
            while (size > super.getSlots()) {
                this.stacks.add((Object)Prep.getEmpty());
            }
            this.onContentsChanged(0);
        }
    }

    public StorageCap(@Nonnull EntityEquipmentSlot equipmentSlot, int size) {
        super(size);
        this.NBT = NbtValue.INVENTORY;
        this.equipmentSlot = equipmentSlot;
        this.owner = Prep.getEmpty();
        this.player = null;
    }

    public boolean isStillConnectedToPlayer() {
        return this.player == null || Prep.isInvalid(this.owner) || this.owner == this.player.func_184582_a(this.equipmentSlot);
    }

    @Nonnull
    public EntityEquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack == this.owner || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) != null || this.isLarge(stack) || Prep.isValid(stack) && !this.validator.apply(stack).booleanValue()) {
            if (this.player != null) {
                if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) != null) {
                    this.player.func_146105_b((ITextComponent)Lang.GUI_ARMOR_INVENTORY_CONTAINER.toChatServer(), true);
                } else if (this.isLarge(stack)) {
                    this.player.func_146105_b((ITextComponent)Lang.GUI_ARMOR_INVENTORY_BIG.toChatServer(), true);
                }
            }
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    private boolean isLarge(@Nonnull ItemStack stack) {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)stack);
        boolean result = buffer.writerIndex() > 500;
        buffer.release();
        return result;
    }

    protected void onContentsChanged(int slot) {
        if (Prep.isValid(this.owner)) {
            this.NBT.setTag(this.owner, this.serializeNBT());
        }
    }

    public void setSize(int size) {
        this.stacks = new NNList(size, (Object)Prep.getEmpty());
    }

    public StorageCap setValidator(@Nonnull Function<ItemStack, Boolean> validator) {
        this.validator = validator;
        return this;
    }
}

