/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power;

import com.enderio.core.common.inventory.InventorySlot;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.power.IEnergyTank;
import crazypants.enderio.base.power.NullEnergyTank;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.IEnergyStorage;

@Storable
public class EnergyTank
extends NullEnergyTank
implements IEnergyTank {
    @Nonnull
    private ICapacitorData capacitorData = DefaultCapacitorData.NONE;
    @Nonnull
    private final ICapacitorKey maxEnergyRecieved;
    @Nonnull
    private final ICapacitorKey maxEnergyStored;
    @Nonnull
    private final ICapacitorKey maxEnergyUsed;
    private ICapacitorKey energyLoss = null;
    @Nullable
    TileEntity owner = null;
    @Store
    private int storedEnergy;

    @Override
    public IEnergyStorage get(@Nullable EnumFacing side) {
        if (side != null && this.owner instanceof AbstractMachineEntity) {
            return new Side(side);
        }
        return this;
    }

    public EnergyTank(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        this(null, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    public EnergyTank(TileEntity owner, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        this.owner = owner;
        this.maxEnergyRecieved = maxEnergyRecieved;
        this.maxEnergyStored = maxEnergyStored;
        this.maxEnergyUsed = maxEnergyUsed;
    }

    public EnergyTank(TileEntity owner) {
        this(owner, CapacitorKey.LEGACY_ENERGY_INTAKE, CapacitorKey.LEGACY_ENERGY_BUFFER, CapacitorKey.LEGACY_ENERGY_USE);
    }

    @Override
    public void setEnergyLoss(ICapacitorKey energyLoss) {
        this.energyLoss = energyLoss;
    }

    @Override
    public boolean updateCapacitorFromSlot(@Nonnull InventorySlot slot) {
        ICapacitorData newData;
        int oldValue = this.maxEnergyStored.get(this.capacitorData);
        this.capacitorData = Prep.isInvalid(slot.getStackInSlot(0)) ? DefaultCapacitorData.NONE : ((newData = CapacitorHelper.getCapacitorDataFromItemStack(slot.getStackInSlot(0))) == null ? DefaultCapacitorData.NONE : newData);
        if (oldValue != this.maxEnergyStored.get(this.capacitorData) || this.getEnergyStored() > oldValue) {
            this.setEnergyStored(this.getEnergyStored());
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCapacitor() {
        return this.capacitorData != DefaultCapacitorData.NONE;
    }

    private void onChange() {
        if (this.owner != null) {
            this.owner.func_70296_d();
        }
    }

    public int getMaxEnergyRecieved() {
        return this.maxEnergyRecieved.get(this.capacitorData);
    }

    public boolean canUseEnergy() {
        return this.canUseEnergy(this.maxEnergyUsed);
    }

    @Override
    public boolean canUseEnergy(@Nonnull ICapacitorKey key) {
        int toUse = this.getMaxUsage(key);
        return toUse <= this.getEnergyStored();
    }

    @Override
    public boolean useEnergy() {
        return this.useEnergy(this.maxEnergyUsed);
    }

    @Override
    public boolean useEnergy(@Nonnull ICapacitorKey key) {
        int toUse = this.getMaxUsage(key);
        if (toUse <= this.getEnergyStored()) {
            this.setEnergyStored(this.getEnergyStored() - toUse);
            return true;
        }
        return false;
    }

    @Override
    public int getMaxUsage() {
        return this.getMaxUsage(this.maxEnergyUsed);
    }

    @Override
    public int getMaxUsage(@Nonnull ICapacitorKey key) {
        return key.get(this.capacitorData);
    }

    @Override
    public void loseEnergy() {
        if (this.storedEnergy > 0 && this.energyLoss != null) {
            this.setEnergyStored(this.getEnergyStored() - this.energyLoss.get(this.capacitorData));
        }
    }

    @Override
    public void setEnergyStored(int stored) {
        int newEnergy = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
        if (newEnergy != this.storedEnergy) {
            this.storedEnergy = newEnergy;
            this.onChange();
        }
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int result = Math.max(0, Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxEnergyRecieved(), maxReceive)));
        if (result > 0 && !simulate) {
            this.setEnergyStored(this.getEnergyStored() + result);
        }
        return result;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxEnergyStored.get(this.capacitorData);
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canReceive() {
        return this.maxEnergyRecieved != CapacitorKey.NO_POWER;
    }

    @Override
    @Nonnull
    public ICapacitorData getCapacitorData() {
        return this.capacitorData;
    }

    @Override
    public boolean isFull() {
        return this.getEnergyStored() >= this.getMaxEnergyStored();
    }

    private class Side
    implements IEnergyStorage {
        @Nonnull
        private final EnumFacing side;

        public Side(EnumFacing side) {
            this.side = side;
        }

        private boolean isEnabled() {
            if (EnergyTank.this.owner != null) {
                switch (((AbstractMachineEntity)EnergyTank.this.owner).getIoMode(this.side)) {
                    case DISABLED: 
                    case PUSH: {
                        return false;
                    }
                    case NONE: 
                    case PULL: 
                    case PUSH_PULL: {
                        return true;
                    }
                }
            }
            throw new RuntimeException("The fat lady has sung.");
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.isEnabled()) {
                return EnergyTank.this.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.isEnabled()) {
                return EnergyTank.this.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            if (this.isEnabled()) {
                return EnergyTank.this.getEnergyStored();
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            if (this.isEnabled()) {
                return EnergyTank.this.getMaxEnergyStored();
            }
            return 0;
        }

        public boolean canExtract() {
            if (this.isEnabled()) {
                return EnergyTank.this.canExtract();
            }
            return false;
        }

        public boolean canReceive() {
            if (this.isEnabled()) {
                return EnergyTank.this.canReceive();
            }
            return false;
        }
    }
}

