/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows;

import ftblag.fluidcows.base.BaseItem;
import ftblag.fluidcows.block.accelerator.AcceleratorBlock;
import ftblag.fluidcows.block.feeder.FeederBlock;
import ftblag.fluidcows.block.sorter.SorterBlock;
import ftblag.fluidcows.block.stall.StallBlock;
import ftblag.fluidcows.block.stall.StallTileEntity;
import ftblag.fluidcows.client.GuiHandler;
import ftblag.fluidcows.client.RenderFluidCow;
import ftblag.fluidcows.client.RenderStallTile;
import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.gson.FCConfig;
import ftblag.fluidcows.integration.EIOIntegration;
import ftblag.fluidcows.integration.HwylaIntegration;
import ftblag.fluidcows.integration.MekanismIntegration;
import ftblag.fluidcows.integration.NotEnoughWandsIntegration;
import ftblag.fluidcows.integration.ProjectEIntegration;
import ftblag.fluidcows.integration.RandomThingsIntegration;
import ftblag.fluidcows.integration.TOPIntegration;
import ftblag.fluidcows.integration.TorcherinoIntegration;
import ftblag.fluidcows.item.ItemCowDisplayer;
import ftblag.fluidcows.item.ItemCowHalter;
import ftblag.fluidcows.network.NetworkHandler;
import ftblag.fluidcows.util.FCUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="fluidcows", name="Fluid Cows", version="1.1.21", dependencies="after:*;required-after:forge@[14.23.5.2768,);", acceptedMinecraftVersions="[1.12.2]")
public class FluidCows {
    public static final String MODID = "fluidcows";
    public static final String NAME = "Fluid Cows";
    public static final String VERSION = "1.1.21";
    private static Logger log;
    public static StallBlock stall;
    public static ItemCowHalter halter;
    public static ItemCowDisplayer displayer;
    public static AcceleratorBlock accelerator;
    public static FeederBlock feeder;
    public static SorterBlock sorter;
    public static Item ranger;
    @Mod.Instance
    public static FluidCows instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        log = e.getModLog();
        FCConfig.setFile(new File(e.getModConfigurationDirectory(), "fluidcows_v2.json"));
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TOPIntegration.reg();
        }
        if (Loader.isModLoaded((String)"waila")) {
            HwylaIntegration.reg();
        }
        NetworkHandler.reg();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "fluidcow"), EntityFluidCow.class, (String)"fluidcows.fluidcow", (int)0, (Object)this, (int)64, (int)1, (boolean)true);
        Block[] blockArray = new Block[4];
        stall = new StallBlock();
        blockArray[0] = stall;
        accelerator = new AcceleratorBlock();
        blockArray[1] = accelerator;
        feeder = new FeederBlock();
        blockArray[2] = feeder;
        sorter = new SorterBlock();
        blockArray[3] = sorter;
        ForgeRegistries.BLOCKS.registerAll((IForgeRegistryEntry[])blockArray);
        Item[] itemArray = new Item[7];
        itemArray[0] = (Item)new ItemBlock((Block)stall).setRegistryName(stall.getRegistryName());
        halter = new ItemCowHalter();
        itemArray[1] = halter;
        displayer = new ItemCowDisplayer();
        itemArray[2] = displayer;
        itemArray[3] = (Item)new ItemBlock((Block)accelerator).setRegistryName(accelerator.getRegistryName());
        itemArray[4] = (Item)new ItemBlock((Block)feeder).setRegistryName(feeder.getRegistryName());
        itemArray[5] = (Item)new ItemBlock((Block)sorter).setRegistryName(sorter.getRegistryName());
        itemArray[6] = ranger = new BaseItem("ranger").func_77625_d(7);
        ForgeRegistries.ITEMS.registerAll((IForgeRegistryEntry[])itemArray);
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(MODID, "stall"), null, (ItemStack)new ItemStack((Block)stall), (Object[])new Object[]{"B B", "BHB", "GGG", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('H'), Blocks.field_150407_cf, Character.valueOf('G'), new ItemStack(Blocks.field_192443_dR, 1, 7)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(MODID, "halter"), null, (ItemStack)new ItemStack((Item)halter), (Object[])new Object[]{"  L", " S ", "S  ", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('S'), Items.field_151055_y});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(MODID, "accelerator"), null, (ItemStack)new ItemStack((Block)accelerator), (Object[])new Object[]{"IHI", "RHL", "III", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('H'), Blocks.field_150407_cf, Character.valueOf('R'), Blocks.field_150451_bX, Character.valueOf('L'), Items.field_151116_aA});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(MODID, "feeder"), null, (ItemStack)new ItemStack((Block)feeder), (Object[])new Object[]{"GIG", "ILI", "GIG", Character.valueOf('G'), new ItemStack(Blocks.field_192443_dR, 1, 6), Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), Items.field_151042_j});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(MODID, "sorter"), null, (ItemStack)new ItemStack((Block)sorter), (Object[])new Object[]{"GIG", "ILI", "GWG", Character.valueOf('G'), new ItemStack(Blocks.field_192443_dR, 1, 6), Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('W'), Items.field_151015_O});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(MODID, "ranger"), null, (ItemStack)new ItemStack(ranger), (Object[])new Object[]{"W W", "HHH", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L), Character.valueOf('H'), Items.field_151015_O});
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.preInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void preInit() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFluidCow.class, (IRenderFactory)new RenderFluidCow.Factory());
        ClientRegistry.bindTileEntitySpecialRenderer(StallTileEntity.class, (TileEntitySpecialRenderer)new RenderStallTile());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)stall), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)stall).getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)halter, (int)0, (ModelResourceLocation)new ModelResourceLocation(halter.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)displayer, (int)0, (ModelResourceLocation)new ModelResourceLocation(displayer.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)accelerator), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)accelerator).getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)feeder), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)feeder).getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)sorter), (int)0, (ModelResourceLocation)new ModelResourceLocation(Item.func_150898_a((Block)sorter).getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ranger, (int)0, (ModelResourceLocation)new ModelResourceLocation(ranger.getRegistryName(), "inventory"));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        FCConfig.load();
        if (FCConfig.FLUIDS.size() > 0) {
            List<String> blackList = Arrays.asList(FCConfig.spawnBlackListBiomes);
            ArrayList<Biome> biomes = new ArrayList<Biome>(ForgeRegistries.BIOMES.getValues());
            if (!blackList.isEmpty()) {
                biomes.removeIf(i -> blackList.contains(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)i).toString()));
            }
            if (FCConfig.spawnWeight > 0) {
                EntityRegistry.addSpawn(EntityFluidCow.class, (int)FCConfig.spawnWeight, (int)FCConfig.spawnMin, (int)FCConfig.spawnMax, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes.toArray(new Biome[biomes.size()]));
            }
        }
        FluidCows.info("This is info! Support " + FCUtils.getBucketFluids().size() + " fluids. Can spawn " + FCConfig.FLUIDS.size() + " cows.");
        if (Loader.isModLoaded((String)"projecte") && FCConfig.projecteTickRemove) {
            ProjectEIntegration.reg();
        }
        if (Loader.isModLoaded((String)"notenoughwands") && FCConfig.notenoughwandsTickRemove) {
            NotEnoughWandsIntegration.reg();
        }
        if (Loader.isModLoaded((String)"torcherino") && FCConfig.torcherinoTickRemove) {
            TorcherinoIntegration.reg();
        }
        if (Loader.isModLoaded((String)"mekanism")) {
            MekanismIntegration.reg();
        }
        if (Loader.isModLoaded((String)"randomthings") && FCConfig.randomthingsTickRemove) {
            RandomThingsIntegration.reg();
        }
        if (Loader.isModLoaded((String)"enderio")) {
            EIOIntegration.reg();
        }
    }

    public static void info(String msg) {
        log.info("[FluidCows] " + msg);
    }

    public static void warn(String msg) {
        log.warn("[FluidCows] " + msg);
    }

    public static void debug(String msg) {
        log.info("[FluidCows] DEBUG: " + msg);
    }

    static {
        FluidRegistry.enableUniversalBucket();
        FluidRegistry.addBucketForFluid((Fluid)FluidRegistry.WATER);
        FluidRegistry.addBucketForFluid((Fluid)FluidRegistry.LAVA);
    }
}

