/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.block.accelerator;

import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.gson.FCConfig;
import ftblag.fluidcows.util.storage.IFluidHelper;
import ftblag.fluidcows.util.storage.IInventoryHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class AcceleratorTileEntity
extends TileEntity
implements IInventoryHelper,
IFluidHelper,
ITickable {
    public static final int fluidAmount = 10000;
    public static final int maxSubstance = 10000;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public FluidTank tank = new FluidTank(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            AcceleratorTileEntity.this.onTankContentsChanged();
        }
    };
    public int currentWheatSubstance;
    private int lastFluidAmount = -1;

    public AcceleratorTileEntity() {
        this.tank.setTileEntity((TileEntity)this);
    }

    private void onTankContentsChanged() {
        if (this.tank.getFluidAmount() != this.lastFluidAmount) {
            this.markDirtyClient();
            this.lastFluidAmount = this.tank.getFluidAmount();
        }
    }

    public void func_73660_a() {
        List cows;
        int toAdd;
        ItemStack bucket;
        FluidActionResult result;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.func_70301_a(1).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && this.func_70301_a(2).func_190926_b() && this.tank.getFluidAmount() + 1000 <= 10000 && (result = FluidUtil.tryEmptyContainer((ItemStack)(bucket = this.func_70301_a(1)), (IFluidHandler)this, (int)1000, null, (boolean)true)).isSuccess()) {
            this.func_70298_a(1, 1);
            this.func_70299_a(2, result.getResult());
            this.markDirtyClient();
        }
        if (this.func_145831_w().func_175640_z(this.func_174877_v())) {
            return;
        }
        if (!this.func_70301_a(0).func_190926_b() && this.currentWheatSubstance + FCConfig.acceleratorMax <= 10000 && (toAdd = Math.min(this.func_70301_a(0).func_190916_E(), 8)) > 0) {
            int addedMax;
            int middle = FCConfig.acceleratorMax / 2;
            boolean hasWater = this.tank.getFluidAmount() >= FCConfig.acceleratorWater;
            if (hasWater) {
                toAdd = Math.min(this.tank.getFluidAmount() / FCConfig.acceleratorWater, Math.min(this.func_70301_a(0).func_190916_E(), 32));
            }
            int n = addedMax = hasWater ? toAdd * FCConfig.acceleratorMax : toAdd * middle;
            if (this.currentWheatSubstance + addedMax > 10000) {
                int n2 = toAdd = this.currentWheatSubstance + (hasWater ? FCConfig.acceleratorMax : middle) <= 10000 ? 1 : 0;
            }
            if (toAdd > 0) {
                if (hasWater) {
                    this.tank.drain(toAdd * FCConfig.acceleratorWater, true);
                    this.currentWheatSubstance += toAdd * middle;
                }
                this.func_70298_a(0, toAdd);
                this.currentWheatSubstance += this.func_145831_w().field_73012_v.nextInt(toAdd * middle) + 1;
                this.markDirtyClient();
            }
        }
        if (this.currentWheatSubstance > FCConfig.acceleratorPerCow && !(cows = this.func_145831_w().func_72872_a(EntityFluidCow.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)FCConfig.acceleratorRadius))).isEmpty()) {
            for (EntityFluidCow cow : cows) {
                if (!cow.growTicks()) continue;
                this.currentWheatSubstance -= FCConfig.acceleratorPerCow;
                this.markDirtyClient();
                if (this.currentWheatSubstance >= FCConfig.acceleratorPerCow) continue;
                break;
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == Items.field_151015_O;
        }
        if (index == 2) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
        }
        return false;
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public int getAmount() {
        return 10000;
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        return resource.getFluid() == FluidRegistry.WATER ? this.getTank().fill(resource, doFill) : 0;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.inventory);
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("substance", this.currentWheatSubstance);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.inventory);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.tank.setTileEntity((TileEntity)this);
        this.currentWheatSubstance = tag.func_74762_e("substance");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this)) : (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank) : super.getCapability(capability, facing)));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }
}

