/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.block.sorter;

import com.google.common.base.Predicate;
import ftblag.fluidcows.FluidCows;
import ftblag.fluidcows.block.sorter.SorterBlock;
import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.util.FCUtils;
import ftblag.fluidcows.util.storage.IInventoryHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SorterTileEntity
extends TileEntity
implements IInventoryHelper,
ITickable {
    public static final Predicate<EntityFluidCow> PREDICATE = EntityAgeable::func_70631_g_;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public boolean isBlackList;
    public Set<String> filter = new HashSet<String>(5);

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        List cows = this.func_145831_w().func_175647_a(EntityFluidCow.class, this.getWorkArea(), PREDICATE);
        if (cows.size() <= 0) {
            return;
        }
        for (EntityFluidCow cow : cows) {
            if ((this.isBlackList || !this.filter.contains(cow.fluid.getName())) && (!this.isBlackList || this.filter.contains(cow.fluid.getName()))) continue;
            BlockPos newPos = this.field_174879_c.func_177972_a((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)SorterBlock.FACING));
            cow.func_70634_a((double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o() + 0.5, (double)newPos.func_177952_p() + 0.5);
        }
    }

    public AxisAlignedBB getWorkArea() {
        EnumFacing facing = (EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)SorterBlock.FACING);
        int size = Math.min(this.func_70301_a(0).func_190926_b() ? 1 : this.func_70301_a(0).func_190916_E() * 2, 14);
        return FCUtils.getAABBWithOffset(this.func_174877_v(), facing.func_176734_d(), size);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return stack.func_77973_b() == FluidCows.ranger;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.inventory);
        tag.func_74757_a("black", this.isBlackList);
        NBTTagList list = new NBTTagList();
        for (String fName : this.filter) {
            list.func_74742_a((NBTBase)new NBTTagString(fName));
        }
        tag.func_74782_a("filter", (NBTBase)list);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.inventory);
        this.isBlackList = tag.func_74767_n("black");
        this.filter.clear();
        NBTTagList list = tag.func_150295_c("filter", 8);
        for (int i = 0; i < list.func_74745_c() && i < 5; ++i) {
            String str = list.func_150307_f(i);
            if (!FluidRegistry.isFluidRegistered((String)str)) continue;
            this.filter.add(str);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this)) : super.getCapability(capability, facing));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }
}

