/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.block.stall;

import ftblag.fluidcows.FluidCows;
import ftblag.fluidcows.base.BaseBlock;
import ftblag.fluidcows.block.stall.StallTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class StallBlock
extends BaseBlock
implements ITileEntityProvider {
    private static final AxisAlignedBB STALL_BOX = new AxisAlignedBB(0.065, 0.0, 0.06, 0.935, 0.96, 1.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool HASCOW = PropertyBool.func_177716_a((String)"cow");

    public StallBlock() {
        super(Material.field_151576_e, "stall");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HASCOW, (Comparable)Boolean.valueOf(false)));
        GameRegistry.registerTileEntity(StallTileEntity.class, (String)"stall_te");
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        return worldIn.func_175625_s(pos).func_145842_c(id, param);
    }

    public static void update(World world, BlockPos pos, boolean cow) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == FluidCows.stall && (Boolean)state.func_177229_b((IProperty)HASCOW) != cow) {
            world.func_175656_a(pos, FluidCows.stall.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)HASCOW, (Comparable)Boolean.valueOf(cow)));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            player.openGui((Object)FluidCows.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((StallTileEntity)world.func_175625_s(pos)));
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        StallTileEntity te = (StallTileEntity)world.func_175625_s(pos);
        te.spawnEntity();
        for (ItemStack stack : te.getInventory()) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)HASCOW, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)HASCOW, (Comparable)Boolean.valueOf(false)), 2);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new StallTileEntity();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STALL_BOX;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)HASCOW, (Comparable)Boolean.valueOf(meta >> 2 == 1));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= ((Boolean)state.func_177229_b((IProperty)HASCOW) != false ? 1 : 0) << 2;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HASCOW});
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }
}

