/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.block.stall;

import ftblag.fluidcows.block.stall.StallBlock;
import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.gson.FCConfig;
import ftblag.fluidcows.util.FCUtils;
import ftblag.fluidcows.util.storage.IFluidHelper;
import ftblag.fluidcows.util.storage.IInventoryHelper;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class StallTileEntity
extends TileEntity
implements IInventoryHelper,
IFluidHelper,
ITickable {
    public static final int amount = 10000;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public FluidTank tank = new FluidTank(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            StallTileEntity.this.onTankContentsChanged();
        }
    };
    public boolean hasCow = false;
    @SideOnly(value=Side.CLIENT)
    public EntityFluidCow cow;
    public Fluid fluid;
    public int cd;
    private NBTTagCompound originalNBT;
    private int lastFluidAmount = -1;
    private boolean lastSync = false;

    public StallTileEntity() {
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(false);
    }

    private void onTankContentsChanged() {
        if (this.tank.getFluidAmount() != this.lastFluidAmount) {
            this.markDirtyClient();
            this.lastFluidAmount = this.tank.getFluidAmount();
        }
    }

    public void setEntity(NBTTagCompound tag) {
        this.hasCow = true;
        this.fluid = FluidRegistry.getFluid((String)tag.func_74779_i("t_fluid"));
        if (!FCConfig.isEnable(this.fluid.getName())) {
            this.fluid = FCUtils.getRandFluid();
        }
        if (this.fluid == null) {
            this.removeEntity();
        } else {
            this.cd = tag.func_74762_e("t_cd");
            this.originalNBT = tag;
            StallBlock.update(this.func_145831_w(), this.func_174877_v(), true);
            this.markDirtyClient();
        }
    }

    public NBTTagCompound removeEntity() {
        this.hasCow = false;
        NBTTagCompound tag = this.originalNBT;
        if (this.fluid != null) {
            tag.func_74778_a("t_fluid", FluidRegistry.getFluidName((Fluid)this.fluid));
            tag.func_74768_a("t_cd", this.cd);
        }
        this.originalNBT = null;
        this.fluid = null;
        this.cd = 0;
        if (this.func_145831_w() != null) {
            StallBlock.update(this.func_145831_w(), this.func_174877_v(), false);
        }
        this.markDirtyClient();
        return tag;
    }

    public void spawnEntity() {
        if (this.fluid != null) {
            EntityFluidCow cow = new EntityFluidCow(this.field_145850_b);
            cow.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5);
            cow.func_70037_a(this.removeEntity());
            this.field_145850_b.func_72838_d((Entity)cow);
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            ItemStack bucket;
            FluidActionResult result;
            if (this.cd > 0) {
                --this.cd;
                this.lastSync = false;
            }
            if (this.fluid != null && this.cd != 0 && this.cd % 300 == 0) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 9001, this.cd);
            } else if (this.cd == 0 && !this.lastSync) {
                this.markDirtyClient();
                this.lastSync = true;
            }
            if (this.cd == 0 && this.fluid != null && this.tank.getFluidAmount() <= 9000) {
                if (this.fillCopy(new FluidStack(this.fluid, 1000), true) == 1000) {
                    this.cd = FCConfig.getStallCD(this.fluid.getName());
                }
                this.markDirtyClient();
            }
            if (this.func_70301_a(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && this.func_70301_a(1).func_190926_b() && this.tank.getFluidAmount() > 0 && (result = FluidUtil.tryFillContainer((ItemStack)(bucket = this.func_70301_a(0)), (IFluidHandler)this, (int)1000, null, (boolean)true)).isSuccess()) {
                this.func_70298_a(0, 1);
                this.func_70299_a(1, result.getResult());
                this.markDirtyClient();
            }
        } else if (this.cd > 0) {
            --this.cd;
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public int getAmount() {
        return 10000;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.inventory);
        if (this.originalNBT != null) {
            tag.func_74782_a("originall", (NBTBase)this.originalNBT);
        }
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        if (this.fluid != null) {
            tag.func_74757_a("cow", this.hasCow);
            if (this.hasCow) {
                tag.func_74778_a("t_fluid", FluidRegistry.getFluidName((Fluid)this.fluid));
                tag.func_74768_a("t_cd", this.cd);
            }
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.inventory);
        this.originalNBT = (NBTTagCompound)tag.func_74781_a("originall");
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.tank.setTileEntity((TileEntity)this);
        this.hasCow = tag.func_74767_n("cow");
        if (this.hasCow) {
            this.fluid = FluidRegistry.getFluid((String)tag.func_74779_i("t_fluid"));
            this.cd = tag.func_74762_e("t_cd");
        } else {
            this.fluid = null;
            this.cd = 0;
        }
        if (this.fluid != null && !FCConfig.isEnable(this.fluid.getName())) {
            this.fluid = FCUtils.getRandFluid();
            if (this.fluid == null) {
                this.removeEntity();
            }
        } else if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.cow = this.hasCow ? new EntityFluidCow(this.func_145831_w(), this.fluid) : null;
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this)) : (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank) : super.getCapability(capability, facing)));
    }

    public boolean func_145842_c(int id, int type) {
        if (!this.field_145850_b.field_72995_K) {
            return true;
        }
        if (id == 9001) {
            this.cd = type;
        }
        return true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }
}

