/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.entity;

import ftblag.fluidcows.FluidCows;
import ftblag.fluidcows.entity.EntityCowCopy;
import ftblag.fluidcows.entity.ai.FluidCowAIMate;
import ftblag.fluidcows.gson.FCConfig;
import ftblag.fluidcows.item.ItemCowDisplayer;
import ftblag.fluidcows.util.FCUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityFluidCow
extends EntityCowCopy
implements IEntityAdditionalSpawnData {
    public static final String TYPE_FLUID = "t_fluid";
    public static final String TYPE_CD = "t_cd";
    private static final DataParameter<Integer> CD = EntityDataManager.func_187226_a(EntityFluidCow.class, (DataSerializer)DataSerializers.field_187192_b);
    public Fluid fluid = FCUtils.getRandFluid();
    boolean first = true;
    private boolean alreadyGrowth = false;
    private int cooldown = -1;

    public EntityFluidCow(World worldIn) {
        super(worldIn);
        if (this.fluid != null) {
            this.updateCD(FCConfig.getWorldCD(this.fluid.getName()));
        }
    }

    public EntityFluidCow(World world, Fluid fluid) {
        super(world);
        this.fluid = fluid;
        this.updateCD(FCConfig.getWorldCD(fluid.getName()));
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new FluidCowAIMate(this, 1.0));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CD, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.alreadyGrowth = false;
        if (this.func_70874_b() >= 0 && this.getCD() > 0) {
            --this.cooldown;
        }
        if (!this.func_130014_f_().field_72995_K && (this.first || this.cooldown != 0 && this.cooldown % 300 == 0)) {
            this.syncCD();
            this.first = false;
        }
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && !FCConfig.blackListDimIds.contains(this.field_70170_p.field_73011_w.getDimension());
    }

    public boolean growTicks() {
        if (!this.func_130014_f_().field_72995_K) {
            int age = this.func_70874_b();
            if (!this.alreadyGrowth && age < 0) {
                --age;
                age = Math.min(age + FCConfig.acceleratorMultiplier, 0);
                this.func_70873_a(age);
                if (age == 0) {
                    this.func_175500_n();
                }
                this.alreadyGrowth = true;
                return true;
            }
        }
        return false;
    }

    public int getCD() {
        return this.cooldown;
    }

    public void updateCD(int newCD) {
        this.cooldown = newCD;
    }

    public void syncCD() {
        this.field_70180_af.func_187227_b(CD, (Object)this.cooldown);
        this.field_70180_af.func_187217_b(CD);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (CD.equals(key)) {
            this.cooldown = (Integer)this.field_70180_af.func_187225_a(CD);
        }
        super.func_184206_a(key);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        int fill;
        ItemStack copy;
        IFluidHandlerItem fluidItem;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.getCD() == 0 && this.fluid != null && !this.func_70631_g_() && (fluidItem = FluidUtil.getFluidHandler((ItemStack)(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1)))) != null && (fill = fluidItem.fill(new FluidStack(this.fluid, 1000), true)) == 1000) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            copy = fluidItem.getContainer().func_77946_l();
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, copy);
            } else if (!player.field_71071_by.func_70441_a(copy)) {
                player.func_71019_a(copy, false);
            }
            this.updateCD(FCConfig.getWorldCD(this.fluid.getName()));
            this.syncCD();
            return true;
        }
        if (!(player instanceof FakePlayer)) {
            if (FCConfig.breedingItemWork && this.func_70631_g_() && stack.func_77973_b() == Items.field_151015_O) {
                this.func_175505_a(player, stack);
                this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
                return true;
            }
            if (stack.func_77973_b() == Items.field_151015_O && this.func_70874_b() == 0 && !this.func_70880_s()) {
                this.func_175505_a(player, stack);
                this.func_146082_f(player);
                return true;
            }
        }
        return false;
    }

    public boolean func_70877_b(ItemStack stack) {
        return !FCConfig.disableBreedingItemForMachines && stack.func_77973_b() == Items.field_151015_O;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return super.func_70878_b(otherAnimal) && FCConfig.canMateWith(this, (EntityFluidCow)otherAnimal);
    }

    public EntityFluidCow createChild(EntityAgeable ageable) {
        return FCConfig.mateWith(this, (EntityFluidCow)ageable);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getCD() == 0 && this.fluid != null && source instanceof EntityDamageSource) {
            ItemStack hand;
            EntityPlayer pl;
            EntityDamageSource sour = (EntityDamageSource)source;
            if (sour.field_76373_n.equals("player") && !((pl = (EntityPlayer)sour.func_76346_g()) instanceof FakePlayer) && !(hand = pl.func_184614_ca()).func_190926_b()) {
                if (hand.func_77973_b() == Items.field_151055_y) {
                    if (this.fluid.canBePlacedInWorld()) {
                        if (this.func_130014_f_().func_175623_d(this.func_180425_c()) && !this.func_130014_f_().field_72995_K) {
                            this.func_130014_f_().func_175656_a(this.func_180425_c(), this.fluid.getBlock().func_176223_P());
                        }
                        this.updateCD(FCConfig.getWorldCD(this.fluid.getName()));
                        this.syncCD();
                    } else {
                        pl.func_145747_a((ITextComponent)new TextComponentString("This fluid not supported!"));
                    }
                } else if (hand.func_77973_b() == FluidCows.halter) {
                    hand.func_77973_b().func_77644_a(hand, (EntityLivingBase)this, (EntityLivingBase)pl);
                    return false;
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public String func_70005_c_() {
        String name = super.func_70005_c_();
        if (this.fluid != null) {
            String fName = FCUtils.getFluidName(this.fluid);
            name = name + " (" + fName + ")";
        }
        return name;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.fluid != null) {
            compound.func_74778_a(TYPE_FLUID, FluidRegistry.getFluidName((Fluid)this.fluid));
        }
        compound.func_74768_a(TYPE_CD, this.getCD());
    }

    public void writeEntityToHalter(NBTTagCompound compound) {
        compound.func_74778_a(TYPE_FLUID, FluidRegistry.getFluidName((Fluid)this.fluid));
        compound.func_74768_a(TYPE_CD, this.getCD());
        compound.func_74768_a("InLove", this.field_70881_d);
        compound.func_74768_a("Age", this.func_70874_b());
        compound.func_74768_a("ForcedAge", this.field_175502_b);
        compound.func_74776_a("Health", this.func_110143_aJ());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.fluid = FluidRegistry.getFluid((String)compound.func_74779_i(TYPE_FLUID));
        if (this.fluid == null || !FCConfig.isEnable(this.fluid.getName())) {
            this.fluid = FCUtils.getRandFluid();
        }
        if (this.fluid == null) {
            this.func_70106_y();
        }
        this.updateCD(compound.func_74762_e(TYPE_CD));
        this.syncCD();
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.fluid != null) {
            String str = FluidRegistry.getFluidName((Fluid)this.fluid);
            if (str != null) {
                buffer.writeBoolean(true);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)FluidRegistry.getFluidName((Fluid)this.fluid));
            } else {
                buffer.writeBoolean(false);
            }
        } else {
            buffer.writeBoolean(false);
        }
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.getCD(), (int)5);
    }

    public void readSpawnData(ByteBuf buffer) {
        boolean tmp = buffer.readBoolean();
        if (tmp) {
            this.fluid = FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buffer));
        }
        this.updateCD(ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ItemCowDisplayer.applyFluidToItemStack(new ItemStack((Item)FluidCows.displayer), this.fluid);
    }
}

