/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.events;

import ftblag.fluidcows.FluidCows;
import ftblag.fluidcows.util.FCUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="fluidcows", value={Side.CLIENT})
public class FCClientEvents {
    private static Map<Fluid, Integer> fluidColorMap = new HashMap<Fluid, Integer>();

    @SubscribeEvent
    public static void color(ColorHandlerEvent.Item e) {
        e.getItemColors().func_186730_a((stack, tintIndex) -> FCClientEvents.getColorMultiplier(stack), new Item[]{FluidCows.displayer});
    }

    @SubscribeEvent
    public static void textureReload(TextureStitchEvent.Post event) {
        fluidColorMap.clear();
        for (Fluid fluid : FCUtils.getBucketFluids()) {
            fluidColorMap.put(fluid, FCClientEvents.getColor(fluid));
        }
    }

    public static int getColorMultiplier(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        Fluid fluid = FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("fluid"));
        return fluidColorMap.getOrDefault(fluid, 0);
    }

    private static int getColor(Fluid fluid) {
        int rgb;
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
        int color = fluid.getColor();
        if (color != (rgb = -1)) {
            rgb = new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 128).getRGB();
        } else if (icon != Minecraft.func_71410_x().func_147117_R().func_174944_f() && icon.func_147965_a(0) != null) {
            rgb = FCUtils.getColor(icon.func_147965_a(0)).getRGB();
        }
        return rgb;
    }
}

