/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.gson;

import ftblag.fluidcows.FluidCows;
import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.gson.CustomPair;
import ftblag.fluidcows.gson.JsonConfig;
import ftblag.fluidcows.util.FCUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FCConfig {
    public static final String COMMENT = "_Comment";
    public static final String RATE = "SpawnRate";
    public static final String ENABLE = "IsEnabled";
    public static final String WORLD = "WorldCooldown";
    public static final String STALL = "StallCooldown";
    public static final String BREEDING_CHANCE = "BreedingChance";
    public static final String BREEDING_COOLDOWN = "BreedingCooldown";
    public static final String GROWING_BABY = "GrowingAge";
    public static final String PARENT_1 = "Parent First";
    public static final String PARENT_2 = "Parent Second";
    public static final String COMMENT_CLIENT = "_Comment Client";
    public static final String CLIENT = "Client";
    public static final String HIDEFLUIDCOW = "HideFluidLayerCow";
    public static final String COMMENT_GENERAL = "_Comment General";
    public static final String GENERAL = "General";
    public static final String BREEDING = "BreedingItemWork";
    public static final String PROJECTETICK = "ProjectETickRemove";
    public static final String NOTENOWANDSTICK = "NotEnoughtWandsTickRemove";
    public static final String TORCHERINOTICK = "TorcherinoTickRemove";
    public static final String RANDOMTHINGSTICK = "randomthingsTickRemove";
    public static final String BREEDINGITEMMACHINES = "DisableBreedingItemForMachines";
    public static final String SPAWNWEIGHT = "FluidCowsSpawnWeight";
    public static final String SPAWNMIN = "FluidCowsSpawnMin";
    public static final String SPAWNMAX = "FluidCowsSpawnMax";
    public static final String SPAWNBLACKLIST = "FluidCowsSpawnBlackListBiomes";
    public static final String ACCELERATORMAX = "AcceleratorMaxSubstance";
    public static final String ACCELERATORRADIUS = "AcceleratorRadius";
    public static final String ACCELERATORPERCOW = "AcceleratorSubstancePerCow";
    public static final String ACCELERATORMULTIPLIER = "AcceleratorMultiplier";
    public static final String ACCELERATORWATER = "AcceleratorWaterPerConvert";
    public static final String BLACKLISTDIMIDS = "BlackListDimIds";
    public static final String ENABLECONVERTCOWTODISPLAYER = "EnableConvertCowToDisplayer";
    public static final String BLACKLISTCOWTODISPLAYER = "BlackListCowToDisplayer";
    public static final String FEEDERBLACKLIST = "FeederBlackList";
    public static final String EIOBLACKLISTSPAWNING = "EIOBlackListSpawning";
    public static final String EIOBLACKLISTSOULVIAL = "EIOBlackListSoulVial";
    public static final String EIONEEDSCLONING = "EIONeedsCloning";
    public static final String EIOENTITYCOSTMULTIPLIER = "EIOEntityCostMultiplier";
    private static final FluidInfo def = new FluidInfo(0, false, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, Integer.MIN_VALUE);
    private static JsonConfig parser;
    public static ArrayList<Fluid> FLUIDS;
    public static int sumWeight;
    public static boolean hideFluidCow;
    public static HashMap<CustomPair<String, String>, List<Fluid>> breed;
    public static HashSet<Fluid> canBreed;
    public static boolean breedingItemWork;
    public static boolean projecteTickRemove;
    public static boolean notenoughwandsTickRemove;
    public static boolean torcherinoTickRemove;
    public static boolean randomthingsTickRemove;
    public static boolean disableBreedingItemForMachines;
    public static int spawnWeight;
    public static int spawnMin;
    public static int spawnMax;
    public static String[] spawnBlackListBiomes;
    public static int acceleratorMax;
    public static int acceleratorRadius;
    public static int acceleratorPerCow;
    public static int acceleratorMultiplier;
    public static int acceleratorWater;
    public static Set<Integer> blackListDimIds;
    public static boolean enableConvertCowToDisplayer;
    public static Set<String> blackListCowToDisplayer;
    public static Set<String> feederBlackList;
    public static boolean EIOBlackListSpawning;
    public static boolean EIOBlackListSoulVial;
    public static boolean EIONeedsCloning;
    public static int EIOEntityCostMultiplier;
    private static HashMap<String, FluidInfo> registry;
    public static boolean loaded;

    public static void setFile(File file) {
        parser = new JsonConfig(file);
    }

    public static void load() {
        String fName;
        parser.load();
        parser.getOrDefString(COMMENT, RATE, "Spawn rate");
        parser.getOrDefString(COMMENT, ENABLE, "False = Disabled, true = Enabled");
        parser.getOrDefString(COMMENT, WORLD, "Cooldown if cow milked in world (not in stall, like mechanisms)");
        parser.getOrDefString(COMMENT, STALL, "Cooldown if cow milked from Stall");
        parser.getOrDefString(COMMENT, BREEDING_CHANCE, "Chance of breeding to succeed");
        parser.getOrDefString(COMMENT, BREEDING_COOLDOWN, "How many ticks it takes before the cow can breed again");
        parser.getOrDefString(COMMENT, GROWING_BABY, "How many ticks it takes for the baby cow to grow up");
        parser.getOrDefString(COMMENT, PARENT_1, "First parent to fluid (empty is disable) example usage: \"lava\" \"water\"");
        parser.getOrDefString(COMMENT, PARENT_2, "Second parent to fluid (empty is disable) example usage: \"lava\" \"water\"");
        parser.getOrDefString(COMMENT, "Tip#1", "Cow rewards? Yes! Set enable to true, rate to zero, remove parents and make recipe with CraftTweaker!");
        parser.getOrDefString(COMMENT, "Tip#2", "Only breeding cow? Yes! Set enable to true, rate to zero and add parents!");
        parser.getOrDefString(COMMENT_CLIENT, HIDEFLUIDCOW, "Disable fluid render layer cow in stall");
        hideFluidCow = parser.getOrDefBoolean(CLIENT, HIDEFLUIDCOW, false);
        parser.getOrDefString(COMMENT_GENERAL, BREEDING, "If true u can use the breeding item to get lower baby growing age");
        parser.getOrDefString(COMMENT_GENERAL, PROJECTETICK, "If true - \"Watch of Flowing Time\" not work on Cow Stall. From mod \"ProjectE\"");
        parser.getOrDefString(COMMENT_GENERAL, NOTENOWANDSTICK, "If true - \"Acceleration Wand\" not work on Cow Stall. From mod \"Not Enough Wand\"");
        parser.getOrDefString(COMMENT_GENERAL, TORCHERINOTICK, "If true - all types \"Torcherino\" not work on Cow Stall. From mod \"Torcherino\"");
        parser.getOrDefString(COMMENT_GENERAL, RANDOMTHINGSTICK, "If true - \"Time in a bottle\" not work on Cow Stall. From mod \"Random Things\"");
        parser.getOrDefString(COMMENT_GENERAL, BREEDINGITEMMACHINES, "Disables get breeding item via machines");
        parser.getOrDefString(COMMENT_GENERAL, SPAWNWEIGHT, "Fluid cows spawn weight");
        parser.getOrDefString(COMMENT_GENERAL, SPAWNMIN, "Fluid cows spawn min");
        parser.getOrDefString(COMMENT_GENERAL, SPAWNMAX, "Fluid cows spawn max");
        parser.getOrDefString(COMMENT_GENERAL, SPAWNBLACKLIST, "Fluid cows spawn black list biomes (modid:name)");
        parser.getOrDefString(COMMENT_GENERAL, ACCELERATORMAX, "Accelerator max substance per one wheat");
        parser.getOrDefString(COMMENT_GENERAL, ACCELERATORRADIUS, "Accelerator working radius");
        parser.getOrDefString(COMMENT_GENERAL, ACCELERATORPERCOW, "Accelerator one substance per one cow");
        parser.getOrDefString(COMMENT_GENERAL, ACCELERATORMULTIPLIER, "Accelerator speed up multiplier");
        parser.getOrDefString(COMMENT_GENERAL, ACCELERATORWATER, "Accelerator water per one substance convert");
        parser.getOrDefString(COMMENT_GENERAL, BLACKLISTDIMIDS, "In what dim Id cow not spawn");
        parser.getOrDefString(COMMENT_GENERAL, ENABLECONVERTCOWTODISPLAYER, "If true u can convert cow into displayer via halter");
        parser.getOrDefString(COMMENT_GENERAL, BLACKLISTCOWTODISPLAYER, "Black list for 'cow to displayer' convert");
        parser.getOrDefString(COMMENT_GENERAL, FEEDERBLACKLIST, "Black list for 'what cows cant feed with Feeder'");
        parser.getOrDefString(COMMENT_GENERAL, EIOBLACKLISTSPAWNING, "EIO Powered Spawner cant spawn any cow");
        parser.getOrDefString(COMMENT_GENERAL, EIOBLACKLISTSOULVIAL, "EIO Soul Vial cant store any cow");
        parser.getOrDefString(COMMENT_GENERAL, EIONEEDSCLONING, "EIO Powered Spawner cloning cow every time (prevents spawn random cows from spawner)");
        parser.getOrDefString(COMMENT_GENERAL, EIOENTITYCOSTMULTIPLIER, "EIO Powered Spawner need multiplier energy cost to spawn cow");
        breedingItemWork = parser.getOrDefBoolean(GENERAL, BREEDING, false);
        projecteTickRemove = parser.getOrDefBoolean(GENERAL, PROJECTETICK, false);
        notenoughwandsTickRemove = parser.getOrDefBoolean(GENERAL, NOTENOWANDSTICK, false);
        torcherinoTickRemove = parser.getOrDefBoolean(GENERAL, TORCHERINOTICK, false);
        randomthingsTickRemove = parser.getOrDefBoolean(GENERAL, RANDOMTHINGSTICK, false);
        disableBreedingItemForMachines = parser.getOrDefBoolean(GENERAL, BREEDINGITEMMACHINES, false);
        spawnWeight = parser.getOrDefInt(GENERAL, SPAWNWEIGHT, 8);
        spawnMin = parser.getOrDefInt(GENERAL, SPAWNMIN, 4);
        spawnMax = parser.getOrDefInt(GENERAL, SPAWNMAX, 4);
        spawnBlackListBiomes = parser.getOrDefStringArray(GENERAL, SPAWNBLACKLIST, new String[]{"modid:name1", "modid:name2"});
        acceleratorMax = parser.getOrDefInt(GENERAL, ACCELERATORMAX, 6);
        acceleratorRadius = parser.getOrDefInt(GENERAL, ACCELERATORRADIUS, 5);
        acceleratorPerCow = parser.getOrDefInt(GENERAL, ACCELERATORPERCOW, 1);
        acceleratorMultiplier = parser.getOrDefInt(GENERAL, ACCELERATORMULTIPLIER, 5);
        acceleratorWater = parser.getOrDefInt(GENERAL, ACCELERATORWATER, 10);
        blackListDimIds = IntStream.of(parser.getOrDefIntArray(GENERAL, BLACKLISTDIMIDS, new int[0])).boxed().collect(Collectors.toSet());
        enableConvertCowToDisplayer = parser.getOrDefBoolean(GENERAL, ENABLECONVERTCOWTODISPLAYER, true);
        blackListCowToDisplayer = Arrays.stream(parser.getOrDefStringArray(GENERAL, BLACKLISTCOWTODISPLAYER, new String[0])).collect(Collectors.toSet());
        feederBlackList = Arrays.stream(parser.getOrDefStringArray(GENERAL, FEEDERBLACKLIST, new String[0])).collect(Collectors.toSet());
        EIOBlackListSpawning = parser.getOrDefBoolean(GENERAL, EIOBLACKLISTSPAWNING, false);
        EIOBlackListSoulVial = parser.getOrDefBoolean(GENERAL, EIOBLACKLISTSOULVIAL, false);
        EIONeedsCloning = parser.getOrDefBoolean(GENERAL, EIONEEDSCLONING, true);
        EIOEntityCostMultiplier = parser.getOrDefInt(GENERAL, EIOENTITYCOSTMULTIPLIER, 0);
        registry.clear();
        FLUIDS.clear();
        sumWeight = 0;
        breed.clear();
        for (Fluid fluid : FCUtils.getBucketFluids()) {
            fName = fluid.getName();
            int rate = parser.getOrDefInt(fName, RATE, 100);
            boolean enable = parser.getOrDefBoolean(fName, ENABLE, true);
            int world = parser.getOrDefInt(fName, WORLD, 4000);
            int stall = parser.getOrDefInt(fName, STALL, 4000);
            int breedingChance = parser.getOrDefInt(fName, BREEDING_CHANCE, 50);
            int breedingCooldown = parser.getOrDefInt(fName, BREEDING_COOLDOWN, 6000);
            int growBaby = parser.getOrDefInt(fName, GROWING_BABY, -24000);
            registry.put(fName, new FluidInfo(rate, enable, world, stall, breedingChance, breedingCooldown, growBaby));
            if (!enable || rate <= 0) continue;
            FLUIDS.add(fluid);
            sumWeight += rate;
        }
        for (Fluid fluid : FCUtils.getBucketFluids()) {
            fName = fluid.getName();
            String parent1 = parser.getOrDefString(fName, PARENT_1, "");
            String parent2 = parser.getOrDefString(fName, PARENT_2, "");
            if (parent1.isEmpty() || parent2.isEmpty() || !FCConfig.isEnable(fName) || !FCConfig.isEnable(parent1) || !FCConfig.isEnable(parent2)) continue;
            if (FluidRegistry.isFluidRegistered((String)parent1) && FluidRegistry.isFluidRegistered((String)parent2)) {
                CustomPair<String, String> pair = CustomPair.of(parent1, parent2);
                List<Object> list = breed.containsKey(pair) ? breed.get(pair) : new ArrayList();
                list.add(fluid);
                breed.put(pair, list);
                canBreed.add(fluid);
                FluidCows.info("Breeding: Add new! First parent -> \"" + parent1 + "\"; Second parent -> \"" + parent2 + "\"; result -> \"" + fName + "\"");
                continue;
            }
            FluidCows.warn("Breeding: Failed to add! First parent -> \"" + parent1 + "\"; Second parent -> \"" + parent2 + "\"; result -> \"" + fName + "\"");
        }
        FluidCows.info("Added " + breed.size() + " breeding variants!");
        parser.save();
        loaded = true;
    }

    public static boolean isEnable(String name) {
        return FCConfig.registry.getOrDefault((Object)name, (FluidInfo)FCConfig.def).enable;
    }

    public static int getRate(String name) {
        return FCConfig.registry.getOrDefault((Object)name, (FluidInfo)FCConfig.def).rate;
    }

    public static int getWorldCD(String name) {
        return FCConfig.registry.getOrDefault((Object)name, (FluidInfo)FCConfig.def).world;
    }

    public static int getStallCD(String name) {
        return FCConfig.registry.getOrDefault((Object)name, (FluidInfo)FCConfig.def).stall;
    }

    public static int getChance(String name) {
        return FCConfig.registry.getOrDefault((Object)name, (FluidInfo)FCConfig.def).breedingChance;
    }

    public static int getBreedingCooldown(String name) {
        return FCConfig.registry.getOrDefault((Object)name, (FluidInfo)FCConfig.def).breedingCooldown;
    }

    public static int getGrowBaby(String name) {
        return FCConfig.registry.getOrDefault((Object)name, (FluidInfo)FCConfig.def).growBaby;
    }

    public static boolean canMateWith(EntityFluidCow parentFirst, EntityFluidCow parentSecond) {
        return parentFirst.fluid.getName().equals(parentSecond.fluid.getName()) || breed.containsKey(CustomPair.of(parentFirst.fluid.getName(), parentSecond.fluid.getName()));
    }

    public static EntityFluidCow mateWith(EntityFluidCow parentFirst, EntityFluidCow parentSecond) {
        Fluid fluid;
        if (parentFirst.fluid.getName().equals(parentSecond.fluid.getName())) {
            fluid = parentFirst.fluid;
        } else {
            Fluid res;
            CustomPair<String, String> pair = CustomPair.of(parentFirst.fluid.getName(), parentSecond.fluid.getName());
            List<Fluid> resList = breed.get(pair);
            Fluid fluid2 = res = resList.size() == 1 ? resList.get(0) : resList.get(parentFirst.func_70681_au().nextInt(resList.size()));
            fluid = parentFirst.func_70681_au().nextInt(100) < FCConfig.getChance(res.getName()) ? res : (parentFirst.func_70681_au().nextBoolean() ? parentFirst.fluid : parentSecond.fluid);
        }
        return new EntityFluidCow(parentFirst.field_70170_p, fluid);
    }

    static {
        FLUIDS = new ArrayList();
        breed = new HashMap();
        canBreed = new HashSet();
        registry = new HashMap();
    }

    private static class FluidInfo {
        public int rate;
        public boolean enable;
        public int world;
        public int stall;
        public int breedingChance;
        public int breedingCooldown;
        public int growBaby;

        public FluidInfo(int rate, boolean enable, int world, int stall, int breedingChance, int breedingCooldown, int growBaby) {
            this.rate = rate;
            this.enable = enable;
            this.world = world;
            this.stall = stall;
            this.breedingChance = breedingChance;
            this.breedingCooldown = breedingCooldown;
            this.growBaby = growBaby;
        }
    }
}

