/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.common.LoaderException;

public class JsonConfig {
    private File file;
    private JsonObject obj;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private boolean needSave;

    public JsonConfig(File file) {
        this.file = file;
    }

    public void load() {
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            this.obj = (JsonObject)this.gson.fromJson((Reader)new BufferedReader(new FileReader(this.file)), JsonObject.class);
            if (this.obj == null) {
                this.obj = new JsonObject();
            }
        }
        catch (Exception e) {
            throw new LoaderException("Failed to load FluidCows config!", (Throwable)e);
        }
    }

    public void save() {
        if (!this.needSave) {
            return;
        }
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(this.file));
            fw.write(this.gson.toJson((JsonElement)this.obj));
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void needSave() {
        this.needSave = true;
    }

    public JsonObject getOrCreateCategory(String category) {
        JsonObject object = new JsonObject();
        if (this.obj.has(category)) {
            object = this.obj.getAsJsonObject(category);
        } else {
            this.obj.add(category, (JsonElement)object);
            this.needSave();
        }
        return object;
    }

    public boolean getOrDefBoolean(String cat, String key, boolean def) {
        JsonObject category = this.getOrCreateCategory(cat);
        if (category.has(key)) {
            def = category.get(key).getAsBoolean();
        } else {
            category.addProperty(key, Boolean.valueOf(def));
            this.needSave();
        }
        return def;
    }

    public String getOrDefString(String cat, String key, String def) {
        JsonObject object = this.getOrCreateCategory(cat);
        if (object.has(key)) {
            def = object.get(key).getAsString();
        } else {
            object.addProperty(key, def);
            this.needSave();
        }
        return def;
    }

    public String[] getOrDefStringArray(String cat, String key, String[] def) {
        JsonObject object = this.getOrCreateCategory(cat);
        if (object.has(key)) {
            JsonArray array = object.getAsJsonArray(key);
            int size = array.size();
            def = new String[size];
            for (int i = 0; i < size; ++i) {
                def[i] = array.get(i).getAsString();
            }
        } else {
            JsonArray array = new JsonArray();
            for (String str : def) {
                array.add(str);
            }
            object.add(key, (JsonElement)array);
            this.needSave();
        }
        return def;
    }

    public int getOrDefInt(String cat, String key, int def) {
        JsonObject object = this.getOrCreateCategory(cat);
        if (object.has(key)) {
            def = object.get(key).getAsInt();
        } else {
            object.addProperty(key, (Number)def);
            this.needSave();
        }
        return def;
    }

    public int[] getOrDefIntArray(String cat, String key, int[] def) {
        JsonObject object = this.getOrCreateCategory(cat);
        if (object.has(key)) {
            JsonArray array = object.getAsJsonArray(key);
            int size = array.size();
            def = new int[size];
            for (int i = 0; i < size; ++i) {
                def[i] = array.get(i).getAsInt();
            }
        } else {
            JsonArray array = new JsonArray();
            for (int str : def) {
                array.add((Number)str);
            }
            object.add(key, (JsonElement)array);
            this.needSave();
        }
        return def;
    }
}

