/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.integration;

import ftblag.fluidcows.block.stall.StallTileEntity;
import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.util.FCUtils;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class HwylaIntegration {
    public static void reg() {
        FMLInterModComms.sendFunctionMessage((String)"waila", (String)"register", (String)"ftblag.fluidcows.integration.HwylaIntegration.reg");
    }

    public static void reg(IWailaRegistrar registrar) {
        InfoEntityProvider infoEntityProvider = new InfoEntityProvider();
        registrar.registerBodyProvider((IWailaEntityProvider)infoEntityProvider, EntityFluidCow.class);
        registrar.registerNBTProvider((IWailaEntityProvider)infoEntityProvider, EntityFluidCow.class);
        registrar.registerBodyProvider((IWailaDataProvider)new InfoProvider(), StallTileEntity.class);
    }

    public static class InfoProvider
    implements IWailaDataProvider {
        @Nonnull
        public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getTileEntity() instanceof StallTileEntity) {
                StallTileEntity te = (StallTileEntity)accessor.getTileEntity();
                if (te.fluid != null) {
                    tooltip.add("Fluid Name: " + FCUtils.getFluidName(te.fluid));
                    tooltip.add("Next usage: " + te.fluid.getRarity().field_77937_e + FCUtils.toTime(te.cd / 20, "Now"));
                    tooltip.add("Shift + Right Click to open inventory!");
                } else {
                    tooltip.add("Put cow in Stall with Cow Halter!");
                    tooltip.add("Shift + Right Click to put it and out");
                }
            }
            return tooltip;
        }
    }

    public static class InfoEntityProvider
    implements IWailaEntityProvider {
        @Nonnull
        public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getEntity() instanceof EntityFluidCow) {
                EntityFluidCow e = (EntityFluidCow)accessor.getEntity();
                currenttip.add("Fluid Name: " + e.fluid.getRarity().field_77937_e + FCUtils.getFluidName(e.fluid));
                currenttip.add("Next usage: " + e.fluid.getRarity().field_77937_e + FCUtils.toTime(e.getCD() / 20, "Now"));
                int age = accessor.getNBTData().func_74762_e("t_age");
                currenttip.add((age < 0 ? "Growing Age: " : "Breeding Time: ") + e.fluid.getRarity().field_77937_e + FCUtils.toTime(Math.abs(age / 20), "Ready"));
            }
            return currenttip;
        }

        @Nonnull
        public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
            if (ent instanceof EntityFluidCow) {
                tag.func_74768_a("t_age", ((EntityFluidCow)ent).func_70874_b());
            }
            return tag;
        }
    }
}

