/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.integration.jei;

import ftblag.fluidcows.FCTab;
import ftblag.fluidcows.FluidCows;
import ftblag.fluidcows.gson.CustomPair;
import ftblag.fluidcows.gson.FCConfig;
import ftblag.fluidcows.integration.jei.accelerator.AcceleratorCategory;
import ftblag.fluidcows.integration.jei.accelerator.AcceleratorWrapper;
import ftblag.fluidcows.integration.jei.breeding.BreedingCategory;
import ftblag.fluidcows.integration.jei.breeding.BreedingWrapper;
import ftblag.fluidcows.integration.jei.cowresult.CowResultCategory;
import ftblag.fluidcows.integration.jei.cowresult.CowResultWrapper;
import ftblag.fluidcows.util.FCUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;

@JEIPlugin
public class JeiPluginFC
implements IModPlugin {
    private static List<BreedingWrapper> getBreeding() {
        ArrayList<BreedingWrapper> ret = new ArrayList<BreedingWrapper>();
        for (Map.Entry<CustomPair<String, String>, List<Fluid>> entry : FCConfig.breed.entrySet()) {
            for (Fluid value : entry.getValue()) {
                ret.add(new BreedingWrapper(entry.getKey().getLeft(), entry.getKey().getRight(), value, FCConfig.getChance(value.getName())));
            }
        }
        return ret;
    }

    private static List<CowResultWrapper> getCowResult() {
        ArrayList<CowResultWrapper> ret = new ArrayList<CowResultWrapper>();
        for (Fluid fluid : FCUtils.getBucketFluids()) {
            if (!FCConfig.isEnable(fluid.getName())) continue;
            ret.add(new CowResultWrapper(fluid.getName()));
        }
        return ret;
    }

    private static List<AcceleratorWrapper> getAccelerators() {
        ArrayList<AcceleratorWrapper> ret = new ArrayList<AcceleratorWrapper>();
        ret.add(new AcceleratorWrapper(true));
        ret.add(new AcceleratorWrapper(false));
        return ret;
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{FluidCows.displayer});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BreedingCategory(guiHelper), new CowResultCategory(guiHelper), new AcceleratorCategory(guiHelper)});
    }

    public void register(IModRegistry registry) {
        registry.addRecipes(JeiPluginFC.getBreeding(), "fluidcows.breeding");
        registry.addRecipes(JeiPluginFC.getCowResult(), "fluidcows.cowresult");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)FluidCows.stall), new String[]{"fluidcows.cowresult"});
        registry.addRecipes(JeiPluginFC.getAccelerators(), "fluidcows.accelerator");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)FluidCows.accelerator), new String[]{"fluidcows.accelerator"});
        NonNullList list = NonNullList.func_191196_a();
        FluidCows.displayer.func_150895_a(FCTab.tab, (NonNullList<ItemStack>)list);
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        for (ItemStack stack : list) {
            String fName = stack.func_77978_p().func_74779_i("fluid");
            boolean enable = FCConfig.isEnable(fName);
            if (enable) continue;
            blacklist.addIngredientToBlacklist((Object)stack);
        }
    }
}

