/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.integration.jei.accelerator;

import ftblag.fluidcows.integration.jei.accelerator.AcceleratorWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class AcceleratorCategory
implements IRecipeCategory<AcceleratorWrapper> {
    public static final String UID = "fluidcows.accelerator";
    private static final ResourceLocation location = new ResourceLocation("fluidcows", "textures/gui/accelerator.png");
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;
    private final IDrawable overlay;

    public AcceleratorCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(location, 0, 0, 85, 82);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 103, 0, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.overlay = guiHelper.createDrawable(location, 86, 1, 16, 74);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return "Accelerator substance convert";
    }

    public String getModName() {
        return "Fluid Cows";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 44, 32);
    }

    public void setRecipe(IRecipeLayout recipeLayout, AcceleratorWrapper recipeWrapper, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        IGuiItemStackGroup items = recipeLayout.getItemStacks();
        items.init(0, true, 24, 32);
        items.set(ingredients);
        fluids.init(1, true, 4, 4, 16, 74, 10000, false, this.overlay);
        if (recipeWrapper.hasWater) {
            fluids.set(ingredients);
        }
    }
}

