/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.integration.jei.cowresult;

import ftblag.fluidcows.integration.jei.cowresult.CowResultWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class CowResultCategory
implements IRecipeCategory<CowResultWrapper> {
    public static final String UID = "fluidcows.cowresult";
    private static final ResourceLocation location = new ResourceLocation("fluidcows", "textures/gui/cowresult.png");
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;
    private final IDrawable overlay;

    public CowResultCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(location, 0, 0, 70, 82);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 88, 0, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.overlay = guiHelper.createDrawable(location, 71, 1, 16, 74);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return "Cow Result";
    }

    public String getModName() {
        return "Fluid Cows";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 23, 31);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CowResultWrapper recipeWrapper, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        IGuiItemStackGroup items = recipeLayout.getItemStacks();
        items.init(0, true, 3, 32);
        items.set(ingredients);
        fluids.init(1, false, 50, 4, 16, 74, 10000, false, this.overlay);
        fluids.set(ingredients);
    }
}

