/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.item;

import ftblag.fluidcows.base.BaseItem;
import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.gson.FCConfig;
import ftblag.fluidcows.util.FCUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCowDisplayer
extends BaseItem {
    public ItemCowDisplayer() {
        super("cow_displayer");
    }

    public static ItemStack applyFluidToItemStack(ItemStack stack, Fluid fluid) {
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a("fluid", fluid.getName());
        stack.func_77982_d(tag);
        return stack;
    }

    public static Entity spawnCreature(World worldIn, Fluid fluid, double x, double y, double z) {
        EntityFluidCow entity = new EntityFluidCow(worldIn, fluid);
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        entity.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
        worldIn.func_72838_d((Entity)entity);
        entity.func_70642_aH();
        return entity;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Fluid fluid : FCUtils.getBucketFluids()) {
                items.add((Object)ItemCowDisplayer.applyFluidToItemStack(new ItemStack((Item)this), fluid));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        String fName;
        boolean enable;
        if (stack.func_77942_o() && FCConfig.loaded && (enable = FCConfig.isEnable(fName = stack.func_77978_p().func_74779_i("fluid")))) {
            Fluid fluid = FluidRegistry.getFluid((String)fName);
            int rate = FCConfig.getRate(fName);
            boolean canBreeding = FCConfig.canBreed.contains(fluid);
            String desc = canBreeding ? (rate == 0 ? "Cow can only be breed" : "Cow spawns in the world but can also be breed") : (rate != 0 ? "Cow spawns in the world" : (enable ? "This cow is crafted" : "NULL"));
            tooltip.add("Fluid Name: " + FCUtils.getFluidName(fluid));
            tooltip.add("World cooldown: " + FCConfig.getWorldCD(fName));
            tooltip.add("Stall cooldown: " + FCConfig.getStallCD(fName));
            tooltip.add(TextFormatting.RED + "Spawn: " + desc);
            tooltip.add("Right click to spawn cow");
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("fluid", 8)) {
            String name = FCUtils.getFluidName(FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("fluid")));
            return I18n.func_74838_a((String)"entity.fluidcows.fluidcow.name").trim() + ": " + name;
        }
        return "Error";
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        String fName = itemstack.func_77978_p().func_74779_i("fluid");
        if (!FCConfig.isEnable(fName)) {
            player.func_145747_a((ITextComponent)new TextComponentString("Failed to spawn cow, due to its disabled"));
            return EnumActionResult.FAIL;
        }
        Entity entity = ItemCowDisplayer.spawnCreature(worldIn, FluidRegistry.getFluid((String)fName), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("Failed to spawn cow!"));
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72321_a(0.0, -1.0, 0.0);
        List list = world.func_184144_a(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)pos.func_177956_o();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                Entity entity = ItemCowDisplayer.spawnCreature(worldIn, FluidRegistry.getFluid((String)itemstack.func_77978_p().func_74779_i("fluid")), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }
}

