/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.item;

import ftblag.fluidcows.FluidCows;
import ftblag.fluidcows.base.BaseItem;
import ftblag.fluidcows.block.stall.StallTileEntity;
import ftblag.fluidcows.entity.EntityFluidCow;
import ftblag.fluidcows.gson.FCConfig;
import ftblag.fluidcows.item.ItemCowDisplayer;
import ftblag.fluidcows.util.FCUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCowHalter
extends BaseItem {
    public ItemCowHalter() {
        super("cow_halter");
        this.func_77625_d(1);
    }

    public static boolean constCow(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("t_fluid") && stack.func_77978_p().func_74764_b("t_cd");
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (!(entity instanceof EntityFluidCow) || player.field_70170_p.field_72995_K || hand == EnumHand.OFF_HAND || ItemCowHalter.constCow(stack) || player.field_71093_bK != entity.field_71093_bK) {
            return false;
        }
        if (((EntityFluidCow)entity).func_70874_b() < 0) {
            return false;
        }
        if (entity.field_70128_L) {
            return false;
        }
        ItemStack halter = new ItemStack((Item)this);
        NBTTagCompound tag = new NBTTagCompound();
        ((EntityFluidCow)entity).writeEntityToHalter(tag);
        halter.func_77982_d(tag);
        if (!player.field_71071_by.func_70441_a(halter)) {
            player.func_71019_a(halter, false);
        }
        player.func_184598_c(hand);
        player.field_70170_p.func_72900_e((Entity)entity);
        stack.func_190918_g(1);
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || hand == EnumHand.OFF_HAND) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() == FluidCows.stall) {
            StallTileEntity te = (StallTileEntity)world.func_175625_s(pos);
            if (ItemCowHalter.constCow(stack) && te.fluid == null) {
                te.setEntity(stack.func_77978_p());
                stack.func_77982_d(null);
                return EnumActionResult.SUCCESS;
            }
            if (!ItemCowHalter.constCow(stack) && te.fluid != null) {
                stack.func_77982_d(te.removeEntity());
                return EnumActionResult.SUCCESS;
            }
        } else if (ItemCowHalter.constCow(stack)) {
            BlockPos spawn = pos.func_177972_a(facing);
            EntityFluidCow cow = new EntityFluidCow(world);
            cow.func_70080_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.5, (double)spawn.func_177952_p() + 0.5, Math.abs(player.field_70177_z), 0.0f);
            cow.func_70037_a(stack.func_77978_p());
            world.func_72838_d((Entity)cow);
            stack.func_77982_d(null);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        if (player instanceof EntityPlayer && target instanceof EntityFluidCow) {
            if (FCConfig.enableConvertCowToDisplayer) {
                EntityFluidCow cow = (EntityFluidCow)target;
                if (!FCConfig.blackListCowToDisplayer.contains(cow.fluid.getName())) {
                    ItemStack displayer = ItemCowDisplayer.applyFluidToItemStack(new ItemStack((Item)FluidCows.displayer), cow.fluid);
                    if (((EntityPlayer)player).field_71071_by.func_70441_a(displayer)) {
                        cow.func_70106_y();
                        return true;
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("You cant convert fluid from cow."));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("This feature disabled."));
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemCowHalter.constCow(stack)) {
            Fluid fluid = FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("t_fluid"));
            tooltip.add("Fluid name: " + FCUtils.getFluidName(fluid));
            tooltip.add("Next usage: " + FCUtils.toTime(stack.func_77978_p().func_74762_e("t_cd") / 20, "Now"));
        } else {
            tooltip.add("Empty. Right Click on cow to pick it up!");
        }
        tooltip.add(TextFormatting.RED + "!Warning!");
        tooltip.add("Left Click on cow to convert cow to displayer!");
        tooltip.add(TextFormatting.RED + "!Warning!");
    }
}

