/*
 * Decompiled with CFR 0.152.
 */
package ftblag.fluidcows.util;

import com.google.common.collect.Sets;
import ftblag.fluidcows.gson.FCConfig;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class FCUtils {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    public static Map<String, ResourceLocation> fluidRL = new HashMap<String, ResourceLocation>();
    public static Map<String, String> fluidName = new HashMap<String, String>();
    private static Set<String> bucketFluids = (Set)ReflectionHelper.getPrivateValue(FluidRegistry.class, null, (String[])new String[]{"bucketFluids"});
    public static ItemStack WATER_BOTTLE;
    public static final FluidStack WATER_BOTTLE_STACK;

    public static Set<Fluid> getBucketFluids() {
        Set<Fluid> currentBucketFluids = null;
        HashSet tmp = Sets.newHashSet();
        for (String fluidName : bucketFluids) {
            tmp.add(FluidRegistry.getFluid((String)fluidName));
        }
        currentBucketFluids = Collections.unmodifiableSet(tmp);
        return currentBucketFluids;
    }

    public static Fluid getRandFluid() {
        if (FCConfig.FLUIDS.size() > 0) {
            double search = Math.random() * (double)FCConfig.sumWeight;
            int curr = 0;
            for (Fluid fluid : FCConfig.FLUIDS) {
                if (!((double)(curr += FCConfig.getRate(fluid.getName())) >= search)) continue;
                return fluid;
            }
        }
        return null;
    }

    public static String getFluidName(Fluid fluid) {
        if (fluid == null) {
            return "ERROR";
        }
        if (!fluidName.containsKey(fluid.getName())) {
            fluidName.put(fluid.getName(), fluid.getLocalizedName(new FluidStack(fluid, 0)));
        }
        return fluidName.get(fluid.getName());
    }

    public static ResourceLocation getFluidRL(Fluid fluid) {
        if (!fluidRL.containsKey(fluid.getName())) {
            fluidRL.put(fluid.getName(), new ResourceLocation(fluid.getStill().func_110624_b(), "textures/" + fluid.getStill().func_110623_a() + ".png"));
        }
        return fluidRL.get(fluid.getName());
    }

    public static Color getColor(int[][] arrays) {
        if (arrays.length == 0) {
            return Color.WHITE;
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        int len = 0;
        for (int[] array : arrays) {
            len += array.length;
            for (int color : array) {
                red += color >> 16 & 0xFF;
                green += color >> 8 & 0xFF;
                blue += color & 0xFF;
            }
        }
        return new Color(red / len, green / len, blue / len, 128);
    }

    public static String toTime(int secondstoAdd, String zero) {
        int newSofd = (secondstoAdd % 86400 + 86400) % 86400;
        int newHour = newSofd / 3600;
        int newMinute = newSofd / 60 % 60;
        int newSecond = newSofd % 60;
        if (newHour == 0 && newMinute == 0 && newSecond == 0) {
            return zero;
        }
        return newHour != 0 ? String.format("%02d:%02d:%02d", newHour, newMinute, newSecond) : String.format("%02d:%02d", newMinute, newSecond);
    }

    public static ResourceLocation gLoc(String s) {
        return FCUtils.getRL("textures/gui/" + s + ".png");
    }

    public static ResourceLocation getRL(String s) {
        return new ResourceLocation("fluidcows", s);
    }

    public static AxisAlignedBB getAABBWithOffset(BlockPos pos, EnumFacing facing, int size) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
        aabb = FCUtils.growWithCustomY(aabb.func_186670_a(BlockPos.field_177992_a.func_177967_a(facing, size + 1)), size);
        return aabb;
    }

    private static AxisAlignedBB growWithCustomY(AxisAlignedBB aabb, int size) {
        double minX = aabb.field_72340_a - (double)size;
        double minY = aabb.field_72338_b;
        double minZ = aabb.field_72339_c - (double)size;
        double maxX = aabb.field_72336_d + (double)size;
        double maxY = aabb.field_72337_e + (double)(size * 2);
        double maxZ = aabb.field_72334_f + (double)size;
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    static {
        WATER_BOTTLE_STACK = new FluidStack(FluidRegistry.WATER, 250);
        WATER_BOTTLE = new ItemStack((Item)Items.field_151068_bn);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Potion", "minecraft:water");
        WATER_BOTTLE.func_77982_d(tag);
    }
}

