/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketBoxBlacklist;
import mekanism.common.network.PacketConfigSync;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.network.PacketSecurityUpdate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CommonPlayerTracker {
    public CommonPlayerTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = event.player.func_184102_h();
        if (!event.player.field_70170_p.field_72995_K) {
            if (server == null || !server.func_71264_H()) {
                Mekanism.packetHandler.sendTo(new PacketConfigSync.ConfigSyncMessage(MekanismConfig.local()), (EntityPlayerMP)event.player);
                Mekanism.logger.info("Sent config to '" + event.player.getDisplayNameString() + ".'");
            }
            Mekanism.packetHandler.sendTo(new PacketBoxBlacklist.BoxBlacklistMessage(), (EntityPlayerMP)event.player);
            this.syncChangedData((EntityPlayerMP)event.player);
            Mekanism.packetHandler.sendTo(new PacketSecurityUpdate.SecurityUpdateMessage(PacketSecurityUpdate.SecurityPacket.FULL, null, null), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Mekanism.playerState.clearPlayer(event.player.func_110124_au());
        Mekanism.freeRunnerOn.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        Mekanism.playerState.clearPlayer(event.player.func_110124_au());
        Mekanism.freeRunnerOn.remove(event.player.func_110124_au());
        if (!event.player.field_70170_p.field_72995_K) {
            this.syncChangedData((EntityPlayerMP)event.player);
        }
    }

    private void syncChangedData(EntityPlayerMP player) {
        Mekanism.packetHandler.sendTo(PacketJetpackData.JetpackDataMessage.FULL(Mekanism.playerState.getActiveJetpacks()), player);
        Mekanism.packetHandler.sendTo(PacketScubaTankData.ScubaTankDataMessage.FULL(Mekanism.playerState.getActiveGasmasks()), player);
        Mekanism.packetHandler.sendTo(PacketFlamethrowerData.FlamethrowerDataMessage.FULL(Mekanism.playerState.getActiveFlamethrowers()), player);
        Mekanism.packetHandler.sendTo(new PacketFreeRunnerData.FreeRunnerDataMessage(PacketFreeRunnerData.FreeRunnerPacket.FULL, null, false), player);
    }
}

